/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.material;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.ItemHandlerHelper;
import slimeknights.mantle.data.loadable.common.IngredientLoadable;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.recipe.ICustomOutputRecipe;
import slimeknights.mantle.recipe.container.ISingleStackContainer;
import slimeknights.mantle.recipe.helper.ItemOutput;
import slimeknights.mantle.recipe.helper.LoadableRecipeSerializer;
import slimeknights.tconstruct.library.materials.definition.IMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialVariant;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.recipe.TinkerRecipeTypes;
import slimeknights.tconstruct.library.recipe.material.IMaterialValue;
import slimeknights.tconstruct.library.recipe.material.MaterialRecipeCache;
import slimeknights.tconstruct.tables.TinkerTables;

public class MaterialRecipe
implements ICustomOutputRecipe<ISingleStackContainer>,
IMaterialValue {
    public static final MaterialRecipe EMPTY = new MaterialRecipe(new ResourceLocation("missingno"), "", Ingredient.f_43901_, 0, 0, IMaterial.UNKNOWN_ID, ItemOutput.EMPTY);
    public static final RecordLoadable<MaterialRecipe> LOADER = RecordLoadable.create((RecordField)ContextKey.ID.requiredField(), (RecordField)LoadableRecipeSerializer.RECIPE_GROUP, (RecordField)IngredientLoadable.DISALLOW_EMPTY.requiredField("ingredient", MaterialRecipe::getIngredient), IMaterialValue.VALUE_FIELD, IMaterialValue.NEEDED_FIELD, (RecordField)MaterialVariantId.LOADABLE.requiredField("material", r -> r.getMaterial().getVariant()), (RecordField)ItemOutput.Loadable.OPTIONAL_STACK.emptyField("leftover", r -> r.leftover), MaterialRecipe::new);
    public static final float INGOTS_PER_REPAIR = 3.0f;
    protected final ResourceLocation id;
    protected final String group;
    protected final Ingredient ingredient;
    protected final int value;
    protected final int needed;
    protected final MaterialVariant material;
    protected final ItemOutput leftover;
    private List<ItemStack> displayItems = null;

    public MaterialRecipe(ResourceLocation id, String group, Ingredient ingredient, int value, int needed, MaterialVariantId materialId, ItemOutput leftover) {
        this.id = id;
        this.group = group;
        this.ingredient = ingredient;
        this.value = value;
        this.needed = needed;
        this.material = MaterialVariant.of(materialId);
        this.leftover = value > 1 ? leftover : ItemOutput.EMPTY;
        MaterialRecipeCache.registerRecipe(this);
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)TinkerRecipeTypes.MATERIAL.get();
    }

    public ItemStack m_8042_() {
        return new ItemStack(TinkerTables.partBuilder);
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerTables.materialRecipeSerializer.get();
    }

    @Override
    public boolean hasLeftover() {
        return !this.leftover.isEmpty();
    }

    @Override
    public ItemStack getLeftover() {
        return this.leftover.get().m_41777_();
    }

    public boolean matches(ISingleStackContainer inv, Level worldIn) {
        return !this.material.isUnknown() && this.ingredient.test(inv.getStack());
    }

    public NonNullList<Ingredient> m_7527_() {
        return NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{this.ingredient});
    }

    public List<ItemStack> getDisplayItems() {
        if (this.displayItems == null) {
            this.displayItems = this.needed > 1 ? Arrays.stream(this.ingredient.m_43908_()).map(stack -> ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)this.needed)).collect(Collectors.toList()) : Arrays.asList(this.ingredient.m_43908_());
        }
        return this.displayItems;
    }

    public float scaleRepair(float amount) {
        return (float)this.getValue() * amount / 3.0f / (float)this.getNeeded();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public String m_6076_() {
        return this.group;
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public int getNeeded() {
        return this.needed;
    }

    @Override
    public MaterialVariant getMaterial() {
        return this.material;
    }
}

