/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.recipe.material;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.field.LoadableField;
import slimeknights.mantle.recipe.helper.LoggingRecipeSerializer;
import slimeknights.mantle.util.LogicHelper;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.recipe.material.MaterialRecipeCache;
import slimeknights.tconstruct.library.recipe.material.MaterialsCraftingTableRecipe;
import slimeknights.tconstruct.library.tools.nbt.MaterialNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.part.IMaterialItem;
import slimeknights.tconstruct.tables.TinkerTables;

public class ShapedMaterialsRecipe
extends ShapedRecipe
implements MaterialsCraftingTableRecipe {
    private final List<Ingredient> parts;
    private final boolean checkRepeats;
    private final List<MaterialVariantId> extraMaterials;

    public ShapedMaterialsRecipe(ResourceLocation id, String group, CraftingBookCategory category, int width, int height, NonNullList<Ingredient> ingredients, ItemStack result, boolean showNotification, List<Ingredient> parts, List<MaterialVariantId> extraMaterials) {
        super(id, group, category, width, height, ingredients, result, showNotification);
        this.parts = parts;
        this.checkRepeats = ((Stream)parts.stream().unordered()).distinct().count() == (long)parts.size();
        this.extraMaterials = extraMaterials;
    }

    @Override
    public int getPartCount() {
        return this.parts.size();
    }

    @Nullable
    static MaterialVariantId[] findMaterials(CraftingContainer inventory, List<Ingredient> parts, int partCount, boolean checkRepeats) {
        MaterialVariantId[] materials = new MaterialVariantId[partCount];
        block0: for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (stack.m_41619_()) continue;
            for (int p = 0; p < partCount; ++p) {
                MaterialVariantId matched;
                MaterialVariantId current = materials[p];
                if (current != null && !checkRepeats || !parts.get(p).test(stack)) continue;
                Item item = stack.m_41720_();
                if (item instanceof IMaterialItem) {
                    IMaterialItem materialItem = (IMaterialItem)item;
                    matched = materialItem.getMaterial(stack);
                } else {
                    matched = MaterialRecipeCache.findRecipe(stack).getMaterial().getVariant();
                }
                if (current == null) {
                    materials[p] = matched;
                    continue block0;
                }
                if (current.matchesVariant(matched)) continue;
                if (current.getId().equals(matched.getId())) {
                    materials[p] = current.getId();
                    continue block0;
                }
                return null;
            }
        }
        for (int p = 0; p < partCount; ++p) {
            if (materials[p] != null) continue;
            return null;
        }
        return materials;
    }

    public boolean m_5818_(CraftingContainer inventory, Level level) {
        if (!super.m_5818_(inventory, level)) {
            return false;
        }
        return ShapedMaterialsRecipe.findMaterials(inventory, this.parts, this.parts.size(), this.checkRepeats) != null;
    }

    public static void setMaterial(ItemStack stack, MaterialVariantId material, List<MaterialVariantId> extraMaterials) {
        Item item;
        if (extraMaterials.isEmpty() && (item = stack.m_41720_()) instanceof IMaterialItem) {
            IMaterialItem materialItem = (IMaterialItem)item;
            materialItem.setMaterial(stack, material);
        } else {
            MaterialNBT.Builder builder = MaterialNBT.builder();
            builder.add(material);
            for (MaterialVariantId extraMaterial : extraMaterials) {
                builder.add(extraMaterial);
            }
            ToolStack.from(stack).setMaterials(builder.build());
        }
    }

    @Override
    public void setMaterial(ItemStack stack, MaterialVariantId material) {
        ShapedMaterialsRecipe.setMaterial(stack, material, this.extraMaterials);
    }

    static ItemStack assemble(ItemStack stack, CraftingContainer inventory, List<Ingredient> parts, int partCount, boolean checkRepeats, List<MaterialVariantId> extraMaterials) {
        Item materials = ShapedMaterialsRecipe.findMaterials(inventory, parts, partCount, checkRepeats);
        if (materials != null) {
            Item item;
            if (((MaterialVariantId[])materials).length == 1 && extraMaterials.isEmpty() && (item = stack.m_41720_()) instanceof IMaterialItem) {
                IMaterialItem materialItem = (IMaterialItem)item;
                return materialItem.setMaterial(stack, (MaterialVariantId)materials[0]);
            }
            MaterialNBT.Builder builder = MaterialNBT.builder();
            for (Item material : materials) {
                builder.add((MaterialVariantId)material);
            }
            builder.add(extraMaterials);
            ToolStack.from(stack).setMaterials(builder.build());
        }
        return stack;
    }

    public ItemStack m_5874_(CraftingContainer inventory, RegistryAccess registryAccess) {
        return ShapedMaterialsRecipe.assemble(super.m_5874_(inventory, registryAccess), inventory, this.parts, this.parts.size(), this.checkRepeats, this.extraMaterials);
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)TinkerTables.shapedMaterialsRecipeSerializer.get();
    }

    @Override
    public List<Ingredient> getParts() {
        return this.parts;
    }

    @Override
    public List<MaterialVariantId> getExtraMaterials() {
        return this.extraMaterials;
    }

    public static class Serializer
    implements LoggingRecipeSerializer<ShapedMaterialsRecipe> {
        static final Loadable<List<MaterialVariantId>> EXTRA_MATERIALS = MaterialVariantId.LOADABLE.list(0);
        static final LoadableField<List<MaterialVariantId>, ShapedMaterialsRecipe> MATERIAL_FIELD = EXTRA_MATERIALS.defaultField("extra_materials", List.of(), r -> r.extraMaterials);

        public ShapedMaterialsRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            CraftingBookCategory category = (CraftingBookCategory)CraftingBookCategory.f_244644_.m_262792_(GsonHelper.m_13851_((JsonObject)json, (String)"category", null), (Enum)CraftingBookCategory.MISC);
            Map key = ShapedRecipe.m_44210_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"key"));
            String[] pattern = ShapedRecipe.m_44186_((String[])ShapedRecipe.m_44196_((JsonArray)GsonHelper.m_13933_((JsonObject)json, (String)"pattern")));
            int width = pattern[0].length();
            int height = pattern.length;
            NonNullList inputs = ShapedRecipe.m_44202_((String[])pattern, (Map)key, (int)width, (int)height);
            ItemStack result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            boolean showNotification = GsonHelper.m_13855_((JsonObject)json, (String)"show_notification", (boolean)true);
            String partPattern = GsonHelper.m_13906_((JsonObject)json, (String)"parts");
            ArrayList<Ingredient> parts = new ArrayList<Ingredient>();
            for (int i = 0; i < partPattern.length(); ++i) {
                String sym = partPattern.substring(i, i + 1);
                Ingredient ingredient = (Ingredient)key.get(sym);
                if (ingredient == null) {
                    throw new JsonSyntaxException("Parts references symbol '" + sym + "' but it's not defined in the key");
                }
                parts.add(ingredient);
            }
            return new ShapedMaterialsRecipe(recipeId, group, category, width, height, (NonNullList<Ingredient>)inputs, result, showNotification, List.copyOf(parts), (List)MATERIAL_FIELD.get(json));
        }

        @Nullable
        public ShapedMaterialsRecipe fromNetworkSafe(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int width = buffer.m_130242_();
            int height = buffer.m_130242_();
            String group = buffer.m_130277_();
            CraftingBookCategory category = (CraftingBookCategory)buffer.m_130066_(CraftingBookCategory.class);
            ItemStack result = buffer.m_130267_();
            boolean showNotification = buffer.readBoolean();
            List extraMaterials = (List)MATERIAL_FIELD.decode(buffer);
            int size = buffer.m_130242_();
            ArrayList<Ingredient> distinct = new ArrayList<Ingredient>(size);
            for (int i = 0; i < size; ++i) {
                distinct.add(Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            NonNullList inputs = NonNullList.m_122780_((int)(width * height), (Object)Ingredient.f_43901_);
            for (int i = 0; i < inputs.size(); ++i) {
                inputs.set(i, (Object)((Ingredient)LogicHelper.getOrDefault(distinct, (int)buffer.readByte(), (Object)Ingredient.f_43901_)));
            }
            size = buffer.m_130242_();
            ArrayList<Ingredient> parts = new ArrayList<Ingredient>(size);
            for (int i = 0; i < size; ++i) {
                parts.add(i, (Ingredient)LogicHelper.getOrDefault(distinct, (int)buffer.readByte(), (Object)Ingredient.f_43901_));
            }
            return new ShapedMaterialsRecipe(recipeId, group, category, width, height, (NonNullList<Ingredient>)inputs, result, showNotification, List.copyOf(parts), extraMaterials);
        }

        public void toNetworkSafe(FriendlyByteBuf buffer, ShapedMaterialsRecipe recipe) {
            buffer.m_130130_(recipe.m_44220_());
            buffer.m_130130_(recipe.m_44221_());
            buffer.m_130070_(recipe.m_6076_());
            buffer.m_130068_((Enum)recipe.m_245232_());
            buffer.m_130055_(recipe.f_44149_);
            buffer.writeBoolean(recipe.m_271738_());
            MATERIAL_FIELD.encode(buffer, (Object)recipe);
            NonNullList inputs = recipe.m_7527_();
            List distinct = ((Stream)inputs.stream().unordered()).distinct().toList();
            buffer.m_130130_(distinct.size());
            for (Ingredient ingredient : distinct) {
                ingredient.m_43923_(buffer);
            }
            for (Ingredient ingredient : inputs) {
                buffer.writeByte(distinct.indexOf(ingredient));
            }
            buffer.m_130130_(recipe.parts.size());
            for (Ingredient ingredient : recipe.parts) {
                buffer.writeByte(distinct.indexOf(ingredient));
            }
        }
    }
}

