/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.data;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.features.TreeFeatures;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.MangrovePropaguleBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.GeodeBlockSettings;
import net.minecraft.world.level.levelgen.GeodeCrackSettings;
import net.minecraft.world.level.levelgen.GeodeLayerSettings;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.GeodeConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.RandomSpreadFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.RandomizedIntStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.AttachedToLeavesDecorator;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.UpwardsBranchingTrunkPlacer;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ForgeBiomeModifiers;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.holdersets.AndHolderSet;
import net.minecraftforge.registries.holdersets.NotHolderSet;
import net.minecraftforge.registries.holdersets.OrHolderSet;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.common.registration.GeodeItemObject;
import slimeknights.tconstruct.shared.block.SlimeType;
import slimeknights.tconstruct.world.TinkerStructures;
import slimeknights.tconstruct.world.TinkerWorld;
import slimeknights.tconstruct.world.block.CongealedSlimeBlock;
import slimeknights.tconstruct.world.block.FoliageType;
import slimeknights.tconstruct.world.block.SlimeVineBlock;
import slimeknights.tconstruct.world.worldgen.islands.IslandStructure;
import slimeknights.tconstruct.world.worldgen.trees.ExtraRootVariantPlacer;
import slimeknights.tconstruct.world.worldgen.trees.LeaveVineDecorator;
import slimeknights.tconstruct.world.worldgen.trees.config.SlimeFungusConfig;
import slimeknights.tconstruct.world.worldgen.trees.config.SlimeTreeConfig;

public class WorldgenProvider {
    private WorldgenProvider() {
    }

    public static void register(RegistrySetBuilder builder) {
        builder.m_254916_(Registries.f_256911_, WorldgenProvider::registerConfiguredFeatures);
        builder.m_254916_(Registries.f_256988_, WorldgenProvider::registerPlacedFeatures);
        builder.m_254916_(Registries.f_256944_, WorldgenProvider::registerStructures);
        builder.m_254916_(Registries.f_256998_, WorldgenProvider::registerStructureSets);
        builder.m_254916_(ForgeRegistries.Keys.BIOME_MODIFIERS, WorldgenProvider::registerBiomeModifiers);
    }

    private static void registerConfiguredFeatures(BootstapContext<ConfiguredFeature<?, ?>> context) {
        WorldgenProvider.register(context, TinkerStructures.earthSlimeTree, TinkerStructures.slimeTree, new SlimeTreeConfig.Builder().planted().trunk(TinkerWorld.greenheart.getLog()).leaves((Block)TinkerWorld.slimeLeaves.get((Enum)FoliageType.EARTH)).baseHeight(4).randomHeight(3).build());
        WorldgenProvider.register(context, TinkerStructures.skySlimeTree, TinkerStructures.slimeTree, new SlimeTreeConfig.Builder().planted().canDoubleHeight().trunk(TinkerWorld.skyroot.getLog()).leaves((Block)TinkerWorld.slimeLeaves.get((Enum)FoliageType.SKY)).build());
        WorldgenProvider.register(context, TinkerStructures.earthSlimeIslandTree, TinkerStructures.slimeTree, new SlimeTreeConfig.Builder().trunk(TinkerWorld.greenheart.getLog()).leaves((Block)TinkerWorld.slimeLeaves.get((Enum)FoliageType.EARTH)).baseHeight(4).randomHeight(3).build());
        WorldgenProvider.register(context, TinkerStructures.skySlimeIslandTree, TinkerStructures.slimeTree, new SlimeTreeConfig.Builder().canDoubleHeight().trunk(TinkerWorld.skyroot.getLog()).leaves((Block)TinkerWorld.slimeLeaves.get((Enum)FoliageType.SKY)).vines((BlockState)((SlimeVineBlock)TinkerWorld.skySlimeVine.get()).m_49966_().m_61124_(SlimeVineBlock.STAGE, (Comparable)((Object)SlimeVineBlock.VineStage.MIDDLE))).build());
        WorldgenProvider.register(context, TinkerStructures.enderSlimeTree, Feature.f_65760_, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)TinkerWorld.enderbark.getLog()), (TrunkPlacer)new UpwardsBranchingTrunkPlacer(2, 1, 4, (IntProvider)UniformInt.m_146622_((int)1, (int)4), 0.5f, (IntProvider)UniformInt.m_146622_((int)0, (int)1), (HolderSet)BuiltInRegistries.f_256975_.m_203561_(TinkerTags.Blocks.ENDERBARK_LOGS_CAN_GROW_THROUGH)), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)TinkerWorld.slimeLeaves.get((Enum)FoliageType.ENDER))), (FoliagePlacer)new RandomSpreadFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)3), (IntProvider)ConstantInt.m_146483_((int)0), (IntProvider)ConstantInt.m_146483_((int)2), 70), ExtraRootVariantPlacer.builder().trunkOffset((IntProvider)UniformInt.m_146622_((int)1, (int)3)).rootBlock((Block)TinkerWorld.enderbarkRoots.get()).canGrowThroughTag(TinkerTags.Blocks.ENDERBARK_ROOTS_CAN_GROW_THROUGH).slimyRoots(TinkerWorld.slimyEnderbarkRoots).buildOptional(), (FeatureSize)new TwoLayersFeatureSize(2, 0, 2)).m_68249_(List.of(new LeaveVineDecorator((Block)TinkerWorld.enderSlimeVine.get(), 0.125f), new AttachedToLeavesDecorator(0.14f, 1, 0, (BlockStateProvider)new RandomizedIntStateProvider((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)((BlockState)((Block)TinkerWorld.slimeSapling.get((Enum)FoliageType.ENDER)).m_49966_().m_61124_((Property)BlockStateProperties.f_61435_, (Comparable)Boolean.valueOf(true)))), MangrovePropaguleBlock.f_221441_, (IntProvider)UniformInt.m_146622_((int)0, (int)4)), 2, List.of(Direction.DOWN)))).m_68244_().m_68251_());
        WorldgenProvider.register(context, TinkerStructures.enderSlimeTreeTall, Feature.f_65760_, new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.m_191382_((Block)TinkerWorld.enderbark.getLog()), (TrunkPlacer)new UpwardsBranchingTrunkPlacer(4, 1, 9, (IntProvider)UniformInt.m_146622_((int)1, (int)6), 0.5f, (IntProvider)UniformInt.m_146622_((int)0, (int)1), (HolderSet)BuiltInRegistries.f_256975_.m_203561_(TinkerTags.Blocks.ENDERBARK_LOGS_CAN_GROW_THROUGH)), (BlockStateProvider)BlockStateProvider.m_191382_((Block)((Block)TinkerWorld.slimeLeaves.get((Enum)FoliageType.ENDER))), (FoliagePlacer)new RandomSpreadFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)3), (IntProvider)ConstantInt.m_146483_((int)0), (IntProvider)ConstantInt.m_146483_((int)2), 70), ExtraRootVariantPlacer.builder().trunkOffset((IntProvider)UniformInt.m_146622_((int)3, (int)7)).rootBlock((Block)TinkerWorld.enderbarkRoots.get()).canGrowThroughTag(TinkerTags.Blocks.ENDERBARK_ROOTS_CAN_GROW_THROUGH).slimyRoots(TinkerWorld.slimyEnderbarkRoots).buildOptional(), (FeatureSize)new TwoLayersFeatureSize(3, 0, 2)).m_68249_(List.of(new LeaveVineDecorator((Block)TinkerWorld.enderSlimeVine.get(), 0.125f), new AttachedToLeavesDecorator(0.14f, 1, 0, (BlockStateProvider)new RandomizedIntStateProvider((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)((BlockState)((Block)TinkerWorld.slimeSapling.get((Enum)FoliageType.ENDER)).m_49966_().m_61124_((Property)BlockStateProperties.f_61435_, (Comparable)Boolean.valueOf(true)))), MangrovePropaguleBlock.f_221441_, (IntProvider)UniformInt.m_146622_((int)0, (int)4)), 2, List.of(Direction.DOWN)))).m_68244_().m_68251_());
        BlockPredicate slimyFungusGrowThrough = BlockPredicate.m_204677_(TinkerTags.Blocks.SLIMY_FUNGUS_CAN_GROW_THROUGH);
        WorldgenProvider.register(context, TinkerStructures.bloodSlimeFungus, TinkerStructures.slimeFungus, new SlimeFungusConfig(TinkerTags.Blocks.SLIMY_SOIL, TinkerWorld.bloodshroom.getLog().m_49966_(), ((Block)TinkerWorld.slimeLeaves.get((Enum)FoliageType.BLOOD)).m_49966_(), ((CongealedSlimeBlock)((Object)TinkerWorld.congealedSlime.get((Enum)SlimeType.ICHOR))).m_49966_(), slimyFungusGrowThrough, true));
        WorldgenProvider.register(context, TinkerStructures.bloodSlimeIslandFungus, TinkerStructures.slimeFungus, new SlimeFungusConfig(TinkerTags.Blocks.SLIMY_NYLIUM, TinkerWorld.bloodshroom.getLog().m_49966_(), ((Block)TinkerWorld.slimeLeaves.get((Enum)FoliageType.BLOOD)).m_49966_(), ((CongealedSlimeBlock)((Object)TinkerWorld.congealedSlime.get((Enum)SlimeType.ICHOR))).m_49966_(), slimyFungusGrowThrough, false));
        WorldgenProvider.register(context, TinkerStructures.ichorSlimeFungus, TinkerStructures.slimeFungus, new SlimeFungusConfig(TinkerTags.Blocks.SLIMY_SOIL, TinkerWorld.bloodshroom.getLog().m_49966_(), ((Block)TinkerWorld.slimeLeaves.get((Enum)FoliageType.ICHOR)).m_49966_(), ((CongealedSlimeBlock)((Object)TinkerWorld.congealedSlime.get((Enum)SlimeType.ICHOR))).m_49966_(), slimyFungusGrowThrough, false));
        BlockMatchTest netherrack = new BlockMatchTest(Blocks.f_50134_);
        BlockState cobaltOre = ((Block)TinkerWorld.cobaltOre.get()).m_49966_();
        WorldgenProvider.register(context, TinkerWorld.configuredSmallCobaltOre, Feature.f_65731_, new OreConfiguration((RuleTest)netherrack, cobaltOre, 4));
        WorldgenProvider.register(context, TinkerWorld.configuredLargeCobaltOre, Feature.f_65731_, new OreConfiguration((RuleTest)netherrack, cobaltOre, 6));
        WorldgenProvider.configureGeode(context, TinkerWorld.configuredEarthGeode, TinkerWorld.earthGeode, (BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_152497_), (BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50129_), null, new GeodeLayerSettings(1.7, 2.2, 3.2, 5.2), new GeodeCrackSettings(0.95, 2.0, 2), (IntProvider)UniformInt.m_146622_((int)6, (int)9), (IntProvider)UniformInt.m_146622_((int)3, (int)4), (IntProvider)UniformInt.m_146622_((int)1, (int)2), 16, 1);
        WorldgenProvider.configureGeode(context, TinkerWorld.configuredSkyGeode, TinkerWorld.skyGeode, (BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_152497_), (BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50079_), TinkerWorld.steelCluster, new GeodeLayerSettings(1.5, 2.0, 3.0, 4.5), new GeodeCrackSettings(0.55, 0.5, 2), (IntProvider)UniformInt.m_146622_((int)3, (int)4), (IntProvider)ConstantInt.m_146483_((int)2), (IntProvider)ConstantInt.m_146483_((int)1), 8, 3);
        WorldgenProvider.configureGeode(context, TinkerWorld.configuredIchorGeode, TinkerWorld.ichorGeode, (BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_152497_), (BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50134_), null, new GeodeLayerSettings(1.7, 2.2, 3.2, 4.2), new GeodeCrackSettings(0.75, 2.0, 2), (IntProvider)UniformInt.m_146622_((int)4, (int)6), (IntProvider)UniformInt.m_146622_((int)3, (int)4), (IntProvider)UniformInt.m_146622_((int)1, (int)2), 24, 20);
        WorldgenProvider.configureGeode(context, TinkerWorld.configuredEnderGeode, TinkerWorld.enderGeode, (BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_152497_), (BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50259_), TinkerWorld.knightmetalCluster, new GeodeLayerSettings(1.7, 2.2, 3.2, 5.2), new GeodeCrackSettings(0.45, 1.0, 2), (IntProvider)UniformInt.m_146622_((int)4, (int)10), (IntProvider)UniformInt.m_146622_((int)3, (int)4), (IntProvider)UniformInt.m_146622_((int)1, (int)2), 16, 10000);
    }

    private static void registerPlacedFeatures(BootstapContext<PlacedFeature> context) {
        WorldgenProvider.register(context, TinkerWorld.placedSmallCobaltOre, TinkerWorld.configuredSmallCobaltOre, new PlacementModifier[]{CountPlacement.m_191628_((int)5), InSquarePlacement.m_191715_(), PlacementUtils.f_195358_, BiomeFilter.m_191561_()});
        WorldgenProvider.register(context, TinkerWorld.placedLargeCobaltOre, TinkerWorld.configuredLargeCobaltOre, new PlacementModifier[]{CountPlacement.m_191628_((int)3), InSquarePlacement.m_191715_(), HeightRangePlacement.m_191692_((VerticalAnchor)VerticalAnchor.m_158922_((int)8), (VerticalAnchor)VerticalAnchor.m_158922_((int)32)), BiomeFilter.m_191561_()});
        WorldgenProvider.placeGeode(context, TinkerWorld.placedEarthGeode, TinkerWorld.configuredEarthGeode, RarityFilter.m_191900_((int)128), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158930_((int)6), (VerticalAnchor)VerticalAnchor.m_158930_((int)54)));
        WorldgenProvider.placeGeode(context, TinkerWorld.placedSkyGeode, TinkerWorld.configuredSkyGeode, RarityFilter.m_191900_((int)64), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)16), (VerticalAnchor)VerticalAnchor.m_158922_((int)54)));
        WorldgenProvider.placeGeode(context, TinkerWorld.placedIchorGeode, TinkerWorld.configuredIchorGeode, RarityFilter.m_191900_((int)52), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158935_((int)48), (VerticalAnchor)VerticalAnchor.m_158935_((int)16)));
        WorldgenProvider.placeGeode(context, TinkerWorld.placedEnderGeode, TinkerWorld.configuredEnderGeode, RarityFilter.m_191900_((int)256), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158930_((int)16), (VerticalAnchor)VerticalAnchor.m_158930_((int)64)));
    }

    private static void registerStructures(BootstapContext<Structure> context) {
        HolderGetter biomes = context.m_255420_(Registries.f_256952_);
        HolderGetter configured = context.m_255420_(Registries.f_256911_);
        context.m_255272_(TinkerStructures.earthSlimeIsland, (Object)IslandStructure.seaBuilder().addDefaultTemplates(TConstruct.getResource("islands/earth/")).addTree((Holder<ConfiguredFeature<?, ?>>)configured.m_255043_(TinkerStructures.earthSlimeIslandTree), 1).addSlimyGrass(FoliageType.EARTH).build(new Structure.StructureSettings((HolderSet)biomes.m_254956_(TinkerTags.Biomes.EARTHSLIME_ISLANDS), WorldgenProvider.monsterOverride(EntityType.f_20526_, 4, 4), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.NONE)));
        context.m_255272_(TinkerStructures.skySlimeIsland, (Object)IslandStructure.skyBuilder().addDefaultTemplates(TConstruct.getResource("islands/sky/")).addTree((Holder<ConfiguredFeature<?, ?>>)configured.m_255043_(TinkerStructures.skySlimeIslandTree), 1).addSlimyGrass(FoliageType.SKY).vines((Block)TinkerWorld.skySlimeVine.get()).build(new Structure.StructureSettings((HolderSet)biomes.m_254956_(TinkerTags.Biomes.SKYSLIME_ISLANDS), WorldgenProvider.monsterOverride(TinkerWorld.skySlimeEntity.get(), 3, 4), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.NONE)));
        context.m_255272_(TinkerStructures.clayIsland, (Object)IslandStructure.skyBuilder().addDefaultTemplates(TConstruct.getResource("islands/dirt/")).addTree((Holder<ConfiguredFeature<?, ?>>)configured.m_255043_(TreeFeatures.f_195123_), 4).addTree((Holder<ConfiguredFeature<?, ?>>)configured.m_255043_(TreeFeatures.f_195125_), 3).addTree((Holder<ConfiguredFeature<?, ?>>)configured.m_255043_(TreeFeatures.f_195127_), 2).addTree((Holder<ConfiguredFeature<?, ?>>)configured.m_255043_(TreeFeatures.f_195126_), 1).addTree((Holder<ConfiguredFeature<?, ?>>)configured.m_255043_(TreeFeatures.f_195131_), 1).addGrass(Blocks.f_50034_, 7).addGrass(Blocks.f_50035_, 1).build(new Structure.StructureSettings((HolderSet)biomes.m_254956_(TinkerTags.Biomes.CLAY_ISLANDS), WorldgenProvider.monsterOverride(TinkerWorld.terracubeEntity.get(), 2, 4), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.NONE)));
        context.m_255272_(TinkerStructures.bloodIsland, (Object)IslandStructure.seaBuilder().addDefaultTemplates(TConstruct.getResource("islands/blood/")).addTree((Holder<ConfiguredFeature<?, ?>>)configured.m_255043_(TinkerStructures.bloodSlimeIslandFungus), 1).addSlimyGrass(FoliageType.BLOOD).build(new Structure.StructureSettings((HolderSet)biomes.m_254956_(TinkerTags.Biomes.BLOOD_ISLANDS), WorldgenProvider.monsterOverride(EntityType.f_20468_, 4, 6), GenerationStep.Decoration.UNDERGROUND_DECORATION, TerrainAdjustment.NONE)));
        context.m_255272_(TinkerStructures.endSlimeIsland, (Object)IslandStructure.skyBuilder().addDefaultTemplates(TConstruct.getResource("islands/ender/")).addTree((Holder<ConfiguredFeature<?, ?>>)configured.m_255043_(TinkerStructures.enderSlimeTree), 3).addTree((Holder<ConfiguredFeature<?, ?>>)configured.m_255043_(TinkerStructures.enderSlimeTreeTall), 17).addSlimyGrass(FoliageType.ENDER).vines((Block)TinkerWorld.enderSlimeVine.get()).build(new Structure.StructureSettings((HolderSet)biomes.m_254956_(TinkerTags.Biomes.ENDERSLIME_ISLANDS), WorldgenProvider.monsterOverride(TinkerWorld.enderSlimeEntity.get(), 4, 4), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.NONE)));
    }

    private static void registerStructureSets(BootstapContext<StructureSet> context) {
        HolderGetter structures = context.m_255420_(Registries.f_256944_);
        context.m_255272_(TinkerStructures.overworldOceanIsland, (Object)WorldgenProvider.structureSet(30, 9, RandomSpreadType.LINEAR, 25988585, 0.5f, WorldgenProvider.entry((HolderGetter<Structure>)structures, TinkerStructures.earthSlimeIsland, 1)));
        context.m_255272_(TinkerStructures.overworldSkyIsland, (Object)WorldgenProvider.structureSet(35, 4, RandomSpreadType.LINEAR, 14357800, 0.5f, WorldgenProvider.entry((HolderGetter<Structure>)structures, TinkerStructures.skySlimeIsland, 4), WorldgenProvider.entry((HolderGetter<Structure>)structures, TinkerStructures.clayIsland, 1)));
        context.m_255272_(TinkerStructures.netherOceanIsland, (Object)WorldgenProvider.structureSet(15, 7, RandomSpreadType.LINEAR, 65245622, 0.5f, WorldgenProvider.entry((HolderGetter<Structure>)structures, TinkerStructures.bloodIsland, 1)));
        context.m_255272_(TinkerStructures.endSkyIsland, (Object)WorldgenProvider.structureSet(25, 6, RandomSpreadType.LINEAR, 368963602, 0.5f, WorldgenProvider.entry((HolderGetter<Structure>)structures, TinkerStructures.endSlimeIsland, 1)));
    }

    private static void registerBiomeModifiers(BootstapContext<BiomeModifier> context) {
        HolderGetter biomes = context.m_255420_(Registries.f_256952_);
        HolderGetter placed = context.m_255420_(Registries.f_256988_);
        HolderSet.Named overworld = biomes.m_254956_(BiomeTags.f_215817_);
        HolderSet.Named nether = biomes.m_254956_(BiomeTags.f_207612_);
        HolderSet.Named end = biomes.m_254956_(BiomeTags.f_215818_);
        context.m_255272_(TinkerWorld.spawnCobaltOre, (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)nether, (HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{placed.m_255043_(TinkerWorld.placedSmallCobaltOre), placed.m_255043_(TinkerWorld.placedLargeCobaltOre)}), GenerationStep.Decoration.UNDERGROUND_DECORATION));
        context.m_255272_(TinkerWorld.spawnEarthGeode, (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)overworld, (HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{placed.m_255043_(TinkerWorld.placedEarthGeode)}), GenerationStep.Decoration.LOCAL_MODIFICATIONS));
        context.m_255272_(TinkerWorld.spawnSkyGeode, (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier(WorldgenProvider.and(new HolderSet[]{overworld, WorldgenProvider.not(WorldgenProvider.or(new HolderSet[]{biomes.m_254956_(BiomeTags.f_207603_), biomes.m_254956_(BiomeTags.f_207602_), biomes.m_254956_(BiomeTags.f_207604_), biomes.m_254956_(BiomeTags.f_207605_)}))}), (HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{placed.m_255043_(TinkerWorld.placedSkyGeode)}), GenerationStep.Decoration.LOCAL_MODIFICATIONS));
        context.m_255272_(TinkerWorld.spawnIchorGeode, (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)nether, (HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{placed.m_255043_(TinkerWorld.placedIchorGeode)}), GenerationStep.Decoration.LOCAL_MODIFICATIONS));
        context.m_255272_(TinkerWorld.spawnEnderGeode, (Object)new ForgeBiomeModifiers.AddFeaturesBiomeModifier(WorldgenProvider.and(new HolderSet[]{end, WorldgenProvider.not(HolderSet.m_205809_((Holder[])new Holder[]{biomes.m_255043_(Biomes.f_48210_)}))}), (HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{placed.m_255043_(TinkerWorld.placedEnderGeode)}), GenerationStep.Decoration.LOCAL_MODIFICATIONS));
        context.m_255272_(TinkerWorld.spawnOverworldSlime, (Object)new ForgeBiomeModifiers.AddSpawnsBiomeModifier((HolderSet)overworld, List.of(new MobSpawnSettings.SpawnerData(TinkerWorld.skySlimeEntity.get(), 100, 2, 4))));
        context.m_255272_(TinkerWorld.spawnEndSlime, (Object)new ForgeBiomeModifiers.AddSpawnsBiomeModifier((HolderSet)end, List.of(new MobSpawnSettings.SpawnerData(TinkerWorld.enderSlimeEntity.get(), 10, 2, 4))));
    }

    @SafeVarargs
    private static <T> AndHolderSet<T> and(HolderSet<T> ... sets) {
        return new AndHolderSet(List.of(sets));
    }

    @SafeVarargs
    private static <T> OrHolderSet<T> or(HolderSet<T> ... sets) {
        return new OrHolderSet(List.of(sets));
    }

    private static <T> NotHolderSet<T> not(HolderSet<T> set) {
        return new SerializableNotHolderSet<T>(set);
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(BootstapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, F feature, FC config) {
        context.m_255272_(key, (Object)new ConfiguredFeature(feature, config));
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(BootstapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, Supplier<F> feature, FC config) {
        WorldgenProvider.register(context, key, (Feature)feature.get(), config);
    }

    private static void configureGeode(BootstapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, GeodeItemObject geode, BlockStateProvider middleLayer, BlockStateProvider outerLayer, @Nullable Supplier<? extends Block> extraCluster, GeodeLayerSettings layerSettings, GeodeCrackSettings crackSettings, IntProvider outerWall, IntProvider distributionPoints, IntProvider pointOffset, int genOffset, int invalidBlocks) {
        Stream<BlockState> buds = Arrays.stream(GeodeItemObject.BudSize.values()).map(type -> geode.getBud((GeodeItemObject.BudSize)((Object)type)).m_49966_());
        if (extraCluster != null) {
            buds = Stream.concat(buds, Stream.of(extraCluster.get().m_49966_()));
        }
        WorldgenProvider.register(context, key, Feature.f_159728_, new GeodeConfiguration(new GeodeBlockSettings((BlockStateProvider)BlockStateProvider.m_191382_((Block)Blocks.f_50016_), (BlockStateProvider)BlockStateProvider.m_191382_((Block)geode.getBlock()), (BlockStateProvider)BlockStateProvider.m_191382_((Block)geode.getBudding()), middleLayer, outerLayer, buds.toList(), BlockTags.f_144287_, BlockTags.f_144289_), layerSettings, crackSettings, 0.335, 0.083, true, outerWall, distributionPoints, pointOffset, -genOffset, genOffset, 0.05, invalidBlocks));
    }

    private static void register(BootstapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, ResourceKey<ConfiguredFeature<?, ?>> configured, PlacementModifier ... placement) {
        context.m_255272_(key, (Object)new PlacedFeature((Holder)context.m_255420_(Registries.f_256911_).m_255043_(configured), List.of(placement)));
    }

    private static void placeGeode(BootstapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, ResourceKey<ConfiguredFeature<?, ?>> configured, RarityFilter rarity, HeightRangePlacement height) {
        WorldgenProvider.register(context, key, configured, new PlacementModifier[]{rarity, InSquarePlacement.m_191715_(), height, BiomeFilter.m_191561_()});
    }

    private static StructureSet structureSet(int spacing, int separation, RandomSpreadType spreadType, int salt, float frequency, StructureSet.StructureSelectionEntry ... structures) {
        return new StructureSet(List.of(structures), (StructurePlacement)new RandomSpreadStructurePlacement(Vec3i.f_123288_, StructurePlacement.FrequencyReductionMethod.DEFAULT, frequency, salt, Optional.empty(), spacing, separation, spreadType));
    }

    private static StructureSet.StructureSelectionEntry entry(HolderGetter<Structure> structures, ResourceKey<Structure> structure, int weight) {
        return new StructureSet.StructureSelectionEntry((Holder)structures.m_255043_(structure), weight);
    }

    private static Map<MobCategory, StructureSpawnOverride> monsterOverride(EntityType<?> entity, int min, int max) {
        return Map.of(MobCategory.MONSTER, new StructureSpawnOverride(StructureSpawnOverride.BoundingBoxType.STRUCTURE, WeightedRandomList.m_146330_((WeightedEntry[])new MobSpawnSettings.SpawnerData[]{new MobSpawnSettings.SpawnerData(entity, 1, min, max)})));
    }

    private static class SerializableNotHolderSet<T>
    extends NotHolderSet<T> {
        public SerializableNotHolderSet(HolderSet<T> value) {
            super(null, value);
        }

        public boolean m_207277_(HolderOwner<T> holderOwner) {
            return true;
        }
    }
}

