/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.entity;

import java.time.LocalDate;
import java.time.temporal.ChronoField;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.Nullable;

public abstract class ArmoredSlimeEntity
extends Slime {
    private static final EntityDataAccessor<Boolean> METAL = SynchedEntityData.m_135353_(ArmoredSlimeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final String TAG_METAL = "metal";

    public ArmoredSlimeEntity(EntityType<? extends ArmoredSlimeEntity> type, Level world) {
        super(type, world);
        if (!world.f_46443_) {
            this.tryAddAttribute(Attributes.f_22284_, new AttributeModifier("tconstruct.small_armor_bonus", 3.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
            this.tryAddAttribute(Attributes.f_22285_, new AttributeModifier("tconstruct.small_toughness_bonus", 3.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
            this.tryAddAttribute(Attributes.f_22278_, new AttributeModifier("tconstruct.small_resistence_bonus", 3.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
        this.f_19804_.m_135381_(METAL, (Object)false);
    }

    public EntityType<? extends ArmoredSlimeEntity> m_6095_() {
        return super.m_6095_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(METAL, (Object)false);
    }

    protected void setMetal(boolean metal) {
        this.f_19804_.m_135381_(METAL, (Object)metal);
    }

    public boolean isMetal() {
        return (Boolean)this.f_19804_.m_135370_(METAL);
    }

    private void tryAddAttribute(Attribute attribute, AttributeModifier modifier) {
        AttributeInstance instance = this.m_21051_(attribute);
        if (instance != null) {
            instance.m_22118_(modifier);
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance difficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        LocalDate localdate;
        SpawnGroupData spawnData = super.m_6518_(pLevel, difficulty, pReason, pSpawnData, pDataTag);
        this.m_21553_(this.f_19796_.m_188501_() < 0.55f * difficulty.m_19057_());
        this.m_213945_(this.f_19796_, difficulty);
        if (this.m_6844_(EquipmentSlot.HEAD).m_41619_() && (localdate = LocalDate.now()).get(ChronoField.MONTH_OF_YEAR) == 10 && localdate.get(ChronoField.DAY_OF_MONTH) == 31 && this.f_19796_.m_188501_() < 0.25f) {
            this.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)(this.f_19796_.m_188501_() < 0.1f ? Blocks.f_50144_ : Blocks.f_50143_)));
            this.f_21348_[EquipmentSlot.HEAD.m_20749_()] = 0.0f;
        }
        return spawnData;
    }

    protected abstract void m_213945_(RandomSource var1, DifficultyInstance var2);

    protected void m_213946_(RandomSource random, DifficultyInstance difficulty) {
    }

    public boolean m_7252_(ItemStack stack) {
        return ArmoredSlimeEntity.m_147233_((ItemStack)stack) == EquipmentSlot.HEAD;
    }

    protected void m_7472_(DamageSource source, int looting, boolean recentlyHit) {
        boolean alwaysDrop;
        ItemStack stack = this.m_6844_(EquipmentSlot.HEAD);
        float slotChance = this.m_21519_(EquipmentSlot.HEAD);
        if (slotChance > 0.25f && this.m_33632_() > 1) {
            slotChance = 0.25f;
        }
        boolean bl = alwaysDrop = slotChance > 1.0f;
        if (!stack.m_41619_() && !EnchantmentHelper.m_44924_((ItemStack)stack) && (recentlyHit || alwaysDrop) && this.f_19796_.m_188501_() - (float)looting * 0.01f < slotChance) {
            if (!alwaysDrop && stack.m_41763_()) {
                int max = stack.m_41776_();
                stack.m_41721_(max - this.f_19796_.m_188503_(1 + this.f_19796_.m_188503_(Math.max(max - 3, 1))));
            }
            this.m_19983_(stack);
            this.m_8061_(EquipmentSlot.HEAD, ItemStack.f_41583_);
        }
    }

    public void m_142687_(Entity.RemovalReason reason) {
        int size = this.m_33632_();
        Level level = this.m_9236_();
        if (!level.f_46443_ && size > 1 && this.m_21224_()) {
            Component name = this.m_7770_();
            boolean noAi = this.m_21525_();
            boolean invulnerable = this.m_20147_();
            float offset = (float)size / 4.0f;
            int newSize = size / 2;
            int count = 2 + this.f_19796_.m_188503_(3);
            ItemStack helmet = this.m_6844_(EquipmentSlot.HEAD);
            boolean metal = this.isMetal();
            int helmetIndex = -1;
            if (!helmet.m_41619_()) {
                helmetIndex = this.f_19796_.m_188503_(count);
            }
            float dropChance = this.m_21519_(EquipmentSlot.HEAD);
            for (int i = 0; i < count; ++i) {
                float x = ((float)(i % 2) - 0.5f) * offset;
                float z = ((float)(i / 2) - 0.5f) * offset;
                ArmoredSlimeEntity slime = (ArmoredSlimeEntity)this.m_6095_().m_20615_(level);
                assert (slime != null);
                if (this.m_21532_()) {
                    slime.m_21530_();
                }
                slime.m_6593_(name);
                slime.m_21557_(noAi);
                slime.m_20331_(invulnerable);
                slime.m_7839_(newSize, true);
                if (metal) {
                    slime.setMetal(metal);
                }
                if (i == helmetIndex) {
                    slime.m_8061_(EquipmentSlot.HEAD, helmet.m_41777_());
                    this.m_8061_(EquipmentSlot.HEAD, ItemStack.f_41583_);
                } else if (dropChance < 1.0f && (double)this.f_19796_.m_188501_() < 0.25) {
                    slime.m_8061_(EquipmentSlot.HEAD, helmet.m_41777_());
                }
                slime.m_7678_(this.m_20185_() + (double)x, this.m_20186_() + 0.5, this.m_20189_() + (double)z, this.f_19796_.m_188501_() * 360.0f, 0.0f);
                level.m_7967_((Entity)slime);
            }
        }
        this.m_142467_(reason);
        if (reason == Entity.RemovalReason.KILLED) {
            this.m_146850_(GameEvent.f_223707_);
        }
        this.invalidateCaps();
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_(TAG_METAL, this.isMetal());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setMetal(tag.m_128471_(TAG_METAL));
    }
}

