/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.paucal.api.datagen;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public abstract class PaucalLootTableSubProvider
implements LootTableSubProvider {
    protected final String modid;

    protected PaucalLootTableSubProvider(String modid) {
        this.modid = modid;
    }

    public void m_245126_(BiConsumer<ResourceLocation, LootTable.Builder> register) {
        HashMap<Block, LootTable.Builder> blockTables = new HashMap<Block, LootTable.Builder>();
        HashMap<ResourceLocation, LootTable.Builder> lootTables = new HashMap<ResourceLocation, LootTable.Builder>();
        this.makeLootTables(blockTables, lootTables);
        for (Map.Entry<Block, LootTable.Builder> entry : blockTables.entrySet()) {
            register.accept(entry.getKey().m_60589_(), entry.getValue().m_79165_(LootContextParamSets.f_81421_));
        }
        lootTables.forEach(register);
    }

    protected abstract void makeLootTables(Map<Block, LootTable.Builder> var1, Map<ResourceLocation, LootTable.Builder> var2);

    protected LootPool.Builder dropThisPool(ItemLike item, int count) {
        return this.dropThisPool(item, (NumberProvider)ConstantValue.m_165692_((float)count));
    }

    protected LootPool.Builder dropThisPool(ItemLike item, NumberProvider count) {
        return LootPool.m_79043_().m_165133_(count).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)item));
    }

    @SafeVarargs
    protected final void dropSelf(Map<Block, LootTable.Builder> lootTables, Supplier<? extends Block> ... blocks) {
        for (Supplier<? extends Block> blockSupp : blocks) {
            Block block = blockSupp.get();
            this.dropSelf(block, lootTables);
        }
    }

    protected void dropSelf(Map<Block, LootTable.Builder> lootTables, Block ... blocks) {
        for (Block block : blocks) {
            this.dropSelf(block, lootTables);
        }
    }

    protected void dropSelf(Block block, Map<Block, LootTable.Builder> lootTables) {
        LootTable.Builder table = LootTable.m_79147_().m_79161_(this.dropThisPool((ItemLike)block, 1));
        lootTables.put(block, table);
    }

    protected void dropThis(Block block, ItemLike drop, Map<Block, LootTable.Builder> lootTables) {
        LootTable.Builder table = LootTable.m_79147_().m_79161_(this.dropThisPool(drop, 1));
        lootTables.put(block, table);
    }

    protected void dropThis(Block block, ItemLike drop, NumberProvider count, Map<Block, LootTable.Builder> lootTables) {
        LootTable.Builder table = LootTable.m_79147_().m_79161_(this.dropThisPool(drop, count));
        lootTables.put(block, table);
    }
}

