/*
 * Decompiled with CFR 0.152.
 */
package immersive_melodies.network.c2s;

import immersive_melodies.item.InstrumentItem;
import immersive_melodies.network.ImmersivePayload;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public record ItemActionMessage(int slot, State state, ResourceLocation melody) implements ImmersivePayload
{
    public ItemActionMessage(FriendlyByteBuf b) {
        this(b.readInt(), (State)b.m_130066_(State.class), b.m_130281_());
    }

    public static ItemActionMessage fromStateAndMelody(State state, ResourceLocation melody) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        int slot = player == null ? -1 : player.m_150109_().f_35977_;
        return new ItemActionMessage(slot, state, melody);
    }

    public static ItemActionMessage fromState(State state) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        int slot = player == null ? -1 : player.m_150109_().f_35977_;
        return new ItemActionMessage(slot, state, new ResourceLocation("empty"));
    }

    @Override
    public void encode(FriendlyByteBuf b) {
        b.writeInt(this.slot);
        b.m_130068_((Enum)this.state);
        b.m_130085_(this.melody);
    }

    @Override
    public void handle(Player e) {
        ItemStack stack = e.m_150109_().m_8020_(this.slot);
        Item item = stack.m_41720_();
        if (item instanceof InstrumentItem) {
            InstrumentItem instrument = (InstrumentItem)item;
            switch (this.state) {
                case PLAY: {
                    instrument.play(stack, this.melody, e.m_9236_(), (Entity)e);
                    break;
                }
                case CONTINUE: {
                    instrument.play(stack);
                    break;
                }
                case PAUSE: {
                    instrument.pause(stack);
                }
            }
        }
    }

    public static enum State {
        PLAY,
        CONTINUE,
        PAUSE;

    }
}

