/*
 * Decompiled with CFR 0.152.
 */
package net.lyivx.ls_furniture.client.screens;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import net.lyivx.ls_core.client.screens.ModConfigScreen;
import net.lyivx.ls_furniture.LYIVXsFurnitureMod;
import net.lyivx.ls_furniture.client.screens.widgets.FakeLevel;
import net.lyivx.ls_furniture.client.screens.widgets.HoverImageButton;
import net.lyivx.ls_furniture.client.screens.widgets.RenderWindowWidget;
import net.lyivx.ls_furniture.common.blocks.ModBedBlock;
import net.lyivx.ls_furniture.common.blocks.WardrobeBlock;
import net.lyivx.ls_furniture.common.menus.WorkstationMenu;
import net.lyivx.ls_furniture.common.recipes.FilterableRecipe;
import net.lyivx.ls_furniture.config.ConfigProvider;
import net.lyivx.ls_furniture.registry.ModSoundEvents;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.recipebook.RecipeBookComponent;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class WorkstationScreen
extends AbstractContainerScreen<WorkstationMenu> {
    private static final ResourceLocation SCROLLER = LYIVXsFurnitureMod.createResourceLocation("textures/gui/container/widgets/scroller.png");
    private static final ResourceLocation SCROLLER_DISABLED = LYIVXsFurnitureMod.createResourceLocation("textures/gui/container/widgets/scroller_disabled.png");
    private static final ResourceLocation RECIPE_SELECTED = LYIVXsFurnitureMod.createResourceLocation("textures/gui/container/widgets/recipe_selected.png");
    private static final ResourceLocation RECIPE_HIGHLIGHTED = LYIVXsFurnitureMod.createResourceLocation("textures/gui/container/widgets/recipe_highlighted.png");
    private static final ResourceLocation RECIPE = LYIVXsFurnitureMod.createResourceLocation("textures/gui/container/widgets/recipe.png");
    private static final ResourceLocation BACKGROUND = LYIVXsFurnitureMod.createResourceLocation("textures/gui/container/workstation.png");
    private static final ResourceLocation BACKGROUND_SEARCH = LYIVXsFurnitureMod.createResourceLocation("textures/gui/container/workstation_search.png");
    private static final ResourceLocation PREVIEW_TAB = LYIVXsFurnitureMod.createResourceLocation("textures/gui/container/widgets/workstation_preview.png");
    private static final ResourceLocation NO_PREVIEW_TAB = LYIVXsFurnitureMod.createResourceLocation("textures/gui/container/widgets/workstation_no_preview.png");
    private static final ResourceLocation RECIPE_BUTTON_LOCATION = LYIVXsFurnitureMod.createResourceLocation("textures/gui/recipe_button.png");
    private static final ResourceLocation CONFIG_ICON_BUTTON = LYIVXsFurnitureMod.createResourceLocation("textures/gui/container/widgets/workstation_config_button.png");
    private static final ResourceLocation ARROW_ICON_BUTTON = LYIVXsFurnitureMod.createResourceLocation("textures/gui/container/widgets/workstation_arrow_button.png");
    public static final ResourceLocation SINGLE_BLOCK_BUTTON = LYIVXsFurnitureMod.createResourceLocation("textures/gui/container/widgets/workstation_single_block_button.png");
    public static final ResourceLocation L_SHAPE_BLOCK_BUTTON = LYIVXsFurnitureMod.createResourceLocation("textures/gui/container/widgets/workstation_l_shape_block_button.png");
    public static final ResourceLocation VERTICAL_BLOCK_BUTTON = LYIVXsFurnitureMod.createResourceLocation("textures/gui/container/widgets/workstation_vertical_block_button.png");
    public static final ResourceLocation HORIZONTAL_BLOCK = LYIVXsFurnitureMod.createResourceLocation("textures/gui/container/widgets/workstation_horizontal_block_button.png");
    public static final ResourceLocation HORIZONTAL_ALT_BLOCK = LYIVXsFurnitureMod.createResourceLocation("textures/gui/container/widgets/workstation_horizontal_alt_block_button.png");
    public static final ResourceLocation TWO_BY_TWO_BLOCK_BUTTON = LYIVXsFurnitureMod.createResourceLocation("textures/gui/container/widgets/workstation_two_by_two_block_button.png");
    private static final Component CONFIG_TEXT = Component.m_237115_((String)"container.ls_furniture.workstation.config");
    private static final Component PREVIEW_TEXT_OPEN = Component.m_237115_((String)"container.ls_furniture.workstation.preview.open");
    private static final Component PREVIEW_TEXT_CLOSE = Component.m_237115_((String)"container.ls_furniture.workstation.preview.close");
    private static final Component PREVIEW_TITLE_TEXT = Component.m_237115_((String)"container.ls_furniture.workstation.preview.title");
    private static final Component NO_PREVIEW_TITLE_TEXT = Component.m_237115_((String)"container.ls_furniture.workstation.no_preview.title");
    private static final Component SINGLE_BLOCK_TEXT = Component.m_237115_((String)"container.ls_furniture.workstation.single_block");
    private static final Component L_SHAPE_BLOCK_TEXT = Component.m_237115_((String)"container.ls_furniture.workstation.l_shape_block");
    private static final Component VERTICAL_BLOCK_TEXT = Component.m_237115_((String)"container.ls_furniture.workstation.vertical_block");
    private static final Component HORIZONTAL_BLOCK_TEXT = Component.m_237115_((String)"container.ls_furniture.workstation.horizontal_block");
    private static final Component HORIZONTAL_ALT_BLOCK_TEXT = Component.m_237115_((String)"container.ls_furniture.workstation.horizontal_alt_block");
    private static final Component TWO_BY_TWO_BLOCK_TEXT = Component.m_237115_((String)"container.ls_furniture.workstation.two_by_two_block");
    private final RecipeBookComponent recipeBookComponent = new RecipeBookComponent();
    private float scrollOffs;
    private boolean scrolling;
    private int startIndex;
    private boolean displayRecipes;
    private boolean showPreview = true;
    private EditBox searchBox;
    private final List<FilterableRecipe> filteredRecipes = new ArrayList<FilterableRecipe>();
    private int filteredIndex = -1;
    private HoverImageButton gearButton;
    private HoverImageButton previewButton;
    private HoverImageButton singleBlockButton;
    private HoverImageButton lShapeBlockButton;
    private HoverImageButton verticalBlockButton;
    private HoverImageButton horizontalBlockButton;
    private HoverImageButton horizontalAltBlockButton;
    private HoverImageButton twoByTwoBlockButton;
    public static RenderWindowWidget.Mode currentMode = RenderWindowWidget.Mode.SINGLE_BLOCK;
    public static boolean showPreviewStatic = true;
    private RenderWindowWidget renderWindowWidget;
    private final FakeLevel fakeLevel = new FakeLevel();
    private boolean previewStateLocked = false;

    public WorkstationScreen(WorkstationMenu workstationMenu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)workstationMenu, inventory, component);
        workstationMenu.registerUpdateListener(this::containerChanged);
        --this.f_97729_;
        this.showPreview = showPreviewStatic;
    }

    protected void m_7856_() {
        super.m_7856_();
        int boxX = this.f_97735_ + 41;
        int boxY = this.f_97736_ + 15;
        this.searchBox = new EditBox(this.f_96547_, boxX, boxY, 69, 9, (Component)Component.m_237115_((String)"itemGroup.search"));
        this.searchBox.m_94199_(50);
        this.searchBox.m_94182_(false);
        this.searchBox.m_93692_(false);
        this.searchBox.m_94186_(false);
        this.searchBox.m_94202_(0xFFFFFF);
        this.searchBox.m_94151_(s -> this.refreshSearchResults());
        this.m_142416_((GuiEventListener)this.searchBox);
        this.gearButton = (HoverImageButton)this.m_142416_((GuiEventListener)new HoverImageButton(this.f_97735_ + 158, this.f_97736_ + this.f_97727_ - 160, 12, 10, 0, 0, 12, CONFIG_ICON_BUTTON, 24, 10, 12, 10, button -> this.f_96541_.m_91152_((Screen)new ModConfigScreen((Screen)this, this.f_96541_.f_91066_, "ls_furniture")), false, false));
        this.gearButton.m_257544_(Tooltip.m_257550_((Component)CONFIG_TEXT));
        if (ConfigProvider.shouldShowPreview()) {
            int buttonWidth = 20;
            int buttonHeight = 21;
            int textureWidth = 80;
            this.previewButton = (HoverImageButton)this.m_142416_((GuiEventListener)new HoverImageButton(0, 0, buttonWidth, buttonHeight, 0, 0, buttonWidth, ARROW_ICON_BUTTON, textureWidth, buttonHeight, buttonWidth, buttonHeight, button -> {
                showPreviewStatic = this.showPreview = !this.showPreview;
                this.previewButton.setStayClicked(this.showPreview);
                this.updatePreviewVisibility();
                assert (this.f_96541_ != null);
                this.f_96541_.m_91152_((Screen)this);
            }, this.showPreview, true));
            if (!this.showPreview) {
                this.previewButton.m_257544_(Tooltip.m_257550_((Component)PREVIEW_TEXT_OPEN));
            } else {
                this.previewButton.m_257544_(Tooltip.m_257550_((Component)PREVIEW_TEXT_CLOSE));
            }
            this.updatePreviewButtonPosition();
            this.updatePreviewVisibility();
        }
        this.updateSearchBarVisibility();
    }

    private void updatePreviewButtonPosition() {
        int baseX = this.showPreview ? this.f_97735_ - 131 : this.f_97735_ - 20;
        int baseY = this.f_97736_ + 5;
        this.previewButton.m_252865_(baseX);
        this.previewButton.m_253211_(baseY);
    }

    private void updatePreviewVisibility() {
        if (this.showPreview) {
            this.previewTab();
        } else {
            this.hidePreviewTab();
        }
        this.updateSearchBarVisibility();
    }

    private void hidePreviewTab() {
        this.m_169411_((GuiEventListener)this.singleBlockButton);
        this.m_169411_((GuiEventListener)this.lShapeBlockButton);
        this.m_169411_((GuiEventListener)this.verticalBlockButton);
        this.m_169411_((GuiEventListener)this.horizontalBlockButton);
        this.m_169411_((GuiEventListener)this.horizontalAltBlockButton);
        this.m_169411_((GuiEventListener)this.twoByTwoBlockButton);
        this.m_169411_((GuiEventListener)this.renderWindowWidget);
    }

    private void previewTab() {
        int baseX = this.f_97735_ - 22;
        int baseY = this.f_97736_ + 93;
        int buttonWidth = 20;
        int buttonHeight = 21;
        int textureWidth = 60;
        this.singleBlockButton = (HoverImageButton)this.m_142416_((GuiEventListener)new HoverImageButton(baseX, baseY, buttonWidth, buttonHeight, 0, 0, buttonWidth, SINGLE_BLOCK_BUTTON, textureWidth, buttonHeight, buttonWidth, buttonHeight, button -> {
            this.setMode(RenderWindowWidget.Mode.SINGLE_BLOCK);
            this.updateBlockPreview();
        }, currentMode == RenderWindowWidget.Mode.SINGLE_BLOCK, false));
        this.singleBlockButton.m_257544_(Tooltip.m_257550_((Component)SINGLE_BLOCK_TEXT));
        this.lShapeBlockButton = (HoverImageButton)this.m_142416_((GuiEventListener)new HoverImageButton(baseX - buttonWidth - 1, baseY, buttonWidth, buttonHeight, 0, 0, buttonWidth, L_SHAPE_BLOCK_BUTTON, textureWidth, buttonHeight, buttonWidth, buttonHeight, button -> {
            this.setMode(RenderWindowWidget.Mode.L_SHAPE_BLOCK);
            this.updateBlockPreview();
        }, currentMode == RenderWindowWidget.Mode.L_SHAPE_BLOCK, false));
        this.lShapeBlockButton.m_257544_(Tooltip.m_257550_((Component)L_SHAPE_BLOCK_TEXT));
        this.verticalBlockButton = (HoverImageButton)this.m_142416_((GuiEventListener)new HoverImageButton(baseX - (buttonWidth + 1) * 2, baseY, buttonWidth, buttonHeight, 0, 0, buttonWidth, VERTICAL_BLOCK_BUTTON, textureWidth, buttonHeight, buttonWidth, buttonHeight, button -> {
            this.setMode(RenderWindowWidget.Mode.VERTICAL_BLOCK);
            this.updateBlockPreview();
        }, currentMode == RenderWindowWidget.Mode.VERTICAL_BLOCK, false));
        this.verticalBlockButton.m_257544_(Tooltip.m_257550_((Component)VERTICAL_BLOCK_TEXT));
        this.horizontalBlockButton = (HoverImageButton)this.m_142416_((GuiEventListener)new HoverImageButton(baseX - (buttonWidth + 1) * 3, baseY, buttonWidth, buttonHeight, 0, 0, buttonWidth, HORIZONTAL_BLOCK, textureWidth, buttonHeight, buttonWidth, buttonHeight, button -> {
            this.setMode(RenderWindowWidget.Mode.HORIZONTAL_BLOCK);
            this.updateBlockPreview();
        }, currentMode == RenderWindowWidget.Mode.HORIZONTAL_BLOCK, false));
        this.horizontalBlockButton.m_257544_(Tooltip.m_257550_((Component)HORIZONTAL_BLOCK_TEXT));
        this.horizontalAltBlockButton = new HoverImageButton(baseX - (buttonWidth + 1) * 2, baseY, buttonWidth, buttonHeight, 0, 0, buttonWidth, HORIZONTAL_ALT_BLOCK, textureWidth, buttonHeight, buttonWidth, buttonHeight, button -> {
            this.setMode(RenderWindowWidget.Mode.HORIZONTAL_ALT_BLOCK);
            this.updateBlockPreview();
        }, currentMode == RenderWindowWidget.Mode.HORIZONTAL_ALT_BLOCK, false);
        this.horizontalAltBlockButton.m_257544_(Tooltip.m_257550_((Component)HORIZONTAL_ALT_BLOCK_TEXT));
        this.twoByTwoBlockButton = (HoverImageButton)this.m_142416_((GuiEventListener)new HoverImageButton(baseX - (buttonWidth + 1) * 4, baseY, buttonWidth, buttonHeight, 0, 0, buttonWidth, TWO_BY_TWO_BLOCK_BUTTON, textureWidth, buttonHeight, buttonWidth, buttonHeight, button -> {
            this.setMode(RenderWindowWidget.Mode.TWO_BY_TWO_BLOCK);
            this.updateBlockPreview();
        }, currentMode == RenderWindowWidget.Mode.TWO_BY_TWO_BLOCK, false));
        this.twoByTwoBlockButton.m_257544_(Tooltip.m_257550_((Component)TWO_BY_TWO_BLOCK_TEXT));
        HoverImageButton.group(this.singleBlockButton, this.lShapeBlockButton, this.verticalBlockButton, this.horizontalBlockButton, this.horizontalAltBlockButton, this.twoByTwoBlockButton);
        this.updateRenderWindowWidget();
    }

    private void onBlockStateChange(BlockState newState) {
        this.updateBlockPreview(newState);
    }

    private void renderPreviewTab(GuiGraphics guiGraphics) {
        guiGraphics.m_280163_(PREVIEW_TAB, this.f_97735_ - 111, this.f_97736_, 0.0f, 0.0f, 113, 122, 113, 122);
        guiGraphics.m_280614_(this.f_96547_, PREVIEW_TITLE_TEXT, this.f_96543_ / 2 - 191, this.f_97736_ + 5, 0x404040, false);
    }

    private void renderNoPreviewTab(GuiGraphics guiGraphics) {
    }

    private void updateRenderWindowWidget() {
        int x = this.f_97735_ - 96;
        int y = this.f_97736_ + 14;
        int width = 83;
        int height = 74;
        if (this.renderWindowWidget != null) {
            this.m_169411_((GuiEventListener)this.renderWindowWidget);
        }
        this.renderWindowWidget = (RenderWindowWidget)this.m_142416_((GuiEventListener)new RenderWindowWidget(x, y, width, height, () -> this.fakeLevel, this::onBlockStateChange));
        if (!this.showPreview) {
            this.m_169411_((GuiEventListener)this.singleBlockButton);
            this.m_169411_((GuiEventListener)this.lShapeBlockButton);
            this.m_169411_((GuiEventListener)this.verticalBlockButton);
            this.m_169411_((GuiEventListener)this.twoByTwoBlockButton);
            this.m_169411_((GuiEventListener)this.renderWindowWidget);
        }
    }

    private void setMode(RenderWindowWidget.Mode newMode) {
        if (currentMode != newMode) {
            currentMode = newMode;
        }
    }

    private void updateBlockPreview() {
        this.updateBlockPreview(null);
    }

    private void updateBlockPreview(BlockState overrideState) {
        this.previewStateLocked = overrideState != null;
        int selectedIndex = ((WorkstationMenu)this.f_97732_).getSelectedRecipeIndex();
        if (selectedIndex >= 0 && selectedIndex < ((WorkstationMenu)this.f_97732_).getRecipes().size()) {
            BlockState state;
            FilterableRecipe recipe = ((WorkstationMenu)this.f_97732_).getRecipes().get(selectedIndex);
            BlockState blockState = state = overrideState != null ? overrideState : this.currentBlockState(recipe);
            if (state != null && !state.m_60795_()) {
                List<BlockPos> positions = this.getPositionsForMode(currentMode);
                List<Direction> facings = this.getFacingForMode(currentMode);
                if (state.m_60734_() instanceof FenceBlock) {
                    this.fakeLevel.setBlocksWithConnections(state, positions);
                } else {
                    this.fakeLevel.setBlocksWithRotation(state, positions, facings);
                }
                if (this.renderWindowWidget != null) {
                    this.renderWindowWidget.setCurrentState(state);
                }
            } else {
                this.fakeLevel.clear();
                if (this.renderWindowWidget != null) {
                    this.renderWindowWidget.setCurrentState(null);
                }
            }
        } else {
            this.fakeLevel.clear();
            if (this.renderWindowWidget != null) {
                this.renderWindowWidget.setCurrentState(null);
            }
        }
    }

    private List<BlockPos> getPositionsForMode(RenderWindowWidget.Mode mode) {
        switch (mode) {
            case SINGLE_BLOCK: {
                return List.of(BlockPos.f_121853_);
            }
            case L_SHAPE_BLOCK: {
                return List.of(BlockPos.f_121853_, BlockPos.f_121853_.m_122012_(), BlockPos.f_121853_.m_122029_());
            }
            case VERTICAL_BLOCK: {
                return List.of(BlockPos.f_121853_, BlockPos.f_121853_.m_7494_());
            }
            case HORIZONTAL_BLOCK: {
                return List.of(BlockPos.f_121853_, BlockPos.f_121853_.m_122029_());
            }
            case HORIZONTAL_ALT_BLOCK: {
                return List.of(BlockPos.f_121853_, BlockPos.f_121853_.m_122012_());
            }
            case TWO_BY_TWO_BLOCK: {
                return List.of(BlockPos.f_121853_, BlockPos.f_121853_.m_122029_(), BlockPos.f_121853_.m_7494_(), BlockPos.f_121853_.m_122029_().m_7494_());
            }
        }
        return List.of(BlockPos.f_121853_);
    }

    private List<Direction> getFacingForMode(RenderWindowWidget.Mode mode) {
        switch (mode) {
            case L_SHAPE_BLOCK: {
                return List.of(Direction.EAST, Direction.EAST, Direction.NORTH);
            }
            case HORIZONTAL_ALT_BLOCK: {
                return List.of(Direction.SOUTH);
            }
        }
        return List.of(Direction.NORTH);
    }

    private void updateSearchBarVisibility() {
        boolean hasSearch;
        this.searchBox.f_93624_ = hasSearch = ConfigProvider.hasSearchBar(((WorkstationMenu)this.f_97732_).getRecipes().size());
        this.searchBox.f_93623_ = hasSearch;
    }

    protected void m_181908_() {
        super.m_181908_();
    }

    private void refreshSearchResults() {
        int oldSize = this.filteredRecipes.size();
        this.filteredRecipes.clear();
        boolean isFiltered = this.searchBox.f_93624_ && !this.searchBox.m_94155_().equals("");
        for (FilterableRecipe r : ((WorkstationMenu)this.f_97732_).getRecipes()) {
            if (isFiltered && !r.matchFilter(this.searchBox.m_94155_())) continue;
            this.filteredRecipes.add(r);
        }
        if (oldSize != this.filteredRecipes.size()) {
            this.scrollOffs = 0.0f;
            this.startIndex = 0;
        }
        this.updateSelectedIndex();
        if (this.filteredIndex == -1 && ((WorkstationMenu)this.f_97732_).getSelectedRecipeIndex() != -1 && ((WorkstationMenu)this.f_97732_).m_6366_((Player)this.f_96541_.f_91074_, -1)) {
            this.f_96541_.f_91072_.m_105208_(((WorkstationMenu)this.f_97732_).f_38840_, -1);
        }
        this.updateSearchBarVisibility();
    }

    private void updateSelectedIndex() {
        this.filteredIndex = -1;
        int selectedInd = ((WorkstationMenu)this.f_97732_).getSelectedRecipeIndex();
        List<FilterableRecipe> recipes = ((WorkstationMenu)this.f_97732_).getRecipes();
        if (selectedInd > -1 && selectedInd < recipes.size()) {
            this.filteredIndex = this.filteredRecipes.indexOf(recipes.get(selectedInd));
        }
    }

    public void m_6574_(Minecraft minecraft, int width, int height) {
        String string = this.searchBox.m_94155_();
        this.m_6575_(minecraft, width, height);
        this.searchBox.m_94144_(string);
        this.containerChanged();
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        String string = this.searchBox.m_94155_();
        if (this.searchBox.f_93624_ && this.searchBox.m_7933_(keyCode, scanCode, modifiers)) {
            if (!Objects.equals(string, this.searchBox.m_94155_())) {
                this.refreshSearchResults();
            }
            return true;
        }
        return this.searchBox.m_93696_() && this.searchBox.m_94213_() && keyCode != 256 ? true : super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.m_280072_(guiGraphics, mouseX, mouseY);
        int selectedIndex = ((WorkstationMenu)this.f_97732_).getSelectedRecipeIndex();
        if (selectedIndex >= 0 && selectedIndex < ((WorkstationMenu)this.f_97732_).getRecipes().size()) {
            FilterableRecipe recipe = ((WorkstationMenu)this.f_97732_).getRecipes().get(selectedIndex);
            ItemStack resultItem = recipe.output();
            Block block = Block.m_49814_((Item)resultItem.m_41720_());
            if (ConfigProvider.shouldShowPreview() && showPreviewStatic) {
                this.m_142416_((GuiEventListener)this.renderWindowWidget);
                this.m_169411_((GuiEventListener)this.singleBlockButton);
                this.m_169411_((GuiEventListener)this.lShapeBlockButton);
                this.m_169411_((GuiEventListener)this.verticalBlockButton);
                this.m_169411_((GuiEventListener)this.horizontalBlockButton);
                this.m_169411_((GuiEventListener)this.horizontalAltBlockButton);
                this.m_169411_((GuiEventListener)this.twoByTwoBlockButton);
                boolean changedMode = false;
                if (block instanceof ModBedBlock) {
                    if (currentMode != RenderWindowWidget.Mode.HORIZONTAL_ALT_BLOCK) {
                        this.setMode(RenderWindowWidget.Mode.HORIZONTAL_ALT_BLOCK);
                        changedMode = true;
                    }
                    this.m_142416_((GuiEventListener)this.horizontalAltBlockButton);
                    this.horizontalAltBlockButton.setStayClicked(true);
                    if (!this.previewStateLocked && changedMode) {
                        this.updateBlockPreview();
                    }
                } else if (block instanceof WardrobeBlock || block instanceof DoorBlock) {
                    if (currentMode != RenderWindowWidget.Mode.VERTICAL_BLOCK) {
                        this.setMode(RenderWindowWidget.Mode.VERTICAL_BLOCK);
                        changedMode = true;
                    }
                    this.m_142416_((GuiEventListener)this.verticalBlockButton);
                    this.verticalBlockButton.setStayClicked(true);
                    if (!this.previewStateLocked && changedMode) {
                        this.updateBlockPreview();
                    }
                } else {
                    if (currentMode == RenderWindowWidget.Mode.HORIZONTAL_ALT_BLOCK) {
                        this.setMode(RenderWindowWidget.Mode.SINGLE_BLOCK);
                        changedMode = true;
                    }
                    this.m_142416_((GuiEventListener)this.singleBlockButton);
                    this.m_142416_((GuiEventListener)this.lShapeBlockButton);
                    this.m_142416_((GuiEventListener)this.verticalBlockButton);
                    this.m_142416_((GuiEventListener)this.horizontalBlockButton);
                    this.m_142416_((GuiEventListener)this.twoByTwoBlockButton);
                    this.singleBlockButton.setStayClicked(currentMode == RenderWindowWidget.Mode.SINGLE_BLOCK);
                    this.lShapeBlockButton.setStayClicked(currentMode == RenderWindowWidget.Mode.L_SHAPE_BLOCK);
                    this.verticalBlockButton.setStayClicked(currentMode == RenderWindowWidget.Mode.VERTICAL_BLOCK);
                    this.horizontalBlockButton.setStayClicked(currentMode == RenderWindowWidget.Mode.HORIZONTAL_BLOCK);
                    this.twoByTwoBlockButton.setStayClicked(currentMode == RenderWindowWidget.Mode.TWO_BY_TWO_BLOCK);
                    if (!this.previewStateLocked && changedMode) {
                        this.updateBlockPreview();
                    }
                }
                if (this.previewButton != null) {
                    this.m_169411_((GuiEventListener)this.previewButton);
                    this.m_142416_((GuiEventListener)this.previewButton);
                    this.updatePreviewButtonPosition();
                }
                if (this.gearButton != null) {
                    this.m_169411_((GuiEventListener)this.gearButton);
                    this.m_142416_((GuiEventListener)this.gearButton);
                }
            }
        }
    }

    private void renderSmallerText(GuiGraphics guiGraphics, Component text, int x, int y, int color, float scale) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_((float)x, (float)y, 0.0f);
        poseStack.m_85841_(scale, scale, 1.0f);
        guiGraphics.m_280614_(this.f_96547_, text, 0, 0, color, true);
        poseStack.m_85849_();
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        ResourceLocation bgLocation = this.getBgLocation();
        guiGraphics.m_280218_(bgLocation, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        int barH = this.scrollBarHeight();
        int scrollY = this.minScrollY();
        float barSpan = this.maxScrollY() - scrollY - barH;
        int barPos = (int)(barSpan * this.scrollOffs);
        guiGraphics.m_280218_(bgLocation, this.minScrollX(), scrollY + barPos, 176 + (this.isScrollBarActive() ? 0 : 12), 0, 12, barH);
        if (ConfigProvider.shouldShowPreview() && this.showPreview) {
            this.renderPreviewTab(guiGraphics);
        }
        if (!this.displayRecipes) {
            return;
        }
        this.forEachButton((index, buttonX, buttonY) -> {
            int textureY = this.f_97727_;
            if (index == this.filteredIndex) {
                textureY += 18;
            } else if (mouseX >= buttonX && mouseY >= buttonY && mouseX < buttonX + 16 && mouseY < buttonY + 18) {
                textureY += 36;
            }
            guiGraphics.m_280218_(BACKGROUND, buttonX, buttonY, 0, textureY, 16, 18);
        });
        this.forEachButton((index, buttonX, buttonY) -> {
            ItemStack item = this.filteredRecipes.get(index).recipe().output().m_41777_();
            guiGraphics.m_280203_(item, buttonX, buttonY + 1);
            guiGraphics.m_280370_(this.f_96547_, item, buttonX, buttonY + 1);
        });
    }

    private FilterableRecipe getSelectedRecipe() {
        int selectedIndex = ((WorkstationMenu)this.f_97732_).getSelectedRecipeIndex();
        if (selectedIndex >= 0 && selectedIndex < ((WorkstationMenu)this.f_97732_).getRecipes().size()) {
            return ((WorkstationMenu)this.f_97732_).getRecipes().get(selectedIndex);
        }
        return null;
    }

    @NotNull
    private ResourceLocation getBgLocation() {
        return this.searchBox.f_93624_ ? BACKGROUND_SEARCH : BACKGROUND;
    }

    protected void m_280072_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.m_280072_(guiGraphics, mouseX, mouseY);
        if (this.displayRecipes) {
            this.forEachButton((index, buttonX, buttonY) -> {
                if (mouseX >= buttonX && mouseX < buttonX + 16 && mouseY >= buttonY && mouseY < buttonY + 18) {
                    guiGraphics.m_280153_(this.f_96547_, this.filteredRecipes.get(index).recipe().output(), mouseX, mouseY);
                }
            });
        }
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int input;
        super.m_280003_(guiGraphics, mouseX, mouseY);
        if (this.filteredIndex >= 0 && this.filteredIndex < this.filteredRecipes.size() && (input = this.filteredRecipes.get(this.filteredIndex).recipe().getInputCount()) != 1) {
            String multiplier = input + "x";
            int labelX = this.f_97728_ + -4;
            guiGraphics.m_280056_(this.f_96547_, multiplier, labelX, this.f_97729_ + 37, 0x404040, false);
        }
    }

    private int buttonCount() {
        return this.getRows() * this.buttonsPerRow();
    }

    private int buttonsPerRow() {
        return 5;
    }

    private int getRows() {
        return this.searchBox.f_93624_ ? 2 : 3;
    }

    private int minScrollX() {
        return this.f_97735_ + 123;
    }

    private int maxScrollX() {
        return this.minScrollX() + 12;
    }

    private int minScrollY() {
        return this.f_97736_ + (this.searchBox.f_93624_ ? 30 : 15);
    }

    private int maxScrollY() {
        return this.f_97736_ + (this.searchBox.f_93624_ ? 66 : 70);
    }

    private int scrollBarHeight() {
        return this.searchBox.f_93624_ ? 11 : 15;
    }

    private void forEachButton(ButtonConsumer buttonConsumer) {
        int buttonBoxX = this.f_97735_ + 40;
        int buttonBoxY = this.f_97736_ + (this.searchBox.f_93624_ ? 28 : 13);
        int lastVisibleElementIndex = this.startIndex + this.buttonCount();
        int buttonsPerRow = this.buttonsPerRow();
        for (int index = this.startIndex; index < lastVisibleElementIndex && index < this.filteredRecipes.size(); ++index) {
            int visualIndex = index - this.startIndex;
            int buttonX = buttonBoxX + visualIndex % buttonsPerRow * 16;
            int buttonY = buttonBoxY + visualIndex / buttonsPerRow * 18 + 2;
            buttonConsumer.accept(index, buttonX, buttonY);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        boolean result;
        if (this.renderWindowWidget != null && this.renderWindowWidget.m_5953_(mouseX, mouseY) && (result = this.renderWindowWidget.m_6375_(mouseX, mouseY, button))) {
            return true;
        }
        this.scrolling = false;
        if (this.displayRecipes) {
            AtomicReference<Boolean> success = new AtomicReference<Boolean>(false);
            this.forEachButton((index, buttonX, buttonY) -> {
                if (((Boolean)success.get()).booleanValue()) {
                    return;
                }
                int actualIndex = ((WorkstationMenu)this.f_97732_).getRecipes().indexOf(this.filteredRecipes.get(index));
                if (mouseX >= (double)buttonX && mouseX < (double)(buttonX + 16) && mouseY >= (double)buttonY && mouseY < (double)(buttonY + 18)) {
                    if (((WorkstationMenu)this.f_97732_).m_6366_((Player)this.f_96541_.f_91074_, actualIndex)) {
                        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)ModSoundEvents.WORKSTATION_SELECT.get(), (float)1.0f));
                        this.f_96541_.f_91072_.m_105208_(((WorkstationMenu)this.f_97732_).f_38840_, actualIndex);
                        this.updateSelectedIndex();
                        this.updateBlockPreview();
                    }
                    success.set(true);
                }
            });
            if (success.get().booleanValue()) {
                return true;
            }
            if (mouseX >= (double)this.minScrollX() && mouseX < (double)this.maxScrollX() && mouseY >= (double)this.minScrollY() && mouseY < (double)this.maxScrollY()) {
                this.scrolling = true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    protected boolean m_7467_(double mouseX, double mouseY, int left, int top, int button) {
        if (this.renderWindowWidget != null && this.renderWindowWidget.m_5953_(mouseX, mouseY)) {
            return false;
        }
        boolean flag = mouseX < (double)left || mouseY < (double)top || mouseX >= (double)(left + this.f_97726_) || mouseY >= (double)(top + this.f_97727_);
        return this.recipeBookComponent.m_100297_(mouseX, mouseY, this.f_97735_, this.f_97736_, this.f_97726_, this.f_97727_, button) && flag;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        boolean result;
        if (this.renderWindowWidget != null && (result = this.renderWindowWidget.m_7979_(mouseX, mouseY, button, dragX, dragY))) {
            return true;
        }
        if (this.scrolling && this.isScrollBarActive()) {
            int min = this.minScrollY();
            int max = this.maxScrollY();
            this.scrollOffs = ((float)mouseY - (float)min - 7.5f) / ((float)(max - min) - 15.0f);
            this.scrollOffs = Mth.m_14036_((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)this.getOffscreenRows()) + 0.5) * 5;
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        boolean result;
        if (this.renderWindowWidget != null && (result = this.renderWindowWidget.m_6348_(mouseX, mouseY, button))) {
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        boolean result;
        if (this.renderWindowWidget != null && this.renderWindowWidget.m_5953_(mouseX, mouseY) && (result = this.renderWindowWidget.m_6050_(mouseX, mouseY, delta))) {
            return true;
        }
        if (this.isScrollBarActive()) {
            int offscreenRows = this.getOffscreenRows();
            float f = (float)delta / (float)offscreenRows;
            this.scrollOffs = Mth.m_14036_((float)(this.scrollOffs - f), (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)offscreenRows) + 0.5) * 5;
        }
        return true;
    }

    private boolean isScrollBarActive() {
        return this.displayRecipes && this.filteredRecipes.size() > this.buttonCount();
    }

    protected int getOffscreenRows() {
        return (this.filteredRecipes.size() + 4 - 1) / 4 - this.getRows();
    }

    private void containerChanged() {
        this.displayRecipes = ((WorkstationMenu)this.f_97732_).hasInputItem();
        if (!this.displayRecipes) {
            this.scrollOffs = 0.0f;
            this.startIndex = 0;
            this.searchBox.m_94144_("");
        } else {
            this.m_7522_((GuiEventListener)this.searchBox);
        }
        this.searchBox.m_94186_(this.displayRecipes);
        this.searchBox.m_93692_(this.displayRecipes);
        this.refreshSearchResults();
    }

    public RenderWindowWidget.Mode currentMode() {
        return currentMode;
    }

    private BlockState currentBlockState(FilterableRecipe recipe) {
        ItemStack resultItem = recipe.output();
        Block block = Block.m_49814_((Item)resultItem.m_41720_());
        BlockState state = block.m_49966_();
        return state.m_60795_() ? null : state;
    }

    private static interface ButtonConsumer {
        public void accept(int var1, int var2, int var3);
    }
}

