/*
 * Decompiled with CFR 0.152.
 */
package net.lyivx.ls_furniture.common.blocks;

import java.util.List;
import java.util.stream.Stream;
import net.lyivx.ls_core.common.utils.WoolHelper;
import net.lyivx.ls_furniture.common.blocks.entity.LockableBlockEntity;
import net.lyivx.ls_furniture.common.blocks.properties.ColorType;
import net.lyivx.ls_furniture.common.blocks.properties.ModBlockStateProperties;
import net.lyivx.ls_furniture.common.utils.ShapeUtil;
import net.lyivx.ls_furniture.registry.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModBedBlock
extends BedBlock
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<BedPart> PART = BlockStateProperties.f_61391_;
    public static final BooleanProperty OCCUPIED = BlockStateProperties.f_61445_;
    public static final EnumProperty<ColorType> COLOR = ModBlockStateProperties.COLOR;
    private static final VoxelShape HEAD_SHAPE = Stream.of(Block.m_49796_((double)0.0, (double)0.0, (double)-16.0, (double)2.0, (double)2.0, (double)-14.0), Block.m_49796_((double)0.0, (double)2.0, (double)12.0, (double)16.0, (double)6.5, (double)16.0), Block.m_49796_((double)0.0, (double)6.0, (double)12.45, (double)16.0, (double)10.5, (double)16.0), Block.m_49796_((double)0.0, (double)10.0, (double)13.2, (double)16.0, (double)12.0, (double)16.75), Block.m_49796_((double)0.0, (double)12.0, (double)13.95, (double)16.0, (double)14.0, (double)17.5), Block.m_49796_((double)0.0, (double)2.0, (double)-16.0, (double)16.0, (double)6.5, (double)12.0), Block.m_49796_((double)14.0, (double)0.0, (double)-16.0, (double)16.0, (double)2.0, (double)-14.0), Block.m_49796_((double)14.0, (double)0.0, (double)14.0, (double)16.0, (double)2.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)2.0, (double)2.0, (double)16.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape FOOT_SHAPE = Stream.of(Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)2.0, (double)2.0), Block.m_49796_((double)0.0, (double)2.0, (double)28.0, (double)16.0, (double)6.5, (double)32.0), Block.m_49796_((double)0.0, (double)6.0, (double)28.45, (double)16.0, (double)10.5, (double)32.0), Block.m_49796_((double)0.0, (double)10.0, (double)29.2, (double)16.0, (double)12.0, (double)32.75), Block.m_49796_((double)0.0, (double)12.0, (double)29.95, (double)16.0, (double)14.0, (double)33.5), Block.m_49796_((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)6.5, (double)28.0), Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)2.0), Block.m_49796_((double)14.0, (double)0.0, (double)30.0, (double)16.0, (double)2.0, (double)32.0), Block.m_49796_((double)0.0, (double)0.0, (double)30.0, (double)2.0, (double)2.0, (double)32.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape[] SHAPES = new VoxelShape[8];

    public ModBedBlock(BlockBehaviour.Properties properties) {
        super(DyeColor.WHITE, properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(PART, (Comparable)BedPart.FOOT)).m_61124_((Property)OCCUPIED, (Comparable)Boolean.valueOf(false))).m_61124_(COLOR, (Comparable)((Object)ColorType.DEFAULT)));
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, COLOR, PART, OCCUPIED});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new LockableBlockEntity(pos, state);
    }

    private static Direction getNeighbourDirection(BedPart part, Direction direction) {
        return part == BedPart.FOOT ? direction : direction.m_122424_();
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BlockPos blockPos;
        BlockState blockState;
        BedPart bedPart;
        if (!level.f_46443_ && player.m_7500_() && (bedPart = (BedPart)state.m_61143_(PART)) == BedPart.FOOT && (blockState = level.m_8055_(blockPos = pos.m_121945_(ModBedBlock.getNeighbourDirection(bedPart, (Direction)state.m_61143_((Property)FACING))))).m_60713_((Block)this) && blockState.m_61143_(PART) == BedPart.HEAD) {
            level.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 35);
            level.m_5898_(player, 2001, blockPos, Block.m_49956_((BlockState)blockState));
        }
        super.m_5707_(level, pos, state, player);
    }

    public static ColorType getColorTypeFromDye(DyeColor dyeColor) {
        for (ColorType colorType : ColorType.values()) {
            if (colorType.getDyeColor() != dyeColor) continue;
            return colorType;
        }
        return ColorType.WHITE;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        DyeColor dye;
        ItemStack stack = player.m_21120_(hand);
        DyeColor woolDye = WoolHelper.getDyeColor((ItemLike)stack.m_41720_());
        if (woolDye != null && state.m_61143_(COLOR) == ColorType.DEFAULT) {
            ColorType newColorType = ModBedBlock.getColorTypeFromDye(woolDye);
            state = (BlockState)state.m_61124_(COLOR, (Comparable)((Object)newColorType));
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            level.m_7731_(pos, state, 3);
            level.m_7260_(pos, state, state, 3);
            return InteractionResult.SUCCESS;
        }
        Item item = stack.m_41720_();
        if (item instanceof DyeItem) {
            DyeItem dyeItem = (DyeItem)item;
            v0 = dyeItem.m_41089_();
        } else {
            v0 = dye = null;
        }
        if (dye != null && state.m_61143_(COLOR) != ColorType.DEFAULT) {
            ColorType newColorType = ModBedBlock.getColorTypeFromDye(dye);
            state = (BlockState)state.m_61124_(COLOR, (Comparable)((Object)newColorType));
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            level.m_7731_(pos, state, 3);
            level.m_7260_(pos, state, state, 3);
            return InteractionResult.SUCCESS;
        }
        if (stack.m_150930_(ModItems.SHEARS.get()) && state.m_61143_(COLOR) != ColorType.DEFAULT) {
            this.dropCushion(state, level, pos);
            state = (BlockState)state.m_61124_(COLOR, (Comparable)((Object)ColorType.DEFAULT));
            level.m_7731_(pos, state, 3);
            level.m_7260_(pos, state, state, 3);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    private boolean kickVillagerOutOfBed(Level level, BlockPos pos) {
        List list = level.m_6443_(Villager.class, new AABB(pos), LivingEntity::m_5803_);
        if (list.isEmpty()) {
            return false;
        }
        ((Villager)list.get(0)).m_5796_();
        return true;
    }

    public void m_6810_(BlockState state, @NotNull Level level, @NotNull BlockPos pos, BlockState newState, boolean moving) {
        if (!state.m_60713_(newState.m_60734_())) {
            this.dropCushion(state, level, pos);
        }
        super.m_6810_(state, level, pos, newState, moving);
    }

    public void dropCushion(BlockState state, Level level, BlockPos pos) {
        if (state.m_61138_(COLOR) && state.m_61143_(COLOR) != ColorType.DEFAULT) {
            Block block = WoolHelper.getBlock((DyeColor)((ColorType)((Object)state.m_61143_(COLOR))).getDyeColor());
            Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)new ItemStack((ItemLike)(block != null ? block : Blocks.f_50041_)));
        }
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        return super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction direction = ((Direction)state.m_61143_((Property)FACING)).m_122424_();
        int shape = ((Direction)state.m_61143_((Property)FACING)).m_122416_();
        if (state.m_61143_(PART) == BedPart.HEAD) {
            return SHAPES[direction.m_122416_()];
        }
        if (state.m_61143_(PART) == BedPart.FOOT) {
            return SHAPES[4 + direction.m_122416_()];
        }
        return SHAPES[shape];
    }

    static {
        ModBedBlock.SHAPES[0] = ShapeUtil.rotateShape(HEAD_SHAPE, Direction.SOUTH);
        ModBedBlock.SHAPES[1] = ShapeUtil.rotateShape(HEAD_SHAPE, Direction.WEST);
        ModBedBlock.SHAPES[2] = ShapeUtil.rotateShape(HEAD_SHAPE, Direction.NORTH);
        ModBedBlock.SHAPES[3] = ShapeUtil.rotateShape(HEAD_SHAPE, Direction.EAST);
        ModBedBlock.SHAPES[4] = ShapeUtil.rotateShape(FOOT_SHAPE, Direction.SOUTH);
        ModBedBlock.SHAPES[5] = ShapeUtil.rotateShape(FOOT_SHAPE, Direction.WEST);
        ModBedBlock.SHAPES[6] = ShapeUtil.rotateShape(FOOT_SHAPE, Direction.NORTH);
        ModBedBlock.SHAPES[7] = ShapeUtil.rotateShape(FOOT_SHAPE, Direction.EAST);
    }
}

