/*
 * Decompiled with CFR 0.152.
 */
package net.lyivx.ls_furniture.common.blocks.entity;

import java.util.UUID;
import net.lyivx.ls_furniture.common.blocks.MailboxBlock;
import net.lyivx.ls_furniture.common.items.LetterItem;
import net.lyivx.ls_furniture.common.menus.ModChestMenu;
import net.lyivx.ls_furniture.common.utils.block.BlockEntityHelper;
import net.lyivx.ls_furniture.registry.ModBlockEntitys;
import net.lyivx.ls_furniture.registry.ModBlocksTags;
import net.lyivx.ls_furniture.registry.ModItemTags;
import net.lyivx.ls_furniture.registry.ModSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class MailboxBlockEntity
extends RandomizableContainerBlockEntity {
    private NonNullList<ItemStack> items = NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_);
    private ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void m_142292_(Level level, BlockPos pos, BlockState state) {
            MailboxBlockEntity.this.playSound(state, SoundEvents.f_11725_);
        }

        protected void m_142289_(Level level, BlockPos pos, BlockState state) {
            MailboxBlockEntity.this.playSound(state, SoundEvents.f_11724_);
        }

        protected void m_142148_(Level level, BlockPos pos, BlockState state, int count, int openCount) {
        }

        protected boolean m_142718_(Player player) {
            if (player.f_36096_ instanceof ModChestMenu) {
                Container container = ((ModChestMenu)player.f_36096_).getContainer();
                return container == MailboxBlockEntity.this;
            }
            return false;
        }
    };
    private String owner;
    private String ownerDisplayName;

    public MailboxBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(ModBlockEntitys.MAILBOX_ENTITY.get(), blockPos, blockState);
    }

    public boolean hasMail() {
        for (ItemStack stack : this.items) {
            if (stack.m_41619_()) continue;
            return true;
        }
        return false;
    }

    void updateBlockState(BlockState state, boolean hasMail) {
        BlockState newState = (BlockState)state.m_61124_((Property)MailboxBlock.HAS_MAIL, (Comparable)Boolean.valueOf(hasMail));
        if (newState != state) {
            this.f_58857_.m_7731_(this.m_58899_(), newState, 3);
        }
    }

    public void updateDisplayName(Player playerEntity) {
        if (this.isOwner(playerEntity)) {
            String playerName = playerEntity.m_36316_().getName();
            if (this.ownerDisplayName == null || !this.ownerDisplayName.equals(playerName)) {
                this.ownerDisplayName = playerName;
                BlockEntityHelper.broadcastUpdate((BlockEntity)this, false);
            }
        }
    }

    public void setOwner(Player playerEntity) {
        this.owner = playerEntity.m_20149_();
        this.ownerDisplayName = playerEntity.m_36316_().getName();
        BlockEntityHelper.broadcastUpdate((BlockEntity)this, false);
    }

    public UUID getOwner() {
        return UUID.fromString(this.owner);
    }

    public boolean hasOwner() {
        return this.owner != null && !this.owner.isEmpty();
    }

    public boolean isOwner(Player playerEntity) {
        return this.hasOwner() && playerEntity.m_20149_().equals(this.owner);
    }

    protected void m_6520_(NonNullList<ItemStack> itemStacks) {
        this.items = itemStacks;
    }

    public boolean isFull() {
        return !this.items.contains((Object)ItemStack.f_41583_);
    }

    public ItemStack addMail(ItemStack stack) {
        int slot;
        if (!this.m_58900_().m_204336_(ModBlocksTags.BYPASSES_MAIL_TAG_TAG) && !stack.m_204117_(ModItemTags.MAIL_TAG)) {
            return stack;
        }
        if (stack.m_41720_() instanceof LetterItem) {
            LetterItem.signLetter(stack, "Anonymous Player");
        }
        if ((slot = this.getFreeSlot()) < this.m_6643_()) {
            ItemStack currentStack = (ItemStack)this.items.get(slot);
            if (currentStack.m_41619_()) {
                ItemStack stackToAdd = stack.m_41777_();
                stackToAdd.m_41764_(1);
                this.items.set(slot, (Object)stackToAdd);
                stack.m_41774_(1);
                BlockEntityHelper.broadcastUpdate((BlockEntity)this, false);
                this.updateBlockState(this.m_58900_(), this.hasMail());
                Player mailboxOwner = this.f_58857_.m_46003_(this.getOwner());
                if (mailboxOwner != null) {
                    if (this.m_8077_()) {
                        mailboxOwner.m_5661_((Component)Component.m_237110_((String)"msg.ls_furniture.mailbox.new_mail_loc", (Object[])new Object[]{this.m_7770_()}), true);
                    } else {
                        mailboxOwner.m_5661_((Component)Component.m_237115_((String)"msg.ls_furniture.mailbox.new_mail"), true);
                    }
                    if (mailboxOwner instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)mailboxOwner;
                        BlockEntityHelper.playSoundToPlayer(serverPlayer, ModSoundEvents.MAIL_RECEIVED.get(), SoundSource.MASTER, 1.0f, 1.0f);
                    }
                }
                return stack;
            }
            return stack;
        }
        return stack;
    }

    private int getFreeSlot() {
        int slot;
        for (slot = 0; slot < this.items.size() && !((ItemStack)this.items.get(slot)).m_41619_(); ++slot) {
        }
        return slot;
    }

    public Component getOwnerDisplayName() {
        return !this.hasOwner() || this.ownerDisplayName == null || this.ownerDisplayName.isEmpty() ? null : Component.m_237113_((String)this.ownerDisplayName);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128359_("Owner", this.owner == null ? "" : this.owner);
        tag.m_128359_("OwnerDisplayName", this.ownerDisplayName == null ? "" : this.ownerDisplayName);
        if (!this.m_59634_(tag)) {
            ContainerHelper.m_18973_((CompoundTag)tag, this.items);
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.owner = tag.m_128461_("Owner");
        this.ownerDisplayName = tag.m_128461_("OwnerDisplayName");
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        if (!this.m_59631_(tag)) {
            ContainerHelper.m_18980_((CompoundTag)tag, this.items);
        }
    }

    public int m_6643_() {
        return 9;
    }

    protected NonNullList<ItemStack> m_7086_() {
        return this.items;
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"container.ls_furniture.mailbox");
    }

    protected AbstractContainerMenu m_6555_(int containerId, Inventory inventory) {
        return ModChestMenu.oneRows(containerId, inventory, (Container)this);
    }

    public void m_5856_(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.openersCounter.m_155452_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void m_5785_(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.openersCounter.m_155468_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void recheckOpen() {
        if (!this.f_58859_) {
            this.openersCounter.m_155476_(this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    void playSound(BlockState state, SoundEvent sound) {
        Vec3i vec3i = ((Direction)state.m_61143_((Property)MailboxBlock.FACING)).m_122436_();
        double d = (double)this.f_58858_.m_123341_() + 0.5 + (double)vec3i.m_123341_() / 2.0;
        double e = (double)this.f_58858_.m_123342_() + 0.5 + (double)vec3i.m_123342_() / 2.0;
        double f = (double)this.f_58858_.m_123343_() + 0.5 + (double)vec3i.m_123343_() / 2.0;
        this.f_58857_.m_6263_(null, d, e, f, sound, SoundSource.BLOCKS, 0.5f, this.f_58857_.f_46441_.m_188501_() * 0.1f + 0.9f);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, MailboxBlockEntity blockEntity) {
        if (!level.f_46443_) {
            MailboxBlockEntity mailboxBlockEntity = blockEntity;
            boolean hasMail = mailboxBlockEntity.hasMail();
            if ((Boolean)state.m_61143_((Property)MailboxBlock.HAS_MAIL) != hasMail) {
                mailboxBlockEntity.updateBlockState(state, hasMail);
                level.m_5594_(null, pos, ModSoundEvents.MAILBOX_UPDATE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }
}

