/*
 * Decompiled with CFR 0.152.
 */
package net.hyrrx.hardcoretruedarkness.mixin;

import com.mojang.blaze3d.platform.NativeImage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LightTexture.class})
public abstract class LightTextureMixin {
    @Unique
    private long hardcoretruedarkness$lastTickUpdated = -1L;
    @Unique
    private float hardcoretruedarkness$cachedDarknessEffectStrength = 0.0f;
    @Unique
    private boolean hardcoretruedarkness$cachedIsOverworld = false;
    @Unique
    private boolean hardcoretruedarkness$playerHasNightVisionCache = false;

    @Unique
    private void hardcoretruedarkness$updateCachedValues(Minecraft mc) {
        if (mc.f_91073_ == null || mc.f_91074_ == null) {
            this.hardcoretruedarkness$cachedDarknessEffectStrength = 0.0f;
            this.hardcoretruedarkness$playerHasNightVisionCache = false;
            this.hardcoretruedarkness$cachedIsOverworld = false;
            return;
        }
        long currentGameTick = mc.f_91073_.m_46467_();
        boolean currentIsOverworld = mc.f_91073_.m_46472_() == Level.f_46428_;
        this.hardcoretruedarkness$playerHasNightVisionCache = mc.f_91074_.m_21023_(MobEffects.f_19611_);
        if (currentGameTick != this.hardcoretruedarkness$lastTickUpdated || currentIsOverworld != this.hardcoretruedarkness$cachedIsOverworld) {
            this.hardcoretruedarkness$lastTickUpdated = currentGameTick;
            this.hardcoretruedarkness$cachedIsOverworld = currentIsOverworld;
        }
        if (!this.hardcoretruedarkness$cachedIsOverworld || this.hardcoretruedarkness$playerHasNightVisionCache) {
            this.hardcoretruedarkness$cachedDarknessEffectStrength = 0.0f;
            return;
        }
        long currentTimeInDay = mc.f_91073_.m_46468_() % 24000L;
        float strength = 0.0f;
        long nightStart = 13000L;
        long nightEnd = 23000L;
        long transition = 400L;
        if (transition <= 0L) {
            strength = nightStart <= nightEnd ? (currentTimeInDay >= nightStart && currentTimeInDay < nightEnd ? 1.0f : 0.0f) : (currentTimeInDay >= nightStart || currentTimeInDay < nightEnd ? 1.0f : 0.0f);
        } else if (nightStart <= nightEnd) {
            long duskFadeInStart = nightStart - transition;
            long dawnFadeOutEnd = nightEnd + transition;
            strength = currentTimeInDay >= duskFadeInStart && currentTimeInDay < nightStart ? (float)(currentTimeInDay - duskFadeInStart) / (float)transition : (currentTimeInDay >= nightStart && currentTimeInDay < nightEnd ? 1.0f : (currentTimeInDay >= nightEnd && currentTimeInDay < dawnFadeOutEnd ? 1.0f - (float)(currentTimeInDay - nightEnd) / (float)transition : 0.0f));
        } else {
            long duskFadeInStart = nightStart - transition;
            long dawnFadeOutEnd = nightEnd + transition;
            strength = currentTimeInDay >= duskFadeInStart && currentTimeInDay < nightStart ? (float)(currentTimeInDay - duskFadeInStart) / (float)transition : (currentTimeInDay >= nightStart ? 1.0f : (currentTimeInDay < nightEnd ? 1.0f : (currentTimeInDay >= nightEnd && currentTimeInDay < dawnFadeOutEnd ? 1.0f - (float)(currentTimeInDay - nightEnd) / (float)transition : 0.0f)));
        }
        this.hardcoretruedarkness$cachedDarknessEffectStrength = Mth.m_14036_((float)strength, (float)0.0f, (float)1.0f);
    }

    @Inject(method={"m_109881_(F)V"}, at={@At(value="HEAD")})
    private void hardcoretruedarkness_onUpdateLightTextureHEAD(float partialTicks, CallbackInfo ci) {
        Minecraft mc = Minecraft.m_91087_();
        this.hardcoretruedarkness$updateCachedValues(mc);
    }

    @Redirect(method={"m_109881_(F)V"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/platform/NativeImage;m_84988_(III)V"))
    private void hardcoretruedarkness_redirectSetPixelRGBA(NativeImage imageInstance, int x_blockLight, int y_skyLight, int originalColor) {
        int finalColor;
        float localLightBasedStrength;
        if (this.hardcoretruedarkness$playerHasNightVisionCache) {
            imageInstance.m_84988_(x_blockLight, y_skyLight, originalColor);
            return;
        }
        if (!this.hardcoretruedarkness$cachedIsOverworld) {
            imageInstance.m_84988_(x_blockLight, y_skyLight, originalColor);
            return;
        }
        float skyBasedTimeDarknessFactor = this.hardcoretruedarkness$cachedDarknessEffectStrength;
        float effectivePixelGlobalDarknessFactor = y_skyLight <= 1 ? 1.0f : skyBasedTimeDarknessFactor;
        if (effectivePixelGlobalDarknessFactor <= 0.0f) {
            imageInstance.m_84988_(x_blockLight, y_skyLight, originalColor);
            return;
        }
        if (x_blockLight <= 0) {
            localLightBasedStrength = 1.0f;
        } else if (x_blockLight < 7) {
            float endThreshold = 7.0f;
            float startThreshold = 0.0f;
            float range = endThreshold - startThreshold;
            if (range > 0.0f) {
                float progressInRange = ((float)x_blockLight - startThreshold) / range;
                localLightBasedStrength = 1.0f - progressInRange;
            } else {
                localLightBasedStrength = 0.0f;
            }
        } else {
            localLightBasedStrength = 0.0f;
        }
        localLightBasedStrength = Mth.m_14036_((float)localLightBasedStrength, (float)0.0f, (float)1.0f);
        if (localLightBasedStrength <= 0.0f) {
            imageInstance.m_84988_(x_blockLight, y_skyLight, originalColor);
            return;
        }
        float finalPixelDarknessFactor = effectivePixelGlobalDarknessFactor * localLightBasedStrength;
        if (finalPixelDarknessFactor >= 1.0f) {
            finalColor = -16777216;
        } else {
            float lightMultiplier = 1.0f - finalPixelDarknessFactor;
            int alpha = originalColor >> 24 & 0xFF;
            int red = (int)((float)(originalColor >> 16 & 0xFF) * lightMultiplier);
            int green = (int)((float)(originalColor >> 8 & 0xFF) * lightMultiplier);
            int blue = (int)((float)(originalColor & 0xFF) * lightMultiplier);
            finalColor = alpha << 24 | Mth.m_14045_((int)red, (int)0, (int)255) << 16 | Mth.m_14045_((int)green, (int)0, (int)255) << 8 | Mth.m_14045_((int)blue, (int)0, (int)255);
        }
        imageInstance.m_84988_(x_blockLight, y_skyLight, finalColor);
    }
}

