/*
 * Decompiled with CFR 0.152.
 */
package com.draconicarcher.brewincompatdelight.events;

import com.draconicarcher.brewincompatdelight.registries.BCDEffectRegistry;
import com.draconicarcher.brewincompatdelight.registries.BCDModEffects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="brewincompatdelight")
public class ProjectileDamageEvent {
    private static final TagKey<Item> BOWS_TAG = ItemTags.create((ResourceLocation)new ResourceLocation("forge", "tools/bows"));
    private static final TagKey<Item> CROSSBOWS_TAG = ItemTags.create((ResourceLocation)new ResourceLocation("forge", "tools/crossbows"));
    private static final TagKey<Item> C_BOWS_TAG = ItemTags.create((ResourceLocation)new ResourceLocation("c", "tools/bow"));
    private static final TagKey<Item> C_CROSSBOWS_TAG = ItemTags.create((ResourceLocation)new ResourceLocation("c", "tools/crossbow"));

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        ServerPlayer player;
        AbstractArrow arrow;
        Entity shooter;
        Entity entity;
        if (event.getSource() != null && (entity = event.getSource().m_7640_()) instanceof AbstractArrow && (shooter = (arrow = (AbstractArrow)entity).m_19749_()) instanceof ServerPlayer && (player = (ServerPlayer)shooter).m_21023_((MobEffect)BCDModEffects.PROJECTILE_DAMAGE.get())) {
            int effectLevel = player.m_21124_((MobEffect)BCDModEffects.PROJECTILE_DAMAGE.get()).m_19564_() + 1;
            event.setAmount(event.getAmount() * (1.0f + 0.25f * (float)effectLevel));
        }
    }

    @SubscribeEvent
    public static void onArrowSpawn(EntityJoinLevelEvent event) {
        ServerPlayer player;
        AbstractArrow arrow;
        Entity entity = event.getEntity();
        if (entity instanceof AbstractArrow && (entity = (arrow = (AbstractArrow)entity).m_19749_()) instanceof ServerPlayer && (player = (ServerPlayer)entity).m_21023_((MobEffect)BCDModEffects.PROJECTILE_DAMAGE.get())) {
            int effectLevel = player.m_21124_((MobEffect)BCDModEffects.PROJECTILE_DAMAGE.get()).m_19564_() + 1;
            int damageAmount = effectLevel * 2;
            if (player.m_20194_() != null) {
                player.m_20194_().execute(() -> BCDEffectRegistry.applyProjectileDamageEffect((LivingEntity)player));
            }
        }
    }
}

