/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.details;

import com.google.gson.JsonParseException;
import dan200.computercraft.shared.details.DetailHelpers;
import dan200.computercraft.shared.platform.RegistryWrappers;
import dan200.computercraft.shared.util.NBTUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.LingeringPotionItem;
import net.minecraft.world.item.TippedArrowItem;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.EmptyBlockGetter;
import net.minecraft.world.level.block.Block;
import org.jspecify.annotations.Nullable;

public class ItemDetails {
    public static void fillBasic(Map<? super String, Object> data, ItemStack stack) {
        data.put("name", DetailHelpers.getId(RegistryWrappers.ITEMS, stack.m_41720_()));
        data.put("count", stack.m_41613_());
        String hash = NBTUtil.getNBTHash(stack.m_41783_());
        if (hash != null) {
            data.put("nbt", hash);
        }
    }

    public static void fill(Map<? super String, Object> data, ItemStack stack) {
        List<Map<String, Object>> effects;
        int hideFlags;
        List<Map<String, Object>> enchants;
        List<String> lore;
        CompoundTag displayTag;
        data.put("displayName", stack.m_41786_().getString());
        data.put("maxCount", stack.m_41741_());
        if (stack.m_41763_()) {
            data.put("damage", stack.m_41773_());
            data.put("maxDamage", stack.m_41776_());
        }
        if (stack.m_41720_().m_142522_(stack)) {
            data.put("durability", (double)stack.m_41720_().m_142158_(stack) / 13.0);
        }
        data.put("tags", DetailHelpers.getTags(stack.m_204131_()));
        data.put("itemGroups", List.of());
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128425_("display", 10) && (displayTag = tag.m_128469_("display")).m_128425_("Lore", 9) && !(lore = displayTag.m_128437_("Lore", 8).stream().map(ItemDetails::parseTextComponent).filter(Objects::nonNull).map(Component::getString).toList()).isEmpty()) {
            data.put("lore", lore);
        }
        if (!(enchants = ItemDetails.getAllEnchants(stack, hideFlags = tag != null ? tag.m_128451_("HideFlags") : 0)).isEmpty()) {
            data.put("enchantments", enchants);
        }
        if (!(effects = ItemDetails.getAllEffects(stack)).isEmpty()) {
            data.put("potionEffects", effects);
        }
        if (tag != null && tag.m_128471_("Unbreakable") && (hideFlags & 4) == 0) {
            data.put("unbreakable", true);
        }
        DetailHelpers.fillMapColour(data, (BlockGetter)EmptyBlockGetter.INSTANCE, BlockPos.f_121853_, Block.m_49814_((Item)stack.m_41720_()).m_49966_());
    }

    private static @Nullable Component parseTextComponent(Tag x) {
        try {
            return Component.Serializer.m_130701_((String)x.m_7916_());
        }
        catch (JsonParseException e) {
            return null;
        }
    }

    private static List<Map<String, Object>> getAllEnchants(ItemStack stack, int hideFlags) {
        ArrayList<Map<String, Object>> enchants = new ArrayList<Map<String, Object>>(0);
        if (stack.m_41720_() instanceof EnchantedBookItem && (hideFlags & 0x20) == 0) {
            ItemDetails.addEnchantments(EnchantedBookItem.m_41163_((ItemStack)stack), enchants);
        }
        if (stack.m_41793_() && (hideFlags & 1) == 0) {
            ItemDetails.addEnchantments(stack.m_41785_(), enchants);
        }
        return enchants;
    }

    private static void addEnchantments(ListTag rawEnchants, ArrayList<Map<String, Object>> enchants) {
        if (rawEnchants.isEmpty()) {
            return;
        }
        enchants.ensureCapacity(enchants.size() + rawEnchants.size());
        for (Map.Entry entry : EnchantmentHelper.m_44882_((ListTag)rawEnchants).entrySet()) {
            Enchantment enchantment = (Enchantment)entry.getKey();
            Integer level = (Integer)entry.getValue();
            HashMap<String, Object> enchant = new HashMap<String, Object>(3);
            enchant.put("name", DetailHelpers.getId(RegistryWrappers.ENCHANTMENTS, enchantment));
            enchant.put("level", level);
            enchant.put("displayName", enchantment.m_44700_(level.intValue()).getString());
            enchants.add(enchant);
        }
    }

    private static List<Map<String, Object>> getAllEffects(ItemStack stack) {
        return PotionUtils.m_43547_((ItemStack)stack).stream().map(p -> {
            HashMap<String, Object> potion = new HashMap<String, Object>(4);
            potion.put("name", DetailHelpers.getId(RegistryWrappers.MOB_EFFECTS, p.m_19544_()));
            MutableComponent displayName = Component.m_237115_((String)p.m_19576_());
            if (p.m_19564_() > 0) {
                displayName = Component.m_237110_((String)"potion.withAmplifier", (Object[])new Object[]{displayName, Component.m_237115_((String)("potion.potency." + p.m_19564_()))});
            }
            potion.put("displayName", displayName.getString());
            if (p.m_19564_() > 0) {
                potion.put("potency", p.m_19564_() + 1);
            }
            if (p.m_267577_()) {
                potion.put("duration", Double.POSITIVE_INFINITY);
            } else if (p.m_19557_() > 1) {
                potion.put("duration", (double)p.m_19557_() / 20.0 * ItemDetails.getPotionDurationMultiplier(stack));
            }
            return potion;
        }).toList();
    }

    private static double getPotionDurationMultiplier(ItemStack stack) {
        if (stack.m_41720_() instanceof LingeringPotionItem) {
            return 0.25;
        }
        if (stack.m_41720_() instanceof TippedArrowItem) {
            return 0.125;
        }
        return 1.0;
    }
}

