/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.network;

import dan200.computercraft.shared.network.MessageType;
import dan200.computercraft.shared.network.NetworkMessage;
import dan200.computercraft.shared.network.client.ChatTableClientMessage;
import dan200.computercraft.shared.network.client.ClientNetworkContext;
import dan200.computercraft.shared.network.client.ComputerTerminalClientMessage;
import dan200.computercraft.shared.network.client.MonitorClientMessage;
import dan200.computercraft.shared.network.client.PlayRecordClientMessage;
import dan200.computercraft.shared.network.client.PocketComputerDataMessage;
import dan200.computercraft.shared.network.client.PocketComputerDeletedClientMessage;
import dan200.computercraft.shared.network.client.SpeakerAudioClientMessage;
import dan200.computercraft.shared.network.client.SpeakerMoveClientMessage;
import dan200.computercraft.shared.network.client.SpeakerPlayClientMessage;
import dan200.computercraft.shared.network.client.SpeakerStopClientMessage;
import dan200.computercraft.shared.network.client.UpgradesLoadedMessage;
import dan200.computercraft.shared.network.client.UploadResultMessage;
import dan200.computercraft.shared.network.server.ComputerActionServerMessage;
import dan200.computercraft.shared.network.server.KeyEventServerMessage;
import dan200.computercraft.shared.network.server.MouseEventServerMessage;
import dan200.computercraft.shared.network.server.PasteEventComputerMessage;
import dan200.computercraft.shared.network.server.ServerNetworkContext;
import dan200.computercraft.shared.network.server.UploadFileMessage;
import dan200.computercraft.shared.platform.PlatformHelper;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public final class NetworkMessages {
    private static final IntSet seenIds = new IntOpenHashSet();
    private static final Set<String> seenChannel = new HashSet<String>();
    private static final List<MessageType<? extends NetworkMessage<ServerNetworkContext>>> serverMessages = new ArrayList<MessageType<? extends NetworkMessage<ServerNetworkContext>>>();
    private static final List<MessageType<? extends NetworkMessage<ClientNetworkContext>>> clientMessages = new ArrayList<MessageType<? extends NetworkMessage<ClientNetworkContext>>>();
    public static final MessageType<ComputerActionServerMessage> COMPUTER_ACTION = NetworkMessages.registerServerbound(0, "computer_action", ComputerActionServerMessage.class, ComputerActionServerMessage::new);
    public static final MessageType<KeyEventServerMessage> KEY_EVENT = NetworkMessages.registerServerbound(1, "key_event", KeyEventServerMessage.class, KeyEventServerMessage::new);
    public static final MessageType<MouseEventServerMessage> MOUSE_EVENT = NetworkMessages.registerServerbound(2, "mouse_event", MouseEventServerMessage.class, MouseEventServerMessage::new);
    public static final MessageType<PasteEventComputerMessage> PASTE_EVENT = NetworkMessages.registerServerbound(3, "paste_event", PasteEventComputerMessage.class, PasteEventComputerMessage::new);
    public static final MessageType<UploadFileMessage> UPLOAD_FILE = NetworkMessages.registerServerbound(4, "upload_file", UploadFileMessage.class, UploadFileMessage::new);
    public static final MessageType<ChatTableClientMessage> CHAT_TABLE = NetworkMessages.registerClientbound(10, "chat_table", ChatTableClientMessage.class, ChatTableClientMessage::new);
    public static final MessageType<PocketComputerDataMessage> POCKET_COMPUTER_DATA = NetworkMessages.registerClientbound(11, "pocket_computer_data", PocketComputerDataMessage.class, PocketComputerDataMessage::new);
    public static final MessageType<PocketComputerDeletedClientMessage> POCKET_COMPUTER_DELETED = NetworkMessages.registerClientbound(12, "pocket_computer_deleted", PocketComputerDeletedClientMessage.class, PocketComputerDeletedClientMessage::new);
    public static final MessageType<ComputerTerminalClientMessage> COMPUTER_TERMINAL = NetworkMessages.registerClientbound(13, "computer_terminal", ComputerTerminalClientMessage.class, ComputerTerminalClientMessage::new);
    public static final MessageType<PlayRecordClientMessage> PLAY_RECORD = NetworkMessages.registerClientbound(14, "play_record", PlayRecordClientMessage.class, PlayRecordClientMessage::new);
    public static final MessageType<MonitorClientMessage> MONITOR_CLIENT = NetworkMessages.registerClientbound(15, "monitor_client", MonitorClientMessage.class, MonitorClientMessage::new);
    public static final MessageType<SpeakerAudioClientMessage> SPEAKER_AUDIO = NetworkMessages.registerClientbound(16, "speaker_audio", SpeakerAudioClientMessage.class, SpeakerAudioClientMessage::new);
    public static final MessageType<SpeakerMoveClientMessage> SPEAKER_MOVE = NetworkMessages.registerClientbound(17, "speaker_move", SpeakerMoveClientMessage.class, SpeakerMoveClientMessage::new);
    public static final MessageType<SpeakerPlayClientMessage> SPEAKER_PLAY = NetworkMessages.registerClientbound(18, "speaker_play", SpeakerPlayClientMessage.class, SpeakerPlayClientMessage::new);
    public static final MessageType<SpeakerStopClientMessage> SPEAKER_STOP = NetworkMessages.registerClientbound(19, "speaker_stop", SpeakerStopClientMessage.class, SpeakerStopClientMessage::new);
    public static final MessageType<UploadResultMessage> UPLOAD_RESULT = NetworkMessages.registerClientbound(20, "upload_result", UploadResultMessage.class, UploadResultMessage::new);
    public static final MessageType<UpgradesLoadedMessage> UPGRADES_LOADED = NetworkMessages.registerClientbound(21, "upgrades_loaded", UpgradesLoadedMessage.class, UpgradesLoadedMessage::new);

    private NetworkMessages() {
    }

    private static <C, T extends NetworkMessage<C>> MessageType<T> register(List<MessageType<? extends NetworkMessage<C>>> messages, int id, String channel, Class<T> klass, FriendlyByteBuf.Reader<T> reader) {
        if (!seenIds.add(id)) {
            throw new IllegalArgumentException("Duplicate id " + id);
        }
        if (!seenChannel.add(channel)) {
            throw new IllegalArgumentException("Duplicate channel " + channel);
        }
        MessageType<T> type = PlatformHelper.get().createMessageType(id, new ResourceLocation("computercraft", channel), klass, reader);
        messages.add(type);
        return type;
    }

    private static <T extends NetworkMessage<ServerNetworkContext>> MessageType<T> registerServerbound(int id, String channel, Class<T> klass, FriendlyByteBuf.Reader<T> reader) {
        return NetworkMessages.register(serverMessages, id, channel, klass, reader);
    }

    private static <T extends NetworkMessage<ClientNetworkContext>> MessageType<T> registerClientbound(int id, String channel, Class<T> klass, FriendlyByteBuf.Reader<T> reader) {
        return NetworkMessages.register(clientMessages, id, channel, klass, reader);
    }

    public static Collection<MessageType<? extends NetworkMessage<ServerNetworkContext>>> getServerbound() {
        return Collections.unmodifiableCollection(serverMessages);
    }

    public static Collection<MessageType<? extends NetworkMessage<ClientNetworkContext>>> getClientbound() {
        return Collections.unmodifiableCollection(clientMessages);
    }
}

