/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.network.server;

import dan200.computercraft.shared.computer.menu.ComputerMenu;
import dan200.computercraft.shared.network.MessageType;
import dan200.computercraft.shared.network.NetworkMessages;
import dan200.computercraft.shared.network.server.ComputerServerMessage;
import dan200.computercraft.shared.network.server.ServerNetworkContext;
import io.netty.handler.codec.DecoderException;
import java.nio.ByteBuffer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class PasteEventComputerMessage
extends ComputerServerMessage {
    private final ByteBuffer text;

    public PasteEventComputerMessage(AbstractContainerMenu menu, ByteBuffer text) {
        super(menu);
        this.text = text;
    }

    public PasteEventComputerMessage(FriendlyByteBuf buf) {
        super(buf);
        int length = buf.m_130242_();
        if (length > 512) {
            throw new DecoderException("ByteArray with size " + length + " is bigger than allowed 512");
        }
        byte[] text = new byte[length];
        buf.readBytes(text);
        this.text = ByteBuffer.wrap(text);
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        super.write(buf);
        buf.m_130130_(this.text.remaining());
        buf.writeBytes(this.text.duplicate());
    }

    @Override
    protected void handle(ServerNetworkContext context, ComputerMenu container) {
        container.getInput().getComputerInput().paste(this.text);
    }

    @Override
    public MessageType<PasteEventComputerMessage> type() {
        return NetworkMessages.PASTE_EVENT;
    }
}

