/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import team.lodestar.lodestone.capability.LodestoneWorldDataCapability;
import team.lodestar.lodestone.command.arguments.WorldEventInstanceArgument;
import team.lodestar.lodestone.command.arguments.WorldEventTypeArgument;
import team.lodestar.lodestone.systems.worldevent.WorldEventInstance;
import team.lodestar.lodestone.systems.worldevent.WorldEventType;

public class FreezeActiveWorldEventsCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"freeze").requires(cs -> cs.m_6761_(2))).then(Commands.m_82127_((String)"all").executes(ctx -> {
            LodestoneWorldDataCapability.getCapabilityOptional((Level)((CommandSourceStack)ctx.getSource()).m_81372_()).ifPresent(c -> {
                ArrayList<WorldEventInstance> activeWorldEvents = c.activeWorldEvents;
                List<WorldEventInstance> notCurrentlyFrozen = activeWorldEvents.stream().filter(event -> !event.isFrozen()).toList();
                if (notCurrentlyFrozen.isEmpty()) {
                    ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237115_((String)"command.lodestone.worldevent.freeze.all.fail").m_130940_(ChatFormatting.RED));
                } else {
                    notCurrentlyFrozen.forEach(instance -> {
                        instance.frozen = true;
                    });
                    notCurrentlyFrozen.forEach(WorldEventInstance::setDirty);
                    ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"command.lodestone.worldevent.freeze.all.success", (Object[])new Object[]{notCurrentlyFrozen.size()}).m_130940_(ChatFormatting.AQUA), true);
                }
            });
            return 1;
        }))).then(Commands.m_82127_((String)"single").then(Commands.m_82129_((String)"target", (ArgumentType)WorldEventInstanceArgument.worldEventInstance()).executes(ctx -> {
            WorldEventInstance event = WorldEventInstanceArgument.getEventInstance(ctx, "target");
            if (event.isFrozen()) {
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237115_((String)"command.lodestone.worldevent.freeze.target.fail").m_130940_(ChatFormatting.RED));
            } else {
                event.frozen = true;
                event.setDirty();
                ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"command.lodestone.worldevent.freeze.target.success", (Object[])new Object[]{event.type.id.toString()}).m_130940_(ChatFormatting.AQUA), true);
            }
            return 1;
        })))).then(Commands.m_82127_((String)"type").then(Commands.m_82129_((String)"type", (ArgumentType)WorldEventTypeArgument.worldEventType()).executes(ctx -> {
            WorldEventType type = WorldEventTypeArgument.getEventType(ctx, "type");
            LodestoneWorldDataCapability.getCapabilityOptional((Level)((CommandSourceStack)ctx.getSource()).m_81372_()).ifPresent(c -> {
                List<WorldEventInstance> activeWorldEvents = c.activeWorldEvents.stream().filter(instance -> instance.type == type).toList();
                List<WorldEventInstance> notCurrentlyFrozen = activeWorldEvents.stream().filter(event -> !event.isFrozen()).toList();
                if (notCurrentlyFrozen.isEmpty()) {
                    ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237110_((String)"command.lodestone.worldevent.freeze.type.fail", (Object[])new Object[]{type.id.toString()}).m_130940_(ChatFormatting.RED));
                } else {
                    notCurrentlyFrozen.forEach(instance -> {
                        instance.frozen = true;
                    });
                    notCurrentlyFrozen.forEach(WorldEventInstance::setDirty);
                    ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237110_((String)"command.lodestone.worldevent.freeze.type.success", (Object[])new Object[]{notCurrentlyFrozen.size(), type.id.toString()}).m_130940_(ChatFormatting.AQUA), true);
                }
            });
            return 1;
        })));
    }
}

