/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless;

import com.google.auto.service.AutoService;
import dev.huskuraft.effortless.EffortlessConfigStorage;
import dev.huskuraft.effortless.EffortlessNetworkChannel;
import dev.huskuraft.effortless.EffortlessServerManager;
import dev.huskuraft.effortless.EffortlessSessionManager;
import dev.huskuraft.effortless.EffortlessStructureBuilder;
import dev.huskuraft.effortless.api.events.impl.EventRegistry;
import dev.huskuraft.effortless.api.platform.Entrance;
import dev.huskuraft.effortless.api.platform.PlatformLoader;
import dev.huskuraft.effortless.api.text.ChatFormatting;
import dev.huskuraft.effortless.api.text.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={Entrance.class})
public class Effortless
implements Entrance {
    public static final String MOD_ID = "effortless";
    public static final String DEFAULT_CHANNEL = "default";
    public static final int PROTOCOL_VERSION = 13;
    public static final Logger LOGGER = LoggerFactory.getLogger((String)Effortless.class.getName());
    private final EventRegistry eventRegistry = PlatformLoader.getSingleton(EventRegistry.class);
    private final EffortlessNetworkChannel networkChannel = new EffortlessNetworkChannel(this);
    private final EffortlessStructureBuilder structureBuilder = new EffortlessStructureBuilder(this);
    private final EffortlessConfigStorage sessionConfigStorage = new EffortlessConfigStorage(this);
    private final EffortlessSessionManager sessionManager = new EffortlessSessionManager(this);
    private final EffortlessServerManager serverManager = new EffortlessServerManager(this);

    public static Effortless getInstance() {
        return (Effortless)Entrance.getInstance();
    }

    public static Text getSystemMessage(Text msg) {
        return Text.text("[").append(Text.translate("effortless.symbol")).append("] ").withStyle(ChatFormatting.GRAY).append(msg.withStyle(ChatFormatting.WHITE));
    }

    public static Text getMessage(Text msg) {
        return msg;
    }

    @Override
    public EventRegistry getEventRegistry() {
        return this.eventRegistry;
    }

    public EffortlessNetworkChannel getChannel() {
        return this.networkChannel;
    }

    public EffortlessStructureBuilder getStructureBuilder() {
        return this.structureBuilder;
    }

    public EffortlessConfigStorage getSessionConfigStorage() {
        return this.sessionConfigStorage;
    }

    public EffortlessSessionManager getSessionManager() {
        return this.sessionManager;
    }

    @Override
    public EffortlessServerManager getServerManager() {
        return this.serverManager;
    }

    @Override
    public String getId() {
        return MOD_ID;
    }
}

