/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless;

import dev.huskuraft.effortless.Effortless;
import dev.huskuraft.effortless.api.core.Player;
import dev.huskuraft.effortless.api.core.World;
import dev.huskuraft.effortless.api.platform.Server;
import dev.huskuraft.effortless.api.text.ChatFormatting;
import dev.huskuraft.effortless.api.text.Text;
import dev.huskuraft.effortless.building.BuildResult;
import dev.huskuraft.effortless.building.BuildState;
import dev.huskuraft.effortless.building.Context;
import dev.huskuraft.effortless.building.StructureBuilder;
import dev.huskuraft.effortless.building.clipboard.Clipboard;
import dev.huskuraft.effortless.building.history.OperationResultStack;
import dev.huskuraft.effortless.building.operation.OperationResult;
import dev.huskuraft.effortless.building.operation.batch.BatchOperationResult;
import dev.huskuraft.effortless.building.pattern.Pattern;
import dev.huskuraft.effortless.building.replace.Replace;
import dev.huskuraft.effortless.building.session.BatchBuildSession;
import dev.huskuraft.effortless.building.structure.builder.Structure;
import dev.huskuraft.effortless.networking.packets.player.PlayerBuildPacket;
import dev.huskuraft.effortless.networking.packets.player.PlayerBuildTooltipPacket;
import dev.huskuraft.effortless.session.config.ConstraintConfig;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.UnaryOperator;

public final class EffortlessStructureBuilder
extends StructureBuilder {
    private final Effortless entrance;
    private final Map<UUID, Context> contexts = new HashMap<UUID, Context>();
    private final Map<UUID, OperationResultStack> undoRedoStacks = new HashMap<UUID, OperationResultStack>();

    public EffortlessStructureBuilder(Effortless entrance) {
        this.entrance = entrance;
        this.getEntrance().getEventRegistry().getPlayerChangeWorldEvent().register(this::onPlayerChangeWorld);
        this.getEntrance().getEventRegistry().getPlayerRespawnEvent().register(this::onPlayerRespawn);
        this.getEntrance().getEventRegistry().getPlayerLoggedInEvent().register(this::onPlayerLoggedIn);
        this.getEntrance().getEventRegistry().getPlayerLoggedOutEvent().register(this::onPlayerLoggedOut);
        this.getEntrance().getEventRegistry().getServerStartedEvent().register(this::onServerStarted);
        this.getEntrance().getEventRegistry().getServerStoppedEvent().register(this::onServerStopped);
    }

    public Effortless getEntrance() {
        return this.entrance;
    }

    @Override
    public BuildResult updateContext(Player player, UnaryOperator<Context> updater) {
        return null;
    }

    @Override
    public Context getDefaultContext(Player player) {
        return null;
    }

    @Override
    public Context getContext(Player player) {
        return null;
    }

    @Override
    public Context getContextTraced(Player player) {
        return null;
    }

    @Override
    public Map<UUID, Context> getAllContexts() {
        return Map.of();
    }

    public void onTick() {
    }

    @Override
    public boolean setContext(Player player, Context context) {
        return false;
    }

    @Override
    public boolean setStructure(Player player, Structure structure) {
        return false;
    }

    @Override
    public boolean setClipboard(Player player, Clipboard clipboard) {
        return false;
    }

    @Override
    public boolean setPattern(Player player, Pattern pattern) {
        return false;
    }

    @Override
    public boolean setReplace(Player player, Replace replace) {
        return false;
    }

    @Override
    public void resetAll() {
        this.contexts.clear();
        this.undoRedoStacks.clear();
    }

    @Override
    public void onContextReceived(Player player, Context context) {
        if (!this.checkPermission(player, context)) {
            if (context.isBuildType()) {
                player.sendMessage(Effortless.getSystemMessage(Text.text("Your session config is outdated. Please try to rejoin the server!")));
                Effortless.LOGGER.warn("%s has an outdated session config".formatted(player.getProfile().getName()));
            }
            return;
        }
        Server server = player.getServer();
        if (context.isBuildClientType()) {
            Effortless.LOGGER.debug("Received BUILD_CLIENT request from %s".formatted(player.getProfile().getName()));
            return;
        }
        if (context.isBuildType()) {
            Effortless.LOGGER.debug("Received BUILD request from %s".formatted(player.getProfile().getName()));
            BatchOperationResult result = new BatchBuildSession(this.getEntrance(), player, context).commit();
            this.getOperationResultStack(player).push(result);
            this.getEntrance().getChannel().sendPacket(PlayerBuildTooltipPacket.build(result), player);
            return;
        }
        for (Player otherPlayer : server.getPlayerList().getPlayers()) {
            if (otherPlayer.getId().equals(player.getId()) || otherPlayer.getPosition().distance(player.getPosition()) > 128.0) continue;
            Effortless.LOGGER.debug("Received PREVIEW request from %s".formatted(player.getProfile().getName()));
            this.getEntrance().getChannel().sendPacket(PlayerBuildPacket.by(player, context), otherPlayer);
        }
    }

    @Override
    public OperationResultStack getOperationResultStack(Player player) {
        return this.undoRedoStacks.computeIfAbsent(player.getId(), uuid -> new OperationResultStack());
    }

    @Override
    public void undo(Player player) {
        Effortless.LOGGER.debug("Received undo request from %s".formatted(player.getProfile().getName()));
        OperationResultStack stack = this.getOperationResultStack(player);
        try {
            OperationResult result = stack.undo();
            Context context = result.getOperation().getContext();
            this.getEntrance().getChannel().sendPacket(PlayerBuildTooltipPacket.undo(result), player);
            Text countText = Text.text("[").append(String.valueOf(stack.undoSize())).append("/").append(String.valueOf(stack.redoSize())).append("]").withStyle(ChatFormatting.WHITE);
            Text text = Text.text("[").append(context.buildState().getDisplayName(context.buildMode())).append("]");
            ChatFormatting[] chatFormattingArray = new ChatFormatting[1];
            chatFormattingArray[0] = switch (context.buildState()) {
                default -> throw new IncompatibleClassChangeError();
                case BuildState.IDLE -> ChatFormatting.RESET;
                case BuildState.BREAK_BLOCK -> ChatFormatting.RED;
                case BuildState.PLACE_BLOCK -> ChatFormatting.WHITE;
                case BuildState.INTERACT_BLOCK -> ChatFormatting.YELLOW;
                case BuildState.COPY_STRUCTURE -> ChatFormatting.GREEN;
                case BuildState.PASTE_STRUCTURE -> ChatFormatting.WHITE;
            };
            Text buildStateText = text.withStyle(chatFormattingArray).withStyle(ChatFormatting.GOLD);
            Text affectedText = Text.text("[").append(String.valueOf(result.getAffectedBlockCount())).append("]").withStyle(ChatFormatting.AQUA);
            player.sendMessage(Effortless.getMessage(countText.append(" ").append(Text.translate("effortless.message.history.server.undo", buildStateText, affectedText))));
        }
        catch (EmptyStackException e) {
            this.getEntrance().getChannel().sendPacket(PlayerBuildTooltipPacket.nothingToUndo(), player);
            Text countText = Text.text("[").append(String.valueOf(stack.undoSize())).append("/").append(String.valueOf(stack.redoSize())).append("]").withStyle(ChatFormatting.WHITE);
            player.sendMessage(Effortless.getMessage(countText.append(" ").append(Text.translate("effortless.history.nothing_to_undo"))));
        }
    }

    @Override
    public void redo(Player player) {
        Effortless.LOGGER.debug("Received redo request from %s".formatted(player.getProfile().getName()));
        OperationResultStack stack = this.getOperationResultStack(player);
        try {
            OperationResult result = stack.redo();
            Context context = result.getOperation().getContext();
            this.getEntrance().getChannel().sendPacket(PlayerBuildTooltipPacket.undo(result), player);
            Text countText = Text.text("[").append(String.valueOf(stack.undoSize())).append("/").append(String.valueOf(stack.redoSize())).append("]").withStyle(ChatFormatting.WHITE);
            Text text = Text.text("[").append(context.buildState().getDisplayName(context.buildMode())).append("]");
            ChatFormatting[] chatFormattingArray = new ChatFormatting[1];
            chatFormattingArray[0] = switch (context.buildState()) {
                default -> throw new IncompatibleClassChangeError();
                case BuildState.IDLE -> ChatFormatting.RESET;
                case BuildState.BREAK_BLOCK -> ChatFormatting.RED;
                case BuildState.PLACE_BLOCK -> ChatFormatting.WHITE;
                case BuildState.INTERACT_BLOCK -> ChatFormatting.YELLOW;
                case BuildState.COPY_STRUCTURE -> ChatFormatting.GREEN;
                case BuildState.PASTE_STRUCTURE -> ChatFormatting.WHITE;
            };
            Text buildStateText = text.withStyle(chatFormattingArray).withStyle(ChatFormatting.GOLD);
            Text affectedText = Text.text("[").append(String.valueOf(result.getAffectedBlockCount())).append("]").withStyle(ChatFormatting.AQUA);
            player.sendMessage(Effortless.getMessage(countText.append(" ").append(Text.translate("effortless.message.history.server.redo", buildStateText, affectedText))));
        }
        catch (EmptyStackException e) {
            this.getEntrance().getChannel().sendPacket(PlayerBuildTooltipPacket.nothingToRedo(), player);
            Text countText = Text.text("[").append(String.valueOf(stack.undoSize())).append("/").append(String.valueOf(stack.redoSize())).append("]").withStyle(ChatFormatting.WHITE);
            player.sendMessage(Effortless.getMessage(countText.append(" ").append(Text.translate("effortless.history.nothing_to_redo"))));
        }
    }

    private void onPlayerChangeWorld(Player player, World origin, World destination) {
    }

    private void onPlayerRespawn(Player oldPlayer, Player newPlayer, boolean alive) {
    }

    private void onPlayerLoggedIn(Player player) {
    }

    private void onPlayerLoggedOut(Player player) {
    }

    private void onServerStarted(Server server) {
        this.resetAll();
    }

    private void onServerStopped(Server server) {
        this.resetAll();
    }

    private boolean checkPermission(Player player, Context context) {
        ConstraintConfig config = this.getEntrance().getSessionManager().getLastSessionConfig().getByPlayer(player);
        return Objects.equals(context.configs().constraintConfig(), config);
    }
}

