/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.building.pattern.array;

import dev.huskuraft.effortless.api.math.BoundingBox3i;
import dev.huskuraft.effortless.api.math.Range1i;
import dev.huskuraft.effortless.api.math.Vector3i;
import dev.huskuraft.effortless.api.text.Text;
import dev.huskuraft.effortless.building.operation.Operation;
import dev.huskuraft.effortless.building.operation.batch.DeferredBatchOperation;
import dev.huskuraft.effortless.building.pattern.MoveContext;
import dev.huskuraft.effortless.building.pattern.Transformer;
import dev.huskuraft.effortless.building.pattern.Transformers;
import java.util.List;
import java.util.UUID;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public record ArrayTransformer(UUID id, Text name, Vector3i offset, int count) implements Transformer
{
    public static final ArrayTransformer ZERO = new ArrayTransformer(new Vector3i(0, 0, 0), 0);
    public static final ArrayTransformer DEFAULT = new ArrayTransformer(new Vector3i(1, 1, 1), 4);
    public static final BoundingBox3i OFFSET_BOUND = BoundingBox3i.of(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    public static final Range1i COUNT_RANGE = new Range1i(1, Short.MAX_VALUE);

    public ArrayTransformer(Vector3i offset, int count) {
        this(UUID.randomUUID(), Text.empty(), offset, count);
    }

    @Override
    public Operation transform(Operation operation) {
        return new DeferredBatchOperation(operation.getContext(), () -> IntStream.range(0, this.count).mapToObj(i -> (Operation)operation.move(MoveContext.relative(this.offset.mul(i)))));
    }

    @Override
    public Text getName() {
        if (!this.name().getString().isEmpty()) {
            return this.name();
        }
        return Text.translate("effortless.transformer.array.no_name");
    }

    @Override
    public Transformers getType() {
        return Transformers.ARRAY;
    }

    @Override
    public Stream<Text> getSearchableTags() {
        return Stream.of(this.getName(), Text.text(this.offset().toString()), Text.text(String.valueOf(this.count)));
    }

    @Override
    public boolean isValid() {
        return OFFSET_BOUND.contains(this.offset) && COUNT_RANGE.contains(this.count);
    }

    @Override
    public ArrayTransformer withName(Text name) {
        return new ArrayTransformer(this.id, name, this.offset, this.count);
    }

    @Override
    public ArrayTransformer withId(UUID id) {
        return new ArrayTransformer(id, this.name, this.offset, this.count);
    }

    public Integer copyCount() {
        return Math.max(0, this.count - 1);
    }

    public ArrayTransformer withOffset(Vector3i offset) {
        return new ArrayTransformer(this.id, this.name, offset, this.count);
    }

    public ArrayTransformer withOffsetX(int x) {
        return new ArrayTransformer(this.id, this.name, this.offset.withX(x), this.count);
    }

    public ArrayTransformer withOffsetY(int y) {
        return new ArrayTransformer(this.id, this.name, this.offset.withY(y), this.count);
    }

    public ArrayTransformer withOffsetZ(int z) {
        return new ArrayTransformer(this.id, this.name, this.offset.withZ(z), this.count);
    }

    public ArrayTransformer withCount(int count) {
        return new ArrayTransformer(this.id, this.name, this.offset, count);
    }

    @Override
    public float volumeMultiplier() {
        return this.count;
    }

    @Override
    public List<Text> getDescriptions() {
        return List.of(Text.text("Offset " + this.offset.x() + " " + this.offset.y() + " " + this.offset.z()), Text.text("Count " + this.count));
    }
}

