/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.building.structure;

import dev.huskuraft.effortless.building.structure.BuildFeature;
import dev.huskuraft.effortless.building.structure.CircleStart;
import dev.huskuraft.effortless.building.structure.CubeFilling;
import dev.huskuraft.effortless.building.structure.CubeLength;
import dev.huskuraft.effortless.building.structure.LineDirection;
import dev.huskuraft.effortless.building.structure.PlaneFacing;
import dev.huskuraft.effortless.building.structure.PlaneFilling;
import dev.huskuraft.effortless.building.structure.PlaneLength;
import dev.huskuraft.effortless.building.structure.RaisedEdge;
import java.util.Arrays;

public enum BuildFeatures {
    CIRCLE_START("circle_start", CircleStart.values()),
    CUBE_FILLING("cube_filling", CubeFilling.values()),
    CUBE_LENGTH("cube_length", CubeLength.values()),
    PLANE_FACING("plane_facing", PlaneFacing.values()),
    PLANE_FILLING("plane_filling", PlaneFilling.values()),
    PLANE_LENGTH("plane_length", PlaneLength.values()),
    LINE_DIRECTION("line_direction", LineDirection.values()),
    RAISED_EDGE("raised_edge", RaisedEdge.values());

    private final String name;
    private final BuildFeature[] entries;

    private BuildFeatures(String name, BuildFeature ... defaultEntries) {
        this.name = name;
        this.entries = defaultEntries;
    }

    public String getName() {
        return this.name;
    }

    public BuildFeature[] getEntries() {
        return this.entries;
    }

    public BuildFeature getDefaultFeature() {
        return this.entries[0];
    }

    public boolean isSupported(BuildFeature feature) {
        return Arrays.stream(this.entries).toList().contains(feature);
    }
}

