/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.building.structure.builder;

import com.google.common.collect.Sets;
import dev.huskuraft.effortless.api.core.Axis;
import dev.huskuraft.effortless.api.core.BlockInteraction;
import dev.huskuraft.effortless.api.core.BlockPosition;
import dev.huskuraft.effortless.api.core.Direction;
import dev.huskuraft.effortless.api.core.Player;
import dev.huskuraft.effortless.api.math.MathUtils;
import dev.huskuraft.effortless.api.math.Vector3d;
import dev.huskuraft.effortless.building.Context;
import dev.huskuraft.effortless.building.structure.builder.Structure;
import dev.huskuraft.effortless.building.structure.builder.TraceShape;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Stream;

public interface BlockStructure
extends Structure {
    public static final double LOOK_VEC_TOLERANCE = 0.01;

    @Override
    default public int volume(Context context) {
        return context.getInteractionBox().volume();
    }

    public static TraceShape getShape(int x1, int y1, int z1, int x2, int y2, int z2) {
        return TraceShape.fromPosition(x1, y1, z1, x2, y2, z2);
    }

    public static TraceShape getShape(BlockPosition pos1, BlockPosition pos2) {
        return TraceShape.fromPosition(pos1.x(), pos1.y(), pos1.z(), pos2.x(), pos2.y(), pos2.z());
    }

    public static double lengthSq(double x, double y, double z) {
        return x * x + y * y + z * z;
    }

    public static double lengthSq(double x, double z) {
        return x * x + z * z;
    }

    public static Set<BlockPosition> getBallooned(Set<BlockPosition> set, double radius) {
        LinkedHashSet result = Sets.newLinkedHashSet();
        int ceilRadius = (int)Math.ceil(radius);
        double radiusSquare = Math.pow(radius, 2.0);
        for (BlockPosition v : set) {
            int tipx = v.x();
            int tipy = v.y();
            int tipz = v.z();
            for (int loopx = tipx - ceilRadius; loopx <= tipx + ceilRadius; ++loopx) {
                for (int loopy = tipy - ceilRadius; loopy <= tipy + ceilRadius; ++loopy) {
                    for (int loopz = tipz - ceilRadius; loopz <= tipz + ceilRadius; ++loopz) {
                        if (!(BlockStructure.lengthSq(loopx - tipx, loopy - tipy, loopz - tipz) <= radiusSquare)) continue;
                        result.add(BlockPosition.at(loopx, loopy, loopz));
                    }
                }
            }
        }
        return result;
    }

    public static Set<BlockPosition> getHollowed(Set<BlockPosition> set) {
        LinkedHashSet<BlockPosition> result = new LinkedHashSet<BlockPosition>();
        for (BlockPosition v : set) {
            int z;
            int y;
            int x = v.x();
            if (set.contains(BlockPosition.at(x + 1, y = v.y(), z = v.z())) && set.contains(BlockPosition.at(x - 1, y, z)) && set.contains(BlockPosition.at(x, y + 1, z)) && set.contains(BlockPosition.at(x, y - 1, z)) && set.contains(BlockPosition.at(x, y, z + 1)) && set.contains(BlockPosition.at(x, y, z - 1))) continue;
            result.add(v);
        }
        return result;
    }

    public static int axisSign(int value) {
        return MathUtils.sign(value) == 0.0f ? 1 : (int)MathUtils.sign(value);
    }

    public static BlockInteraction transformUniformLengthInteraction(BlockInteraction start, BlockInteraction end, boolean limit) {
        if (start == null || end == null) {
            return null;
        }
        if (!limit) {
            return end;
        }
        BlockPosition p0 = start.getBlockPosition();
        BlockPosition p1 = end.getBlockPosition();
        BlockPosition diff = p1.sub(p0);
        if (diff.x() == 0 && diff.y() == 0 && diff.z() == 0) {
            return end;
        }
        if (diff.x() == 0 && diff.y() == 0 || diff.x() == 0 && diff.z() == 0 || diff.y() == 0 && diff.z() == 0) {
            return end;
        }
        if (diff.x() == 0) {
            return end.withBlockPosition(p0.add(diff.withY(BlockStructure.axisSign(diff.y()) * MathUtils.max(MathUtils.abs(diff.y()), MathUtils.abs(diff.z()))).withZ(BlockStructure.axisSign(diff.z()) * MathUtils.max(MathUtils.abs(diff.y()), MathUtils.abs(diff.z())))));
        }
        if (diff.z() == 0) {
            return end.withBlockPosition(p0.add(diff.withX(BlockStructure.axisSign(diff.x()) * MathUtils.max(MathUtils.abs(diff.x()), MathUtils.abs(diff.y()))).withY(BlockStructure.axisSign(diff.y()) * MathUtils.max(MathUtils.abs(diff.x()), MathUtils.abs(diff.y())))));
        }
        if (diff.y() == 0) {
            return end.withBlockPosition(p0.add(diff.withX(BlockStructure.axisSign(diff.x()) * MathUtils.max(MathUtils.abs(diff.x()), MathUtils.abs(diff.z()))).withZ(BlockStructure.axisSign(diff.z()) * MathUtils.max(MathUtils.abs(diff.x()), MathUtils.abs(diff.z())))));
        }
        return end;
    }

    public static Vector3d getEntityLookAngleGap(Player player) {
        Vector3d look = player.getEyeDirection();
        double x = look.x();
        double y = look.y();
        double z = look.z();
        if (MathUtils.abs(x) < 0.01) {
            x = 0.01;
        }
        if (MathUtils.abs(x - 1.0) < 0.01) {
            x = 0.99;
        }
        if (MathUtils.abs(x + 1.0) < 0.01) {
            x = -0.99;
        }
        if (MathUtils.abs(y) < 0.01) {
            y = 0.01;
        }
        if (MathUtils.abs(y - 1.0) < 0.01) {
            y = 0.99;
        }
        if (MathUtils.abs(y + 1.0) < 0.01) {
            y = -0.99;
        }
        if (MathUtils.abs(z) < 0.01) {
            z = 0.01;
        }
        if (MathUtils.abs(z - 1.0) < 0.01) {
            z = 0.99;
        }
        if (MathUtils.abs(z + 1.0) < 0.01) {
            z = -0.99;
        }
        return new Vector3d(x, y, z).normalize();
    }

    public BlockInteraction trace(Player var1, Context var2, int var3);

    public Stream<BlockPosition> collect(Context var1, int var2);

    @Override
    default public BlockInteraction trace(Player player, Context context) {
        int interactionsSize = context.interactionsSize();
        if (interactionsSize >= this.traceSize(context)) {
            return null;
        }
        return this.trace(player, context, interactionsSize);
    }

    @Override
    default public Stream<BlockPosition> collect(Context context) {
        int interactionsSize = context.interactionsSize();
        if (interactionsSize > this.traceSize(context)) {
            return null;
        }
        return this.collect(context, interactionsSize);
    }

    public static class NearestLineCriteria
    extends AxisCriteria {
        public NearestLineCriteria(Axis axis, Player player, Vector3d center, int reach, boolean skipRaytrace) {
            super(axis, player, center, reach, skipRaytrace);
        }

        @Override
        public Vector3d lineVec() {
            Vector3d pos = this.center;
            Vector3d bound = this.planeVec();
            Vector3d size = bound.sub(pos);
            double longest = MathUtils.max((size = Vector3d.at(MathUtils.abs(size.x()), MathUtils.abs(size.y()), MathUtils.abs(size.z()))).x(), MathUtils.max(size.y(), size.z()));
            if (longest == size.x()) {
                return new Vector3d(bound.x(), pos.y(), pos.z());
            }
            if (longest == size.y()) {
                return new Vector3d(pos.x(), bound.y(), pos.z());
            }
            if (longest == size.z()) {
                return new Vector3d(pos.x(), pos.y(), bound.z());
            }
            return pos;
        }

        @Override
        public double distanceToLineSqr() {
            return this.planeVec().sub(this.lineVec()).lengthSq();
        }

        @Override
        protected int getDistToPlayerSqThreshold() {
            return switch (this.getAxis()) {
                default -> throw new IncompatibleClassChangeError();
                case Axis.X, Axis.Z -> 2;
                case Axis.Y -> 0;
            };
        }
    }

    public static class NearestAxisLineCriteria
    extends NearestLineCriteria {
        private final Set<Axis> axes;

        public NearestAxisLineCriteria(Set<Axis> axes, Axis axis, Player player, Vector3d center, int reach, boolean skipRaytrace) {
            super(axis, player, center, reach, skipRaytrace);
            this.axes = axes;
        }

        @Override
        public Vector3d lineVec() {
            Vector3d pos = this.center;
            Vector3d bound = this.planeVec();
            Vector3d size = bound.sub(pos);
            size = Vector3d.at(MathUtils.abs(size.x()), MathUtils.abs(size.y()), MathUtils.abs(size.z()));
            if (this.axes.isEmpty()) {
                return pos;
            }
            double longest = MathUtils.max(this.axes.contains((Object)Axis.X) ? size.x() : Double.MIN_VALUE, MathUtils.max(this.axes.contains((Object)Axis.Y) ? size.y() : Double.MIN_VALUE, this.axes.contains((Object)Axis.Z) ? size.z() : Double.MIN_VALUE));
            if (longest == size.x() && this.axes.contains((Object)Axis.X)) {
                return new Vector3d(bound.x(), pos.y(), pos.z());
            }
            if (longest == size.y() && this.axes.contains((Object)Axis.Y)) {
                return new Vector3d(pos.x(), bound.y(), pos.z());
            }
            if (longest == size.z() && this.axes.contains((Object)Axis.Z)) {
                return new Vector3d(pos.x(), pos.y(), bound.z());
            }
            return pos;
        }
    }

    @Deprecated
    public static class AxisLineCriteria
    extends AxisCriteria {
        public AxisLineCriteria(Axis axis, Player player, Vector3d center, int reach, boolean skipRaytrace) {
            super(axis, player, center, reach, skipRaytrace);
        }

        @Override
        public Vector3d lineVec() {
            return this.lineVec(this.axis);
        }

        public Vector3d lineVec(Axis axis) {
            BlockPosition pos = BlockPosition.at(this.center);
            BlockPosition bound = BlockPosition.at(this.planeVec());
            return switch (axis) {
                default -> throw new IncompatibleClassChangeError();
                case Axis.X -> new Vector3d(bound.x(), pos.y(), pos.z());
                case Axis.Y -> new Vector3d(pos.x(), bound.y(), pos.z());
                case Axis.Z -> new Vector3d(pos.x(), pos.y(), bound.z());
            };
        }

        public BlockInteraction traceLine(Axis axis) {
            BlockPosition found = BlockPosition.at(this.lineVec(axis));
            return this.convert(found);
        }
    }

    public static abstract class AxisCriteria
    extends Criteria {
        protected final Axis axis;

        public AxisCriteria(Axis axis, Player player, Vector3d center, int reach, boolean skipRaytrace) {
            super(player, center, reach, skipRaytrace);
            this.axis = axis;
        }

        protected static Vector3d getStartVec(Vector3d start, Vector3d eye, Vector3d look) {
            return new Vector3d(MathUtils.round(AxisCriteria.snapToGrid(start.x(), eye.x(), look.x())), MathUtils.round(AxisCriteria.snapToGrid(start.y(), eye.y(), look.y())), MathUtils.round(AxisCriteria.snapToGrid(start.z(), eye.z(), look.z())));
        }

        protected static double snapToGrid(double start, double eye, double look) {
            if (eye >= start + 0.5) {
                return start + 0.5;
            }
            if (eye <= start - 0.5) {
                return start - 0.5;
            }
            if (look > 0.0) {
                return start + 0.5;
            }
            if (look < 0.0) {
                return start - 0.5;
            }
            return start;
        }

        protected static Vector3d findBound(Vector3d start, Vector3d eye, Vector3d look, Axis axis) {
            return switch (axis) {
                default -> throw new IncompatibleClassChangeError();
                case Axis.X -> AxisCriteria.findXBound(start, eye, look);
                case Axis.Y -> AxisCriteria.findYBound(start, eye, look);
                case Axis.Z -> AxisCriteria.findZBound(start, eye, look);
            };
        }

        protected static Vector3d findXBound(Vector3d start, Vector3d eye, Vector3d look) {
            Vector3d center = AxisCriteria.getStartVec(start, eye, look);
            double y = (center.x() - eye.x()) / look.x() * look.y() + eye.y();
            double z = (center.x() - eye.x()) / look.x() * look.z() + eye.z();
            return new Vector3d(center.x(), y, z);
        }

        protected static Vector3d findYBound(Vector3d start, Vector3d eye, Vector3d look) {
            Vector3d center = AxisCriteria.getStartVec(start, eye, look);
            double x = (center.y() - eye.y()) / look.y() * look.x() + eye.x();
            double z = (center.y() - eye.y()) / look.y() * look.z() + eye.z();
            return new Vector3d(x, center.y(), z);
        }

        protected static Vector3d findZBound(Vector3d start, Vector3d eye, Vector3d look) {
            Vector3d center = AxisCriteria.getStartVec(start, eye, look);
            double x = (center.z() - eye.z()) / look.z() * look.x() + eye.x();
            double y = (center.z() - eye.z()) / look.z() * look.y() + eye.y();
            return new Vector3d(x, y, center.z());
        }

        protected boolean isCriteriaValid(Vector3d start, Vector3d look, Vector3d lineBound, Vector3d planeBound, double distToPlayerSq, int reach) {
            return planeBound.sub(start).dot(look) > 0.0 && distToPlayerSq > (double)this.getDistToPlayerSqThreshold() && distToPlayerSq < (double)(reach * reach);
        }

        protected int getDistToPlayerSqThreshold() {
            return 0;
        }

        public Axis getAxis() {
            return this.axis;
        }

        public Vector3d startVec() {
            return AxisCriteria.getStartVec(this.center, this.eye, this.look);
        }

        public Vector3d planeVec() {
            return AxisCriteria.findBound(this.center, this.eye, this.look, this.axis);
        }

        public Vector3d lineVec() {
            return this.planeVec();
        }

        public double distanceToEyeSqr() {
            return this.planeVec().sub(this.eye).lengthSq();
        }

        public double distanceToLineSqr() {
            return this.planeVec().sub(this.lineVec()).lengthSq();
        }

        @Override
        public boolean isInRange() {
            return this.isCriteriaValid(this.eye, this.look, this.lineVec(), this.planeVec(), this.distanceToEyeSqr(), this.reach);
        }

        public BlockInteraction tracePlane() {
            Vector3d offset = this.startVec().sub(this.center);
            BlockPosition found = BlockPosition.at(this.planeVec().sub(this.axis == Axis.X ? offset.x() : 0.0, this.axis == Axis.Y ? offset.y() : 0.0, this.axis == Axis.Z ? offset.z() : 0.0));
            return this.convert(found);
        }

        public BlockInteraction traceLine() {
            return this.convert(BlockPosition.at(this.lineVec()));
        }

        protected BlockInteraction convert(BlockPosition blockPosition) {
            Vector3d vec3 = this.eye.add(this.look.mul(0.001));
            return new BlockInteraction(vec3, Direction.getNearest(this.look.x(), this.look.y(), this.look.z()).getOpposite(), blockPosition, true);
        }
    }

    public static abstract class Criteria {
        protected final Vector3d center;
        protected final Vector3d eye;
        protected final Vector3d look;
        protected final int reach;
        protected final boolean skipRaytrace;

        Criteria(Player player, Vector3d center, int reach, boolean skipRaytrace) {
            this.look = BlockStructure.getEntityLookAngleGap(player);
            this.eye = player.getEyePosition();
            this.center = center;
            this.reach = reach;
            this.skipRaytrace = skipRaytrace;
        }

        public abstract boolean isInRange();
    }
}

