/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.building.structure.builder.standard;

import com.google.common.collect.Sets;
import dev.huskuraft.effortless.api.core.Axis;
import dev.huskuraft.effortless.api.core.BlockInteraction;
import dev.huskuraft.effortless.api.core.BlockPosition;
import dev.huskuraft.effortless.api.core.Player;
import dev.huskuraft.effortless.api.math.MathUtils;
import dev.huskuraft.effortless.api.math.Vector3d;
import dev.huskuraft.effortless.building.Context;
import dev.huskuraft.effortless.building.structure.BuildFeature;
import dev.huskuraft.effortless.building.structure.BuildFeatures;
import dev.huskuraft.effortless.building.structure.BuildMode;
import dev.huskuraft.effortless.building.structure.PlaneFilling;
import dev.huskuraft.effortless.building.structure.PlaneLength;
import dev.huskuraft.effortless.building.structure.builder.BlockStructure;
import dev.huskuraft.effortless.building.structure.builder.Structure;
import dev.huskuraft.effortless.building.structure.builder.standard.Line;
import dev.huskuraft.effortless.building.structure.builder.standard.Single;
import dev.huskuraft.effortless.building.structure.builder.standard.Square;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.stream.Stream;

public record Wall(PlaneFilling planeFilling, PlaneLength planeLength) implements BlockStructure
{
    public Wall() {
        this(PlaneFilling.FILLED, PlaneLength.VARIABLE);
    }

    @Override
    public Structure withFeature(BuildFeature feature) {
        return switch (feature.getType()) {
            case BuildFeatures.PLANE_FILLING -> new Wall((PlaneFilling)feature, this.planeLength);
            case BuildFeatures.PLANE_LENGTH -> new Wall(this.planeFilling, (PlaneLength)feature);
            default -> this;
        };
    }

    protected static BlockInteraction traceWall(Player player, Context context, PlaneLength planeLength) {
        return Wall.traceWall(player, context.getInteraction(0), planeLength == PlaneLength.EQUAL);
    }

    protected static BlockInteraction traceWall(Player player, BlockInteraction start, boolean uniformLength) {
        Vector3d center = start.getBlockPosition().getCenter();
        int reach = 1024;
        boolean skipRaytrace = false;
        BlockInteraction result = Stream.of(new WallCriteria(Axis.X, player, center, reach, skipRaytrace), new WallCriteria(Axis.Z, player, center, reach, skipRaytrace)).filter(BlockStructure.AxisCriteria::isInRange).min(Comparator.comparing(WallCriteria::angle)).map(BlockStructure.AxisCriteria::tracePlane).orElse(null);
        return BlockStructure.transformUniformLengthInteraction(start, result, uniformLength);
    }

    public static int sign(int a) {
        return (int)Math.signum(a) == 0 ? 1 : (int)Math.signum(a);
    }

    public static Stream<BlockPosition> collectWallBlocks(Context context, PlaneFilling planeFilling) {
        LinkedHashSet set = Sets.newLinkedHashSet();
        BlockPosition pos1 = context.getPosition(0);
        BlockPosition pos2 = context.getPosition(1);
        int x1 = pos1.x();
        int y1 = pos1.y();
        int z1 = pos1.z();
        int x2 = pos2.x();
        int y2 = pos2.y();
        int z2 = pos2.z();
        block0 : switch (BlockStructure.getShape(pos1, pos2)) {
            case SINGLE: {
                Single.addSingleBlock(set, x1, y1, z1);
                break;
            }
            case LINE_X: 
            case LINE_Y: 
            case LINE_Z: {
                Line.addLineBlocks(set, x1, y1, z1, x2, y2, z2);
                break;
            }
            case PLANE_Z: {
                switch (planeFilling) {
                    case FILLED: {
                        Square.addFullSquareBlocksZ(set, x1, x2, y1, y2, z1);
                        break;
                    }
                    case HOLLOW: {
                        Square.addHollowSquareBlocksZ(set, x1, x2, y1, y2, z1);
                    }
                }
                break;
            }
            case PLANE_X: {
                switch (planeFilling) {
                    case FILLED: {
                        Square.addFullSquareBlocksX(set, x1, y1, y2, z1, z2);
                        break block0;
                    }
                    case HOLLOW: {
                        Square.addHollowSquareBlocksX(set, x1, y1, y2, z1, z2);
                    }
                }
            }
        }
        return set.stream();
    }

    @Override
    public BlockInteraction trace(Player player, Context context, int index) {
        return switch (index) {
            case 0 -> Single.traceSingle(player, context);
            case 1 -> Wall.traceWall(player, context, this.planeLength);
            default -> null;
        };
    }

    @Override
    public Stream<BlockPosition> collect(Context context, int index) {
        return switch (index) {
            case 1 -> Single.collectSingleBlocks(context);
            case 2 -> Wall.collectWallBlocks(context, this.planeFilling);
            default -> Stream.empty();
        };
    }

    @Override
    public int traceSize(Context context) {
        return 2;
    }

    @Override
    public BuildMode getMode() {
        return BuildMode.WALL;
    }

    protected static class WallCriteria
    extends BlockStructure.AxisCriteria {
        public WallCriteria(Axis axis, Player player, Vector3d center, int reach, boolean skipRaytrace) {
            super(axis, player, center, reach, skipRaytrace);
        }

        public double angle() {
            Vector3d wall = this.planeVec().sub(this.startVec());
            return MathUtils.abs(wall.x() * this.look.x()) + Math.abs(wall.z() * this.look.z());
        }

        public double distanceAngle() {
            return this.distanceToEyeSqr() * this.angle();
        }
    }
}

