/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.forge.platform;

import com.google.auto.service.AutoService;
import dev.huskuraft.effortless.api.core.ItemStack;
import dev.huskuraft.effortless.api.core.ResourceLocation;
import dev.huskuraft.effortless.api.core.Stat;
import dev.huskuraft.effortless.api.core.StatType;
import dev.huskuraft.effortless.api.core.StatTypes;
import dev.huskuraft.effortless.api.core.fluid.Fluid;
import dev.huskuraft.effortless.api.core.fluid.Fluids;
import dev.huskuraft.effortless.api.platform.ContentFactory;
import dev.huskuraft.effortless.api.platform.OperatingSystem;
import dev.huskuraft.effortless.api.platform.PlatformReference;
import dev.huskuraft.effortless.api.sound.Sound;
import dev.huskuraft.effortless.api.sound.Sounds;
import dev.huskuraft.effortless.api.tag.InputStreamTagReader;
import dev.huskuraft.effortless.api.tag.OutputStreamTagWriter;
import dev.huskuraft.effortless.api.text.Text;
import dev.huskuraft.effortless.forge.core.MinecraftFluid;
import dev.huskuraft.effortless.forge.core.MinecraftItem;
import dev.huskuraft.effortless.forge.core.MinecraftItemStack;
import dev.huskuraft.effortless.forge.core.MinecraftResourceLocation;
import dev.huskuraft.effortless.forge.core.MinecraftText;
import dev.huskuraft.effortless.forge.sound.MinecraftSound;
import dev.huskuraft.effortless.forge.tag.MinecraftRecordTag;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;

@AutoService(value={ContentFactory.class})
public class MinecraftContentFactory
implements ContentFactory {
    @Override
    public ResourceLocation newResourceLocation(String namespace, String path) {
        return new MinecraftResourceLocation(new net.minecraft.resources.ResourceLocation(namespace, path));
    }

    @Override
    public Optional<dev.huskuraft.effortless.api.core.Item> newOptionalItem(ResourceLocation location) {
        return BuiltInRegistries.f_257033_.m_6612_((net.minecraft.resources.ResourceLocation)location.reference()).map(MinecraftItem::ofNullable);
    }

    @Override
    public ItemStack newItemStack() {
        return new MinecraftItemStack(net.minecraft.world.item.ItemStack.f_41583_);
    }

    @Override
    public ItemStack newItemStack(dev.huskuraft.effortless.api.core.Item item, int count) {
        return new MinecraftItemStack(new net.minecraft.world.item.ItemStack((ItemLike)((Item)item.reference()), count));
    }

    @Override
    public Text newText() {
        return new MinecraftText((Component)Component.m_237119_());
    }

    @Override
    public Text newText(String text) {
        return new MinecraftText((Component)Component.m_237113_((String)text));
    }

    @Override
    public Text newTranslatableText(String text) {
        return new MinecraftText((Component)Component.m_237115_((String)text));
    }

    @Override
    public Text newTranslatableText(String text, Object ... args) {
        return new MinecraftText((Component)Component.m_237110_((String)text, (Object[])args));
    }

    @Override
    public InputStreamTagReader getInputStreamTagReader() {
        return input -> new MinecraftRecordTag(NbtIo.m_128939_((InputStream)input));
    }

    @Override
    public OutputStreamTagWriter getOutputStreamTagWriter() {
        return (output, config) -> NbtIo.m_128947_((CompoundTag)((CompoundTag)config.reference()), (OutputStream)output);
    }

    @Override
    public OperatingSystem getOperatingSystem() {
        return switch (Util.m_137581_()) {
            default -> throw new IncompatibleClassChangeError();
            case Util.OS.LINUX -> OperatingSystem.LINUX;
            case Util.OS.SOLARIS -> OperatingSystem.SOLARIS;
            case Util.OS.WINDOWS -> OperatingSystem.WINDOWS;
            case Util.OS.OSX -> OperatingSystem.MACOS;
            case Util.OS.UNKNOWN -> OperatingSystem.UNKNOWN;
        };
    }

    @Override
    public Sound getSound(Sounds sounds) {
        SoundEvent sound = switch (sounds) {
            default -> throw new IncompatibleClassChangeError();
            case Sounds.UI_BUTTON_CLICK -> (SoundEvent)SoundEvents.f_12490_.m_203334_();
            case Sounds.UI_TOAST_IN -> SoundEvents.f_12497_;
            case Sounds.UI_TOAST_OUT -> SoundEvents.f_12498_;
        };
        return new MinecraftSound(sound);
    }

    @Override
    public Fluid getFluid(Fluids fluids) {
        net.minecraft.world.level.material.Fluid fluid = switch (fluids) {
            default -> throw new IncompatibleClassChangeError();
            case Fluids.EMPTY -> net.minecraft.world.level.material.Fluids.f_76191_;
            case Fluids.FLOWING_WATER -> net.minecraft.world.level.material.Fluids.f_76192_;
            case Fluids.WATER -> net.minecraft.world.level.material.Fluids.f_76193_;
            case Fluids.FLOWING_LAVA -> net.minecraft.world.level.material.Fluids.f_76194_;
            case Fluids.LAVA -> net.minecraft.world.level.material.Fluids.f_76195_;
        };
        return MinecraftFluid.ofNullable(fluid);
    }

    @Override
    public <T extends PlatformReference> StatType<T> getStatType(StatTypes statTypes) {
        final net.minecraft.stats.StatType statType = switch (statTypes) {
            default -> throw new IncompatibleClassChangeError();
            case StatTypes.ITEM_USED -> Stats.f_12982_;
            case StatTypes.ITEM_BROKEN -> Stats.f_12983_;
            case StatTypes.ITEM_PICKED_UP -> Stats.f_12984_;
            case StatTypes.ITEM_DROPPED -> Stats.f_12985_;
        };
        return new StatType<T>(){

            @Override
            public Stat<T> get(T value) {
                return () -> statType.m_12902_((Object)((Item)value.reference()));
            }

            @Override
            public Object refs() {
                return statType;
            }
        };
    }
}

