/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.screen.item;

import dev.huskuraft.effortless.api.core.Item;
import dev.huskuraft.effortless.api.core.ItemStack;
import dev.huskuraft.effortless.api.core.Items;
import dev.huskuraft.effortless.api.gui.AbstractPanelScreen;
import dev.huskuraft.effortless.api.gui.button.Button;
import dev.huskuraft.effortless.api.gui.container.EditableEntryList;
import dev.huskuraft.effortless.api.gui.input.EditBox;
import dev.huskuraft.effortless.api.gui.text.TextWidget;
import dev.huskuraft.effortless.api.platform.ClientContentFactory;
import dev.huskuraft.effortless.api.platform.Entrance;
import dev.huskuraft.effortless.api.platform.SearchBy;
import dev.huskuraft.effortless.api.platform.SearchTree;
import dev.huskuraft.effortless.api.text.Text;
import dev.huskuraft.effortless.screen.item.ItemStackList;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class EffortlessItemPickerScreen
extends AbstractPanelScreen {
    private final Predicate<Item> filter;
    protected final Consumer<Item> consumer;
    protected TextWidget titleTextWidget;
    protected ItemStackList entries;
    protected EditBox searchEditBox;
    protected Button addButton;
    protected Button cancelButton;

    public EffortlessItemPickerScreen(Entrance entrance, Predicate<Item> filter, Consumer<Item> consumer) {
        super(entrance, Text.translate("effortless.item.picker.title"), 264, 238);
        this.filter = filter;
        this.consumer = consumer;
    }

    @Override
    public void onCreate() {
        this.titleTextWidget = this.addWidget(new TextWidget(this.getEntrance(), this.getLeft() + this.getWidth() / 2, this.getTop() + 18 - 10, this.getScreenTitle().withColor(0x404040), TextWidget.Gravity.CENTER));
        this.searchEditBox = this.addWidget(new EditBox(this.getEntrance(), this.getLeft() + 6, this.getTop() + 18, this.getWidth() - 12, 20, Text.translate("effortless.item.picker.search")));
        this.searchEditBox.setMaxLength(255);
        this.searchEditBox.setHint(Text.translate("effortless.item.picker.search_hint"));
        this.searchEditBox.setResponder(text -> this.setSearchResult((String)text));
        this.entries = this.addWidget(new ItemStackList(this.getEntrance(), this.getLeft() + 6, this.getTop() + 18 + 24, this.getWidth() - 12 - 8, this.getHeight() - 18 - 24 - 30));
        this.cancelButton = this.addWidget(Button.builder((Entrance)this.getEntrance(), Text.translate("effortless.item.picker.cancel"), button -> this.detach()).setBoundsGrid(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight(), 0.0f, 0.0f, 0.5f).build());
        this.addButton = this.addWidget(Button.builder((Entrance)this.getEntrance(), Text.translate("effortless.item.picker.add"), button -> {
            this.detach();
            this.consumer.accept(((ItemStack)((EditableEntryList.Entry)this.entries.getSelected()).getItem()).getItem());
        }).setBoundsGrid(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight(), 0.0f, 0.5f, 0.5f).build());
        this.setSearchResult("");
    }

    @Override
    public void onReload() {
        this.addButton.setActive(this.entries.hasSelected());
        if (this.entries.consumeDoubleClick() && this.entries.hasSelected()) {
            this.detach();
            this.consumer.accept(((ItemStack)((EditableEntryList.Entry)this.entries.getSelected()).getItem()).getItem());
        }
    }

    protected void setSearchResult(String string) {
        if (string.startsWith("#")) {
            SearchTree<ItemStack> searchTree = ClientContentFactory.getInstance().searchItemStack(SearchBy.TAG);
            this.entries.reset(searchTree.search(string.substring(1).toLowerCase(Locale.ROOT)).stream().filter(itemStack -> this.filter.test(itemStack.getItem())).toList());
        } else {
            SearchTree<ItemStack> airSearchTree = SearchTree.of(List.of(Items.AIR.item().getDefaultStack()), items -> Stream.of(items.getName().getString().toLowerCase(Locale.ROOT)));
            SearchTree<ItemStack> searchTree = ClientContentFactory.getInstance().searchItemStack(SearchBy.NAME);
            this.entries.reset(Stream.concat(airSearchTree.search(string.toLowerCase(Locale.ROOT)).stream().filter(itemStack -> this.filter.test(itemStack.getItem())), searchTree.search(string.toLowerCase(Locale.ROOT)).stream().filter(itemStack -> this.filter.test(itemStack.getItem()))).toList());
        }
        this.entries.setSelected(null);
        this.entries.setScrollAmount(0.0);
    }
}

