/*
 * Decompiled with CFR 0.152.
 */
package dev.huskuraft.effortless.screen.player;

import dev.huskuraft.effortless.api.core.PlayerInfo;
import dev.huskuraft.effortless.api.gui.AbstractPanelScreen;
import dev.huskuraft.effortless.api.gui.button.Button;
import dev.huskuraft.effortless.api.gui.container.EditableEntryList;
import dev.huskuraft.effortless.api.gui.input.EditBox;
import dev.huskuraft.effortless.api.gui.text.TextWidget;
import dev.huskuraft.effortless.api.platform.ClientEntrance;
import dev.huskuraft.effortless.api.platform.Entrance;
import dev.huskuraft.effortless.api.platform.SearchTree;
import dev.huskuraft.effortless.api.text.Text;
import dev.huskuraft.effortless.screen.player.PlayerInfoList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class EffortlessOnlinePlayersScreen
extends AbstractPanelScreen {
    private final List<PlayerInfo> players = this.getEntrance().getClient().getOnlinePlayers();
    private final Consumer<PlayerInfo> consumer;
    private TextWidget titleTextWidget;
    private PlayerInfoList entries;
    private EditBox searchEditBox;
    private Button addButton;
    private Button cancelButton;

    public EffortlessOnlinePlayersScreen(Entrance entrance, Consumer<PlayerInfo> consumer) {
        super(entrance, Text.translate("effortless.online_players.title"), 264, 238);
        this.consumer = consumer;
    }

    @Override
    protected ClientEntrance getEntrance() {
        return super.getEntrance();
    }

    @Override
    public void onCreate() {
        this.titleTextWidget = this.addWidget(new TextWidget(this.getEntrance(), this.getLeft() + this.getWidth() / 2, this.getTop() + 18 - 10, this.getScreenTitle().withColor(0x404040), TextWidget.Gravity.CENTER));
        this.searchEditBox = this.addWidget(new EditBox(this.getEntrance(), this.getLeft() + 6, this.getTop() + 18, this.getWidth() - 12, 20, Text.translate("effortless.item.picker.search")));
        this.searchEditBox.setMaxLength(255);
        this.searchEditBox.setHint(Text.translate("effortless.online_players.search_hint"));
        this.searchEditBox.setResponder(text -> this.setSearchResult((String)text));
        this.cancelButton = this.addWidget(Button.builder((Entrance)this.getEntrance(), Text.translate("effortless.button.cancel"), button -> this.detach()).setBoundsGrid(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight(), 0.0f, 0.0f, 0.5f).build());
        this.addButton = this.addWidget(Button.builder((Entrance)this.getEntrance(), Text.translate("effortless.button.select"), button -> {
            this.detach();
            this.consumer.accept((PlayerInfo)((EditableEntryList.Entry)this.entries.getSelected()).getItem());
        }).setBoundsGrid(this.getLeft(), this.getTop(), this.getWidth(), this.getHeight(), 0.0f, 0.5f, 0.5f).build());
        this.entries = this.addWidget(new PlayerInfoList((Entrance)this.getEntrance(), this.getLeft() + 6, this.getTop() + 18 + 24, this.getWidth() - 12 - 8, this.getHeight() - 18 - 24 - 30, true));
        this.entries.setAlwaysShowScrollbar(true);
        this.entries.reset(this.players);
    }

    @Override
    public void onReload() {
        this.addButton.setActive(this.entries.hasSelected());
        if (this.entries.consumeDoubleClick() && this.entries.hasSelected()) {
            this.detach();
            this.consumer.accept((PlayerInfo)((EditableEntryList.Entry)this.entries.getSelected()).getItem());
        }
    }

    private void setSearchResult(String string) {
        this.entries.reset(SearchTree.of(this.players, p -> Stream.of(p.getName())).search(string));
        this.entries.setSelected(null);
        this.entries.setScrollAmount(0.0);
    }
}

