/*
 * Decompiled with CFR 0.152.
 */
package me.fzzyhmstrs.fzzy_config.util;

import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.function.Supplier;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.fzzyhmstrs.fzzy_config.entry.EntrySuggester;
import me.fzzyhmstrs.fzzy_config.entry.EntryValidator;
import me.fzzyhmstrs.fzzy_config.util.ValidationResult;
import me.fzzyhmstrs.fzzy_config.util.function.ConstPredicate;
import me.fzzyhmstrs.fzzy_config.util.function.ConstSupplier;
import me.fzzyhmstrs.fzzy_config.validation.misc.ChoiceValidator;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 (2\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003:\u0001(B5\b\u0007\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u0012\u0012\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00070\u0006\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\u000e\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0013\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J3\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00142\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u0016H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ%\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00020\u001e2\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u001cH\u0016\u00a2\u0006\u0004\b\u001f\u0010 R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010!R \u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00070\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\"R\u0014\u0010\n\u001a\u00020\t8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010#R!\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010%\u001a\u0004\b&\u0010\u0011\u00a8\u0006)"}, d2={"Lme/fzzyhmstrs/fzzy_config/util/AllowableIdentifiers;", "Lme/fzzyhmstrs/fzzy_config/entry/EntryValidator;", "Lnet/minecraft/resources/ResourceLocation;", "Lme/fzzyhmstrs/fzzy_config/entry/EntrySuggester;", "Ljava/util/function/Predicate;", "predicate", "Ljava/util/function/Supplier;", "", "supplier", "", "cache", "<init>", "(Ljava/util/function/Predicate;Ljava/util/function/Supplier;Z)V", "identifier", "test", "(Lnet/minecraft/resources/ResourceLocation;)Z", "get", "()Ljava/util/List;", "", "input", "", "cursor", "Lme/fzzyhmstrs/fzzy_config/validation/misc/ChoiceValidator;", "choiceValidator", "Ljava/util/concurrent/CompletableFuture;", "Lcom/mojang/brigadier/suggestion/Suggestions;", "getSuggestions", "(Ljava/lang/String;ILme/fzzyhmstrs/fzzy_config/validation/misc/ChoiceValidator;)Ljava/util/concurrent/CompletableFuture;", "Lme/fzzyhmstrs/fzzy_config/entry/EntryValidator$ValidationType;", "type", "Lme/fzzyhmstrs/fzzy_config/util/ValidationResult;", "validateEntry", "(Lnet/minecraft/resources/ResourceLocation;Lme/fzzyhmstrs/fzzy_config/entry/EntryValidator$ValidationType;)Lme/fzzyhmstrs/fzzy_config/util/ValidationResult;", "Ljava/util/function/Predicate;", "Ljava/util/function/Supplier;", "Z", "cached$delegate", "Lkotlin/Lazy;", "getCached", "cached", "Companion", "fzzy_config"})
@SourceDebugExtension(value={"SMAP\nAllowableIdentifiers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AllowableIdentifiers.kt\nme/fzzyhmstrs/fzzy_config/util/AllowableIdentifiers\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,111:1\n774#2:112\n865#2,2:113\n*S KotlinDebug\n*F\n+ 1 AllowableIdentifiers.kt\nme/fzzyhmstrs/fzzy_config/util/AllowableIdentifiers\n*L\n87#1:112\n87#1:113,2\n*E\n"})
public final class AllowableIdentifiers
implements EntryValidator<ResourceLocation>,
EntrySuggester<ResourceLocation> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Predicate<ResourceLocation> predicate;
    @NotNull
    private final Supplier<List<ResourceLocation>> supplier;
    private final boolean cache;
    @NotNull
    private final Lazy cached$delegate;
    @NotNull
    private static final AllowableIdentifiers ANY = new AllowableIdentifiers(new ConstPredicate(true), new ConstSupplier<List>(CollectionsKt.emptyList()), false, 4, null);

    @JvmOverloads
    public AllowableIdentifiers(@NotNull Predicate<ResourceLocation> predicate, @NotNull Supplier<List<ResourceLocation>> supplier2, boolean cache) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        Intrinsics.checkNotNullParameter(supplier2, (String)"supplier");
        this.predicate = predicate;
        this.supplier = supplier2;
        this.cache = cache;
        this.cached$delegate = LazyKt.lazy(() -> AllowableIdentifiers.cached_delegate$lambda$0(this));
    }

    public /* synthetic */ AllowableIdentifiers(Predicate predicate, Supplier supplier2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(predicate, supplier2, bl);
    }

    private final List<ResourceLocation> getCached() {
        Lazy lazy = this.cached$delegate;
        return (List)lazy.getValue();
    }

    public final boolean test(@NotNull ResourceLocation identifier) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        return this.predicate.test(identifier);
    }

    @NotNull
    public final List<ResourceLocation> get() {
        List<ResourceLocation> list;
        if (this.cache) {
            list = this.getCached();
        } else {
            List<ResourceLocation> list2 = this.supplier.get();
            Intrinsics.checkNotNull(list2);
            list = list2;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompletableFuture<Suggestions> getSuggestions(@NotNull String input, int cursor, @NotNull ChoiceValidator<ResourceLocation> choiceValidator) {
        void $this$filterTo$iv$iv;
        String truncatedInput;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter(choiceValidator, (String)"choiceValidator");
        String string = input.substring(0, cursor);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String string2 = truncatedInput = string;
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        SuggestionsBuilder builder = new SuggestionsBuilder(truncatedInput, string3, 0);
        Iterable $this$filter$iv = this.get();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ResourceLocation it = (ResourceLocation)element$iv$iv;
            boolean bl = false;
            if (!choiceValidator.validateEntry(it, EntryValidator.ValidationType.STRONG).isValid()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        CompletableFuture completableFuture = SharedSuggestionProvider.m_82926_((Iterable)((List)destination$iv$iv), (SuggestionsBuilder)builder);
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"suggestIdentifiers(...)");
        return completableFuture;
    }

    @Override
    @NotNull
    public ValidationResult<ResourceLocation> validateEntry(@NotNull ResourceLocation input, @NotNull EntryValidator.ValidationType type) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return type == EntryValidator.ValidationType.WEAK ? ValidationResult.Companion.success(input) : ValidationResult.Companion.predicated(input, this.test(input), ValidationResult.Errors.INSTANCE.getINVALID(), AllowableIdentifiers::validateEntry$lambda$2);
    }

    @JvmOverloads
    public AllowableIdentifiers(@NotNull Predicate<ResourceLocation> predicate, @NotNull Supplier<List<ResourceLocation>> supplier2) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        Intrinsics.checkNotNullParameter(supplier2, (String)"supplier");
        this(predicate, supplier2, false, 4, null);
    }

    private static final List cached_delegate$lambda$0(AllowableIdentifiers this$0) {
        return this$0.supplier.get();
    }

    private static final ValidationResult.ErrorEntry.Builder validateEntry$lambda$2(ValidationResult.ErrorEntry.Builder b) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        return b.content("Identifier invalid or not allowed");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lme/fzzyhmstrs/fzzy_config/util/AllowableIdentifiers$Companion;", "", "<init>", "()V", "Lme/fzzyhmstrs/fzzy_config/util/AllowableIdentifiers;", "ANY", "Lme/fzzyhmstrs/fzzy_config/util/AllowableIdentifiers;", "getANY", "()Lme/fzzyhmstrs/fzzy_config/util/AllowableIdentifiers;", "fzzy_config"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AllowableIdentifiers getANY() {
            return ANY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

