/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.forge.util;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SeagrassBlock;
import net.minecraft.world.level.block.TallGrassBlock;
import net.minecraft.world.level.block.WebBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.event.TickEvent;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class BlockRendererImpl {
    public static final Function<BlockState, ItemTransform> B2T;
    public static final ItemTransform T_CUBE;
    public static final ItemTransform T_CROSS;
    public static final Set<BlockEntity> TICKED_BE;

    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            TICKED_BE.clear();
        }
    }

    public static void render(BlockState blockState, GuiGraphics draw, int x, int y, float delta) {
        FluidState fluidState;
        PoseStack matrices = draw.m_280168_();
        matrices.m_85836_();
        matrices.m_252880_((float)x, (float)y, 150.0f);
        matrices.m_252931_(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
        matrices.m_85841_(16.0f, 16.0f, 16.0f);
        ClientLevel world = Minecraft.m_91087_().f_91073_;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        BlockPos blockPos = player != null ? player.m_20183_() : BlockPos.f_121853_;
        ItemTransform t = B2T.apply(blockState);
        Objects.requireNonNullElse(t, T_CUBE).m_111763_(false, matrices);
        BlockRenderDispatcher brm = Minecraft.m_91087_().m_91289_();
        MultiBufferSource.BufferSource vcp = draw.m_280091_();
        VertexConsumer consumer = vcp.m_6299_(Sheets.m_110792_());
        if (blockState.m_60799_() != RenderShape.INVISIBLE) {
            RandomSource random = RandomSource.m_216327_();
            random.m_188584_(42L);
            consumer.m_85969_(0xF000F0);
            brm.m_234355_(blockState, blockPos, (BlockAndTintGetter)world, matrices, consumer, false, random);
        }
        if (!(fluidState = blockState.m_60819_()).m_76178_()) {
            // empty if block
        }
        matrices.m_85849_();
        draw.m_280262_();
    }

    static {
        T_CUBE = new ItemTransform(new Vector3f(30.0f, 210.0f, 0.0f), new Vector3f(0.925f, -0.8125f, 0.0f), new Vector3f(0.625f));
        T_CROSS = new ItemTransform(new Vector3f(15.0f, 195.0f, 0.0f), new Vector3f(1.0f, -0.95f, 0.0f), new Vector3f(0.8f));
        TICKED_BE = new HashSet<BlockEntity>();
        B2T = state -> {
            Block block = state.m_60734_();
            return block instanceof FlowerBlock || block instanceof SaplingBlock || block instanceof WebBlock || block instanceof TallGrassBlock || block instanceof SeagrassBlock || block instanceof DoublePlantBlock ? T_CROSS : null;
        };
    }
}

