/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.variantsandventures.common.entity.mob;

import com.faboslav.variantsandventures.common.VariantsAndVentures;
import com.faboslav.variantsandventures.common.entity.ai.goal.LeaveWaterGoal;
import com.faboslav.variantsandventures.common.entity.ai.goal.TargetAboveWaterGoal;
import com.faboslav.variantsandventures.common.entity.ai.goal.WanderAroundOnSurfaceGoal;
import com.faboslav.variantsandventures.common.init.VariantsAndVenturesSoundEvents;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import java.util.function.Predicate;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.storage.loot.LootDataManager;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public final class MurkEntity
extends AbstractSkeleton
implements Shearable {
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(MurkEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> SHEARED = SynchedEntityData.m_135353_(MurkEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final String VARIANT_NBT_KEY = "Variant";
    public static final String SHEARED_NBT_KEY = "Sheared";
    private boolean targetingUnderwater;
    private final WaterBoundPathNavigation waterNavigation;
    private final GroundPathNavigation landNavigation;
    private final Predicate<LivingEntity> PLAYER_FILTER = entity -> {
        if (entity != null) {
            return !this.m_9236_().m_46461_() || entity.m_20069_();
        }
        return false;
    };

    public MurkEntity(EntityType<? extends AbstractSkeleton> entityType, Level world) {
        super(entityType, world);
        this.f_21342_ = new MurkMoveControl(this);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.waterNavigation = new WaterBoundPathNavigation((Mob)this, world);
        this.landNavigation = new GroundPathNavigation((Mob)this, world);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData, @Nullable CompoundTag entityNbt) {
        this.setVariant(Variant.getRandom(this.f_19796_));
        return super.m_6518_(world, difficulty, spawnReason, entityData, entityNbt);
    }

    public static boolean canSpawn(EntityType<MurkEntity> type, ServerLevelAccessor world, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        return world.m_6425_(pos.m_7495_()).m_205070_(FluidTags.f_13131_) && MurkEntity.isValidSpawnDepth((LevelAccessor)world, pos) && random.m_188503_(40) == 0;
    }

    private static boolean isValidSpawnDepth(LevelAccessor world, BlockPos pos) {
        return pos.m_123342_() < world.m_5736_() - 5;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new WanderAroundOnSurfaceGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new LeaveWaterGoal(this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new TargetAboveWaterGoal(this, 1.0, this.m_9236_().m_5736_()));
        this.f_21345_.m_25352_(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, this.PLAYER_FILTER));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Axolotl.class, true, false));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Turtle.class, 10, true, false, Turtle.f_30122_));
        super.m_8099_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(SHEARED, (Object)false);
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_(VARIANT_NBT_KEY, this.getVariant().getId());
        nbt.m_128379_(SHEARED_NBT_KEY, this.isSheared());
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.setVariant(Variant.VARIANTS[nbt.m_128451_(VARIANT_NBT_KEY)]);
        this.setSheared(nbt.m_128471_(SHEARED_NBT_KEY));
    }

    public boolean m_6914_(LevelReader world) {
        return world.m_45784_((Entity)this);
    }

    public static AttributeSupplier.Builder createMurkAttributes() {
        return AbstractSkeleton.m_32166_().m_22268_(Attributes.f_22276_, 16.0);
    }

    protected SoundEvent m_7515_() {
        return this.m_20069_() ? VariantsAndVenturesSoundEvents.ENTITY_MURK_AMBIENT_WATER.get() : VariantsAndVenturesSoundEvents.ENTITY_MURK_AMBIENT.get();
    }

    public void m_8032_() {
        SoundEvent soundEvent = this.m_7515_();
        if (soundEvent != null) {
            this.m_5496_(soundEvent, this.m_20069_() ? 0.25f : this.m_6121_(), this.m_6100_());
        }
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return this.m_20069_() ? VariantsAndVenturesSoundEvents.ENTITY_MURK_HURT_WATER.get() : VariantsAndVenturesSoundEvents.ENTITY_MURK_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return this.m_20069_() ? VariantsAndVenturesSoundEvents.ENTITY_MURK_DEATH_WATER.get() : VariantsAndVenturesSoundEvents.ENTITY_MURK_DEATH.get();
    }

    public SoundEvent m_7878_() {
        return this.m_20069_() ? VariantsAndVenturesSoundEvents.ENTITY_MURK_STEP.get() : SoundEvents.f_12383_;
    }

    public void m_8119_() {
        if (!VariantsAndVentures.getConfig().enableMurk) {
            this.m_146870_();
        }
        super.m_8119_();
    }

    public void m_6504_(LivingEntity target, float pullProgress) {
        ItemStack itemStack = this.m_6298_(this.m_21120_(ProjectileUtil.m_37297_((LivingEntity)this, (Item)Items.f_42411_)));
        AbstractArrow persistentProjectileEntity = this.m_7932_(itemStack, pullProgress);
        double d = target.m_20185_() - this.m_20185_();
        double e = target.m_20227_(0.3333333333333333) - persistentProjectileEntity.m_20186_();
        double f = target.m_20189_() - this.m_20189_();
        double g = Math.sqrt(d * d + f * f);
        persistentProjectileEntity.m_6686_(d, e + g * (double)0.2f, f, 1.6f, (float)(14 - this.m_9236_().m_46791_().m_19028_() * 4));
        this.m_5496_(VariantsAndVenturesSoundEvents.ENTITY_MURK_ATTACK.get(), 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.m_9236_().m_7967_((Entity)persistentProjectileEntity);
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean m_6063_() {
        return !this.m_6069_();
    }

    public boolean m_147223_() {
        return this.m_6069_();
    }

    private boolean isTargetingUnderwater() {
        if (this.targetingUnderwater) {
            return true;
        }
        LivingEntity livingEntity = this.m_5448_();
        return livingEntity != null && livingEntity.m_20069_();
    }

    public void setTargetingUnderwater(boolean targetingUnderwater) {
        this.targetingUnderwater = targetingUnderwater;
    }

    public void m_7023_(Vec3 movementInput) {
        if (this.m_21515_() && this.m_20069_() && this.isTargetingUnderwater()) {
            this.m_19920_(0.01f, movementInput);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
        } else {
            super.m_7023_(movementInput);
        }
    }

    public void m_5844_() {
        if (!this.m_9236_().f_46443_) {
            if (this.m_21515_() && this.m_20069_() && this.isTargetingUnderwater()) {
                this.f_21344_ = this.waterNavigation;
                this.m_20282_(true);
            } else {
                this.f_21344_ = this.landNavigation;
                this.m_20282_(false);
            }
        }
    }

    public boolean hasFinishedCurrentPath() {
        BlockPos blockPos;
        Path path = this.m_21573_().m_26570_();
        if (path != null && (blockPos = path.m_77406_()) != null) {
            double d = this.m_20275_(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_());
            return d < 4.0;
        }
        return false;
    }

    public boolean isSheared() {
        return (Boolean)this.f_19804_.m_135370_(SHEARED);
    }

    public void setSheared(boolean sheared) {
        this.f_19804_.m_135381_(SHEARED, (Object)sheared);
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_150930_(Items.f_42574_) && this.m_6220_()) {
            this.m_5851_(SoundSource.PLAYERS);
            this.m_146852_(GameEvent.f_157781_, (Entity)player);
            if (!this.m_9236_().m_5776_()) {
                itemStack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        }
        return super.m_6071_(player, hand);
    }

    public void m_5851_(SoundSource shearedSoundCategory) {
        this.m_9236_().m_6269_(null, (Entity)this, VariantsAndVenturesSoundEvents.ENTITY_MURK_SHEAR.get(), shearedSoundCategory, 1.0f, 1.0f);
        this.dropShearedItems();
        this.setSheared(true);
    }

    private void dropShearedItems() {
        Level world = this.m_9236_();
        if (!(world instanceof ServerLevel) || !world.m_46469_().m_46207_(GameRules.f_46135_)) {
            return;
        }
        LootDataManager lootManager = world.m_7654_().m_278653_();
        if (lootManager == null) {
            return;
        }
        LootTable shearingLootTable = lootManager.m_278676_(VariantsAndVentures.makeID(String.format(Locale.ROOT, "entities/murk_%s_shearing", this.getVariant().getName())));
        LootParams lootContextParameterSet = new LootParams.Builder((ServerLevel)world).m_287286_(LootContextParams.f_81460_, (Object)this.m_20182_()).m_287286_(LootContextParams.f_81455_, (Object)this).m_287235_(LootContextParamSets.f_81416_);
        ObjectArrayList shearingDrops = shearingLootTable.m_287195_(lootContextParameterSet);
        for (ItemStack shearingDrop : shearingDrops) {
            this.m_19983_(shearingDrop);
        }
    }

    public boolean m_6220_() {
        return !this.isSheared() && this.m_6084_();
    }

    private void setNavigation(PathNavigation navigation) {
        this.f_21344_ = navigation;
    }

    public void setLandNavigation() {
        this.f_21344_ = this.landNavigation;
    }

    public void setWaterNavigation() {
        this.f_21344_ = this.waterNavigation;
    }

    public Variant getVariant() {
        return Variant.VARIANTS[(Integer)this.f_19804_.m_135370_(VARIANT)];
    }

    private void setVariant(Variant variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant.getId());
    }

    private final class MurkMoveControl
    extends MoveControl {
        private final MurkEntity murk;

        public MurkMoveControl(MurkEntity murk) {
            super((Mob)murk);
            this.murk = murk;
        }

        public void m_8126_() {
            LivingEntity livingEntity = this.murk.m_5448_();
            if (this.murk.isTargetingUnderwater() && this.murk.m_20069_()) {
                if (livingEntity != null && livingEntity.m_20186_() > this.murk.m_20186_() || this.murk.targetingUnderwater) {
                    this.murk.m_20256_(this.murk.m_20184_().m_82520_(0.0, 0.002, 0.0));
                }
                if (this.f_24981_ != MoveControl.Operation.MOVE_TO || this.murk.m_21573_().m_26571_()) {
                    this.murk.m_7910_(0.0f);
                    return;
                }
                double d = this.f_24975_ - this.murk.m_20185_();
                double e = this.f_24976_ - this.murk.m_20186_();
                double f = this.f_24977_ - this.murk.m_20189_();
                double g = Math.sqrt(d * d + e * e + f * f);
                e /= g;
                float h = (float)(Mth.m_14136_((double)f, (double)d) * 57.2957763671875) - 90.0f;
                this.murk.m_146922_(this.m_24991_(this.murk.m_146908_(), h, 90.0f));
                this.murk.f_20883_ = this.murk.m_146908_();
                float i = (float)(this.f_24978_ * this.murk.m_21133_(Attributes.f_22279_));
                float j = Mth.m_14179_((float)0.125f, (float)this.murk.m_6113_(), (float)i);
                this.murk.m_7910_(j);
                this.murk.m_20256_(this.murk.m_20184_().m_82520_((double)j * d * 0.005, (double)j * e * 0.1, (double)j * f * 0.005));
            } else {
                if (!this.murk.m_20096_()) {
                    this.murk.m_20256_(this.murk.m_20184_().m_82520_(0.0, -0.008, 0.0));
                }
                super.m_8126_();
            }
        }
    }

    public static enum Variant {
        PURPLE(0, "purple"),
        RED(1, "red"),
        YELLOW(2, "yellow");

        public static final Variant[] VARIANTS;
        private final int id;
        private final String name;

        private Variant(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        private static Variant getRandom(RandomSource random) {
            return (Variant)((Object)Util.m_214670_((Object[])((Variant[])Arrays.stream(VARIANTS).toArray(Variant[]::new)), (RandomSource)random));
        }

        static {
            VARIANTS = (Variant[])Arrays.stream(Variant.values()).sorted(Comparator.comparingInt(Variant::getId)).toArray(Variant[]::new);
        }
    }
}

