/*
 * Decompiled with CFR 0.152.
 */
package someassemblyrequired.data.providers;

import com.google.common.base.Preconditions;
import com.sammy.minersdelight.setup.MDItems;
import com.simibubi.create.AllItems;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.AlternativesEntry;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SetPotionFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.ModLoadedCondition;
import net.minecraftforge.common.crafting.conditions.NotCondition;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import someassemblyrequired.SomeAssemblyRequired;
import someassemblyrequired.data.providers.LootModifiers;
import someassemblyrequired.loot.OptionalLootItem;
import someassemblyrequired.loot.SetIngredientsFunction;
import someassemblyrequired.loot.SmeltMatchingItemFunction;
import someassemblyrequired.registry.ModBlocks;
import vectorwing.farmersdelight.common.registry.ModItems;

public class LootTables
extends LootTableProvider {
    private final List<LootTableProvider.SubProviderEntry> lootTables = new ArrayList<LootTableProvider.SubProviderEntry>();
    private final ExistingFileHelper existingFileHelper;
    private final LootModifiers lootModifiers;
    protected static final ResourceLocation VILLAGE_SANDWICH = SomeAssemblyRequired.id("inject/chests/village_house");

    public LootTables(PackOutput packOutput, ExistingFileHelper existingFileHelper, LootModifiers lootModifiers) {
        super(packOutput, Set.of(), List.of());
        this.existingFileHelper = existingFileHelper;
        this.lootModifiers = lootModifiers;
    }

    public List<LootTableProvider.SubProviderEntry> getTables() {
        this.lootTables.clear();
        this.addStandardDropTable((Block)ModBlocks.SANDWICHING_STATION.get());
        this.addSandwichLootTables();
        for (LootModifiers.Builder lootBuilder : this.lootModifiers.lootBuilders) {
            this.addLootTable(lootBuilder.getName(), lootBuilder.createLootTable(), lootBuilder.getParameterSet());
        }
        return this.lootTables;
    }

    private void addSandwichLootTables() {
        ResourceLocation sandwich = SomeAssemblyRequired.id("sandwich/sandwich");
        ResourceLocation sandwichLayer = SomeAssemblyRequired.id("sandwich/sandwich_layer");
        ResourceLocation special = SomeAssemblyRequired.id("sandwich/special");
        ResourceLocation burger = SomeAssemblyRequired.id("sandwich/burger");
        ResourceLocation protein = SomeAssemblyRequired.id("sandwich/ingredients/protein");
        ResourceLocation vegetables = SomeAssemblyRequired.id("sandwich/ingredients/vegetables");
        this.addLootTable(protein.m_135815_(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_(LootTables.whenNotLoaded(Items.f_42580_, 1, "farmersdelight")).m_79076_(LootTables.whenNotLoaded(Items.f_42486_, 1, "farmersdelight")).m_79076_(LootTables.whenNotLoaded(Items.f_42531_, 1, "farmersdelight")).m_79076_(LootTables.whenNotLoaded(Items.f_42530_, 1, "farmersdelight")).m_79076_(LootTables.whenLoaded((Item)ModItems.COOKED_BACON.get(), 3)).m_79076_(LootTables.whenLoaded((Item)ModItems.FRIED_EGG.get(), 4)).m_79076_(LootTables.whenLoaded((Item)ModItems.COOKED_CHICKEN_CUTS.get(), 3)).m_79076_(LootTables.whenLoaded((Item)ModItems.COOKED_MUTTON_CHOPS.get(), 2)).m_79076_(LootTables.whenLoaded((Item)ModItems.COOKED_COD_SLICE.get(), 1)).m_79076_(LootTables.whenLoaded((Item)ModItems.COOKED_SALMON_SLICE.get(), 1))), LootContextParamSets.f_81411_);
        this.addLootTable(vegetables.m_135815_(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_(LootTables.item(Items.f_42780_, 1)).m_79076_(LootTables.item((Item)someassemblyrequired.registry.ModItems.CHOPPED_CARROT.get(), 3)).m_79076_(LootTables.item((Item)someassemblyrequired.registry.ModItems.CHOPPED_GOLDEN_CARROT.get(), 1)).m_79076_(LootTables.item((Item)someassemblyrequired.registry.ModItems.APPLE_SLICES.get(), 2)).m_79076_(LootTables.item((Item)someassemblyrequired.registry.ModItems.GOLDEN_APPLE_SLICES.get(), 1)).m_79076_(LootTables.item((Item)someassemblyrequired.registry.ModItems.CHOPPED_BEETROOT.get(), 3)).m_79076_(LootTables.item((Item)someassemblyrequired.registry.ModItems.TOMATO_SLICES.get(), 4)).m_79076_(LootTables.whenLoaded((Item)ModItems.CABBAGE_LEAF.get(), 4))), LootContextParamSets.f_81411_);
        this.addLootTable(sandwichLayer.m_135815_(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_(LootTables.item((Item)someassemblyrequired.registry.ModItems.BREAD_SLICE.get()))).m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)AlternativesEntry.m_79395_((LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[]{LootTableReference.m_79776_((ResourceLocation)protein).m_79080_(LootTables.chance(0.7))}).m_7170_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)vegetables)))).m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)vegetables))), LootContextParamSets.f_81411_);
        this.addLootTable(sandwich.m_135815_(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)sandwichLayer))).m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)sandwichLayer)).m_79080_(LootTables.chance(0.1))).m_79161_(LootPool.m_79043_().m_79076_(LootTables.item((Item)someassemblyrequired.registry.ModItems.BREAD_SLICE.get()))), LootContextParamSets.f_81411_);
        this.addLootTable(special.m_135815_(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_(LootTables.item((Item)someassemblyrequired.registry.ModItems.BREAD_SLICE.get()))).m_79161_(LootPool.m_79043_().m_79076_(LootTables.item(Items.f_42787_, 20)).m_79076_(LootTables.item((Item)someassemblyrequired.registry.ModItems.TOASTED_BREAD_SLICE.get(), 1)).m_79076_(LootTables.item(Items.f_42455_, 1)).m_79076_(LootTables.item(Items.f_42620_, 1)).m_79076_(LootTables.whenLoaded((Item)ModItems.SQUID_INK_PASTA.get(), 1)).m_79076_(LootTables.whenLoaded((Item)ModItems.EGG_SANDWICH.get(), 1)).m_79076_(LootTables.whenLoaded((Item)ModItems.HOT_COCOA.get(), 1)).m_79076_(LootTables.whenLoaded((Item)ModItems.PUMPKIN_SOUP.get(), 1)).m_79076_(LootTables.whenLoaded((Item)ModItems.PASTA_WITH_MEATBALLS.get(), 1)).m_79076_(LootTables.whenLoaded((Item)ModItems.RATATOUILLE.get(), 1)).m_79076_(LootTables.whenLoaded((Item)AllItems.BUILDERS_TEA.get(), 1)).m_79076_(LootTables.whenLoaded((Item)AllItems.CHOCOLATE_BERRIES.get(), 1))).m_79161_(LootPool.m_79043_().m_79076_(LootTables.item((Item)someassemblyrequired.registry.ModItems.BREAD_SLICE.get()))), LootContextParamSets.f_81411_);
        this.addLootTable(burger.m_135815_(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_(LootTables.item((Item)someassemblyrequired.registry.ModItems.BURGER_BUN_BOTTOM.get()))).m_79161_(LootPool.m_79043_().m_79076_(LootTables.whenLoaded((Item)ModItems.BEEF_PATTY.get(), 5)).m_79076_(LootTables.whenLoaded((Item)MDItems.VEGAN_PATTY.get(), 5)).m_79076_(LootTables.whenLoaded((Item)ModItems.COOKED_BACON.get(), 2)).m_79076_(LootTables.whenLoaded((Item)ModItems.COOKED_MUTTON_CHOPS.get(), 1)).m_79076_(LootTables.whenLoaded((Item)ModItems.FRIED_EGG.get(), 2)).m_79076_(LootTables.whenNotLoaded(Items.f_42580_, 1, "farmersdelight")).m_79076_(LootTables.whenNotLoaded(Items.f_42486_, 1, "farmersdelight"))).m_79161_(LootPool.m_79043_().m_79080_(LootTables.chance(0.2)).m_79076_(LootTables.whenLoaded((Item)ModItems.COOKED_BACON.get(), 1)).m_79076_(LootTables.whenLoaded((Item)ModItems.TOMATO_SAUCE.get(), 1))).m_79161_(LootPool.m_79043_().m_79080_(LootTables.chance(0.5)).m_79076_(LootTables.whenLoaded((Item)ModItems.CABBAGE_LEAF.get(), 1))).m_79161_(LootPool.m_79043_().m_79080_(LootTables.chance(0.5)).m_79076_(LootTables.item((Item)someassemblyrequired.registry.ModItems.TOMATO_SLICES.get()))).m_79161_(LootPool.m_79043_().m_79080_(LootTables.chance(0.6)).m_79076_(LootTables.item((Item)someassemblyrequired.registry.ModItems.SLICED_ONION.get()))).m_79161_(LootPool.m_79043_().m_79080_(LootTables.chance(0.2)).m_79076_(LootTables.item(Items.f_42780_, 1)).m_79076_(LootTables.item((Item)someassemblyrequired.registry.ModItems.CHOPPED_CARROT.get(), 3)).m_79076_(LootTables.item((Item)someassemblyrequired.registry.ModItems.CHOPPED_GOLDEN_CARROT.get(), 1)).m_79076_(LootTables.item((Item)someassemblyrequired.registry.ModItems.APPLE_SLICES.get(), 2)).m_79076_(LootTables.item((Item)someassemblyrequired.registry.ModItems.GOLDEN_APPLE_SLICES.get(), 1)).m_79076_(LootTables.item((Item)someassemblyrequired.registry.ModItems.CHOPPED_BEETROOT.get(), 3))).m_79161_(LootPool.m_79043_().m_79076_(LootTables.item((Item)someassemblyrequired.registry.ModItems.BURGER_BUN_TOP.get()))), LootContextParamSets.f_81411_);
        this.addLootTableUnchecked(VILLAGE_SANDWICH.m_135815_(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79080_(LootTables.chance(0.4)).m_79076_((LootPoolEntryContainer.Builder)LootTables.sandwich().m_79707_(4).m_79078_(LootTables.count(2, 5)).m_79078_((LootItemFunction.Builder)SetIngredientsFunction.setIngredients().withEntry((LootPoolEntryContainer.Builder<?>)AlternativesEntry.m_79395_((LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[]{LootTableReference.m_79776_((ResourceLocation)special).m_79080_(LootTables.chance(0.15)), ((LootPoolSingletonContainer.Builder)LootTableReference.m_79776_((ResourceLocation)sandwich).m_79080_(LootTables.chance(0.25))).m_79078_(LootTables.toastBread())}).m_7170_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)sandwich))))).m_79076_((LootPoolEntryContainer.Builder)LootTables.sandwich().m_79078_(LootTables.count(2, 5)).m_79078_((LootItemFunction.Builder)SetIngredientsFunction.setIngredients().withEntry((LootPoolEntryContainer.Builder<?>)LootTableReference.m_79776_((ResourceLocation)burger))))), LootContextParamSets.f_81411_);
    }

    private void addStandardDropTable(Block block) {
        this.addBlockLootTable(block, LootTable.m_79147_().m_79161_(this.createStandardDrops((ItemLike)block)));
    }

    private void addBlockLootTable(Block block, LootTable.Builder lootTable) {
        this.lootTables.add(new LootTableProvider.SubProviderEntry(() -> lootBuilder -> lootBuilder.accept(block.m_60589_(), lootTable), LootContextParamSets.f_81421_));
    }

    private LootPool.Builder createStandardDrops(ItemLike itemProvider) {
        return LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(ExplosionCondition.m_81661_()).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)itemProvider));
    }

    protected static LootItemConditionalFunction.Builder<?> toastBread() {
        return SmeltMatchingItemFunction.smeltMatching((Item)someassemblyrequired.registry.ModItems.BREAD_SLICE.get());
    }

    protected static LootPoolSingletonContainer.Builder<?> sandwich(Potion potion) {
        return LootTables.sandwich(LootTables.potion(potion));
    }

    protected static LootPoolSingletonContainer.Builder<?> sandwich(Item item) {
        return LootTables.sandwich(LootTables.item(item));
    }

    protected static LootPoolSingletonContainer.Builder<?> sandwich(LootPoolSingletonContainer.Builder<?> ingredient) {
        return LootTables.sandwich().m_79078_((LootItemFunction.Builder)SetIngredientsFunction.setIngredients().withEntry((LootPoolEntryContainer.Builder<?>)LootTables.item((Item)someassemblyrequired.registry.ModItems.BREAD_SLICE.get())).withEntry((LootPoolEntryContainer.Builder<?>)ingredient).withEntry((LootPoolEntryContainer.Builder<?>)LootTables.item((Item)someassemblyrequired.registry.ModItems.BREAD_SLICE.get())));
    }

    protected static LootPoolSingletonContainer.Builder<?> sandwich() {
        return LootTables.item((Item)someassemblyrequired.registry.ModItems.SANDWICH.get());
    }

    protected static LootPoolSingletonContainer.Builder<?> potion(Potion potion) {
        return LootTables.item(Items.f_42589_).m_79078_((LootItemFunction.Builder)SetPotionFunction.m_193075_((Potion)potion));
    }

    protected static LootPoolSingletonContainer.Builder<?> whenLoaded(Item item, int weight) {
        return OptionalLootItem.whenLoaded(item).m_79707_(weight);
    }

    protected static LootPoolSingletonContainer.Builder<?> whenNotLoaded(Item item, int weight, String modid) {
        return OptionalLootItem.optionalLootItem(ForgeRegistries.ITEMS.getKey((Object)item), new ICondition[]{new NotCondition((ICondition)new ModLoadedCondition(modid))}).m_79707_(weight);
    }

    protected static LootPoolSingletonContainer.Builder<?> item(Item item) {
        return LootTables.item(item, 1);
    }

    protected static LootPoolSingletonContainer.Builder<?> item(Item item, int weight) {
        return LootItem.m_79579_((ItemLike)item).m_79707_(weight);
    }

    protected static LootItemConditionalFunction.Builder<?> count(int min, int max) {
        return SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)min, (float)max));
    }

    protected static LootItemCondition.Builder chance(double chance) {
        return LootItemRandomChanceCondition.m_81927_((float)((float)chance));
    }

    private void addLootTable(String location, LootTable.Builder lootTable, LootContextParamSet lootParameterSet) {
        if (location.startsWith("inject/")) {
            String actualLocation = location.replace("inject/", "");
            Preconditions.checkArgument((boolean)this.existingFileHelper.exists(new ResourceLocation("loot_tables/" + actualLocation + ".json"), PackType.SERVER_DATA), (String)"Loot table %s does not exist in any known data pack", (Object)actualLocation);
        }
        this.lootTables.add(new LootTableProvider.SubProviderEntry(() -> lootBuilder -> lootBuilder.accept(new ResourceLocation("some_assembly_required", location), lootTable), lootParameterSet));
    }

    private void addLootTableUnchecked(String location, LootTable.Builder lootTable, LootContextParamSet lootParameterSet) {
        this.lootTables.add(new LootTableProvider.SubProviderEntry(() -> lootBuilder -> lootBuilder.accept(new ResourceLocation("some_assembly_required", location), lootTable), lootParameterSet));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext validationContext) {
        map.forEach((location, lootTable) -> lootTable.m_79136_(validationContext));
    }
}

