/*
 * Decompiled with CFR 0.152.
 */
package com.maxwell.cyber_ware_port.client.upgrades.cyberEye;

import com.maxwell.cyber_ware_port.client.ClientCyberwareSettings;
import com.maxwell.cyber_ware_port.common.capability.CyberwareCapabilityProvider;
import com.maxwell.cyber_ware_port.common.capability.CyberwareUserData;
import com.maxwell.cyber_ware_port.common.item.base.ICyberware;
import com.maxwell.cyber_ware_port.init.ModItems;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.ItemStackHandler;

@Mod.EventBusSubscriber(modid="cyber_ware_port", value={Dist.CLIENT})
public class CyberwareHudOverlay {
    private static final ResourceLocation BATTERY_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"cyber_ware_port", (String)"textures/gui/battery_hud.png");

    @SubscribeEvent
    public static void onRenderGui(RenderGuiOverlayEvent.Post event) {
        if (event.getOverlay() != VanillaGuiOverlay.HOTBAR.type()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        player.getCapability(CyberwareCapabilityProvider.CYBERWARE_CAPABILITY).ifPresent(userData -> {
            if (!CyberwareHudOverlay.isHudActive(userData)) {
                return;
            }
            int x = ClientCyberwareSettings.hudX;
            int y = ClientCyberwareSettings.hudY;
            CyberwareHudOverlay.renderBatteryHud(event.getGuiGraphics(), mc, userData, x, y);
        });
    }

    private static boolean isHudActive(CyberwareUserData data) {
        ItemStackHandler handler = data.getInstalledCyberware();
        for (int i = 0; i < handler.getSlots(); ++i) {
            ICyberware cw;
            Item item;
            ItemStack stack = handler.getStackInSlot(i);
            if (stack.m_41619_() || stack.m_41720_() != ModItems.HUDJACK.get() && stack.m_41720_() != ModItems.CYBER_EYE.get() || !((item = stack.m_41720_()) instanceof ICyberware) || !(cw = (ICyberware)item).isActive(stack)) continue;
            return true;
        }
        return false;
    }

    public static void renderBatteryHud(GuiGraphics g, Minecraft mc, CyberwareUserData data, int x, int y) {
        int textColor;
        float a;
        float b;
        float gVal;
        float r;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BATTERY_TEXTURE);
        int current = data.getEnergyStored();
        int max = data.getMaxEnergyStored();
        int prod = data.getLastProduction();
        int cons = data.getLastConsumption();
        if (current <= 0) {
            boolean flash;
            long time = System.currentTimeMillis();
            boolean bl = flash = time % 500L < 250L;
            if (flash) {
                r = 1.0f;
                gVal = 0.0f;
                b = 0.0f;
                a = 1.0f;
                textColor = -65536;
            } else {
                r = 0.5f;
                gVal = 0.0f;
                b = 0.0f;
                a = 1.0f;
                textColor = -7864320;
            }
        } else {
            float[] userColor = ClientCyberwareSettings.getColorFloats();
            r = userColor[0];
            gVal = userColor[1];
            b = userColor[2];
            a = userColor[3];
            textColor = ClientCyberwareSettings.hudColor;
        }
        RenderSystem.setShaderColor((float)r, (float)gVal, (float)b, (float)a);
        int startX = x;
        int startY = y;
        int texTotalWidth = 37;
        int texTotalHeight = 25;
        int frameWidth = 13;
        int frameHeight = 25;
        g.m_280163_(BATTERY_TEXTURE, startX, startY, 0.0f, 0.0f, frameWidth, frameHeight, texTotalWidth, texTotalHeight);
        if (max > 0 && current > 0) {
            int barTextureU = 27;
            int barTextureV = 2;
            int barWidth = 10;
            int barFullHeight = 22;
            int offsetX = 2;
            int offsetY = 2;
            float pct = (float)current / (float)max;
            int renderHeight = (int)((float)barFullHeight * pct);
            if (renderHeight > 0) {
                int screenY = startY + offsetY + (barFullHeight - renderHeight);
                int textureV = barTextureV + (barFullHeight - renderHeight);
                g.m_280163_(BATTERY_TEXTURE, startX + offsetX, screenY, (float)barTextureU, (float)textureV, barWidth, renderHeight, texTotalWidth, texTotalHeight);
            }
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int textX = startX + frameWidth + 4;
        int textY = startY + 4;
        g.m_280056_(mc.f_91062_, current + " / " + max, textX, textY, textColor, true);
        g.m_280056_(mc.f_91062_, "-" + cons + " / +" + prod, textX, textY + 10, textColor, true);
        RenderSystem.disableBlend();
    }
}

