/*
 * Decompiled with CFR 0.152.
 */
package com.maxwell.cyber_ware_port.common.block.cwb.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.maxwell.cyber_ware_port.init.ModRecipes;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class AssemblyRecipe
implements Recipe<SimpleContainer> {
    private final ResourceLocation id;
    private final List<SizedIngredient> inputs;
    private final ItemStack output;

    public AssemblyRecipe(ResourceLocation id, List<SizedIngredient> inputs, ItemStack output) {
        this.id = id;
        this.inputs = inputs;
        this.output = output;
    }

    public List<SizedIngredient> getInputs() {
        return this.inputs;
    }

    public boolean matches(SimpleContainer pContainer, Level pLevel) {
        return true;
    }

    public ItemStack assemble(SimpleContainer pContainer, RegistryAccess pRegistryAccess) {
        return this.output.m_41777_();
    }

    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        return this.output;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.ASSEMBLY_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipes.ASSEMBLY_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<AssemblyRecipe> {
        public static final Serializer INSTANCE = new Serializer();

        public AssemblyRecipe fromJson(ResourceLocation pRecipeId, JsonObject pJson) {
            ArrayList<SizedIngredient> inputs = new ArrayList<SizedIngredient>();
            JsonArray inputArray = GsonHelper.m_13933_((JsonObject)pJson, (String)"inputs");
            for (int i = 0; i < inputArray.size(); ++i) {
                JsonObject entry = inputArray.get(i).getAsJsonObject();
                Ingredient ing = entry.has("ingredient") ? Ingredient.m_43917_((JsonElement)entry.get("ingredient")) : Ingredient.m_43917_((JsonElement)entry);
                int count = GsonHelper.m_13824_((JsonObject)entry, (String)"count", (int)1);
                inputs.add(new SizedIngredient(ing, count));
            }
            ResourceLocation outputId = new ResourceLocation(GsonHelper.m_13906_((JsonObject)pJson, (String)"output"));
            ItemStack outputStack = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(outputId));
            return new AssemblyRecipe(pRecipeId, inputs, outputStack);
        }

        @Nullable
        public AssemblyRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            int size = pBuffer.readInt();
            ArrayList<SizedIngredient> inputs = new ArrayList<SizedIngredient>();
            for (int i = 0; i < size; ++i) {
                Ingredient ing = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
                int count = pBuffer.readInt();
                inputs.add(new SizedIngredient(ing, count));
            }
            ItemStack output = pBuffer.m_130267_();
            return new AssemblyRecipe(pRecipeId, inputs, output);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, AssemblyRecipe pRecipe) {
            pBuffer.writeInt(pRecipe.inputs.size());
            for (SizedIngredient entry : pRecipe.inputs) {
                entry.ingredient.m_43923_(pBuffer);
                pBuffer.writeInt(entry.count);
            }
            pBuffer.m_130055_(pRecipe.output);
        }
    }

    public record SizedIngredient(Ingredient ingredient, int count) {
    }
}

