/*
 * Decompiled with CFR 0.152.
 */
package com.maxwell.cyber_ware_port.common.container;

import com.maxwell.cyber_ware_port.common.block.blueprintChest.BlueprintChestBlockEntity;
import com.maxwell.cyber_ware_port.common.item.BlueprintItem;
import com.maxwell.cyber_ware_port.init.ModBlocks;
import com.maxwell.cyber_ware_port.init.ModMenuTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class BlueprintChestMenu
extends AbstractContainerMenu {
    private static final int CONTAINER_SLOTS = 18;
    public final BlueprintChestBlockEntity blockEntity;

    public BlueprintChestMenu(int pContainerId, Inventory inv, FriendlyByteBuf extraData) {
        this(pContainerId, inv, inv.f_35978_.m_9236_().m_7702_(extraData.m_130135_()));
    }

    public BlueprintChestMenu(int pContainerId, Inventory inv, BlockEntity entity) {
        super((MenuType)ModMenuTypes.BLUEPRINT_CHEST_MENU.get(), pContainerId);
        this.blockEntity = (BlueprintChestBlockEntity)entity;
        this.addEntitySlots();
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
    }

    private void addEntitySlots() {
        this.blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> {
            for (int row = 0; row < 2; ++row) {
                for (int col = 0; col < 9; ++col) {
                    this.m_38897_((Slot)new SlotItemHandler((IItemHandler)handler, col + row * 9, 8 + col * 18, 18 + row * 18){

                        public boolean m_5857_(@NotNull ItemStack stack) {
                            return stack.m_41720_() instanceof BlueprintItem;
                        }
                    });
                }
            }
        });
    }

    public ItemStack m_7648_(Player playerIn, int pIndex) {
        Slot sourceSlot = (Slot)this.f_38839_.get(pIndex);
        if (sourceSlot == null || !sourceSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack sourceStack = sourceSlot.m_7993_();
        ItemStack copyOfSourceStack = sourceStack.m_41777_();
        int PLAYER_INVENTORY_START = 18;
        int PLAYER_HOTBAR_START = PLAYER_INVENTORY_START + 27;
        int END_OF_SLOTS = PLAYER_HOTBAR_START + 9;
        if (pIndex < 18) {
            if (!this.m_38903_(sourceStack, PLAYER_INVENTORY_START, END_OF_SLOTS, true)) {
                return ItemStack.f_41583_;
            }
        } else if (sourceStack.m_41720_() instanceof BlueprintItem) {
            if (!this.m_38903_(sourceStack, 0, 18, false)) {
                return ItemStack.f_41583_;
            }
        } else {
            return ItemStack.f_41583_;
        }
        if (sourceStack.m_41613_() == 0) {
            sourceSlot.m_5852_(ItemStack.f_41583_);
        } else {
            sourceSlot.m_6654_();
        }
        sourceSlot.m_142406_(playerIn, sourceStack);
        return copyOfSourceStack;
    }

    public boolean m_6875_(Player pPlayer) {
        return BlueprintChestMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.blockEntity.m_58904_(), (BlockPos)this.blockEntity.m_58899_()), (Player)pPlayer, (Block)((Block)ModBlocks.BLUEPRINT_CHEST.get()));
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.m_38897_(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 68 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 126));
        }
    }
}

