/*
 * Decompiled with CFR 0.152.
 */
package com.maxwell.cyber_ware_port.common.container;

import com.maxwell.cyber_ware_port.common.block.blueprintChest.BlueprintChestBlockEntity;
import com.maxwell.cyber_ware_port.common.block.component_box.ComponentBoxBlockEntity;
import com.maxwell.cyber_ware_port.common.block.cwb.CyberwareWorkbenchBlockEntity;
import com.maxwell.cyber_ware_port.common.item.BlueprintItem;
import com.maxwell.cyber_ware_port.common.item.base.ICyberware;
import com.maxwell.cyber_ware_port.init.ModBlocks;
import com.maxwell.cyber_ware_port.init.ModMenuTypes;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class CyberwareWorkbenchMenu
extends AbstractContainerMenu {
    private static final int WORKBENCH_SLOTS = 10;
    private static final int PANEL_X = -61;
    private static final int PANEL_Y = 12;
    private static final int SLOT_OFFSET_X = 10;
    private static final int SLOT_OFFSET_Y = 6;
    public final CyberwareWorkbenchBlockEntity blockEntity;
    private final Level level;
    private final List<List<Slot>> pageSlots = new ArrayList<List<Slot>>();
    private final List<List<Slot>> blueprintPageSlots = new ArrayList<List<Slot>>();
    public boolean hasExtendedInventory = false;
    public boolean hasBlueprintLibrary = false;
    public boolean isExtendedOpen = true;
    private int currentPage = 0;
    private int maxPages = 0;
    private int blueprintCurrentPage = 0;
    private int blueprintMaxPages = 0;
    private final ContainerData pageData = new SimpleContainerData(6){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> CyberwareWorkbenchMenu.this.currentPage;
                case 1 -> CyberwareWorkbenchMenu.this.maxPages;
                case 2 -> {
                    if (CyberwareWorkbenchMenu.this.isExtendedOpen) {
                        yield 1;
                    }
                    yield 0;
                }
                case 3 -> {
                    if (CyberwareWorkbenchMenu.this.hasBlueprintLibrary) {
                        yield 1;
                    }
                    yield 0;
                }
                case 4 -> CyberwareWorkbenchMenu.this.blueprintCurrentPage;
                case 5 -> CyberwareWorkbenchMenu.this.blueprintMaxPages;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    CyberwareWorkbenchMenu.this.currentPage = value;
                    CyberwareWorkbenchMenu.this.updateSlotPositions();
                    break;
                }
                case 1: {
                    CyberwareWorkbenchMenu.this.maxPages = value;
                    break;
                }
                case 2: {
                    CyberwareWorkbenchMenu.this.isExtendedOpen = value == 1;
                    CyberwareWorkbenchMenu.this.updateSlotPositions();
                    break;
                }
                case 3: {
                    CyberwareWorkbenchMenu.this.hasBlueprintLibrary = value == 1;
                    break;
                }
                case 4: {
                    CyberwareWorkbenchMenu.this.blueprintCurrentPage = value;
                    CyberwareWorkbenchMenu.this.updateSlotPositions();
                    break;
                }
                case 5: {
                    CyberwareWorkbenchMenu.this.blueprintMaxPages = value;
                }
            }
        }
    };

    public CyberwareWorkbenchMenu(int pContainerId, Inventory inv, FriendlyByteBuf extraData) {
        this(pContainerId, inv, inv.f_35978_.m_9236_().m_7702_(extraData.m_130135_()));
    }

    public CyberwareWorkbenchMenu(int pContainerId, Inventory inv, BlockEntity entity) {
        super((MenuType)ModMenuTypes.CYBERWARE_WORKBENCH_MENU.get(), pContainerId);
        this.blockEntity = (CyberwareWorkbenchBlockEntity)entity;
        this.level = inv.f_35978_.m_9236_();
        this.blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> {
            this.m_38897_((Slot)new SlotItemHandler(handler, 0, 15, 20));
            this.m_38897_((Slot)new SlotItemHandler(handler, 1, 15, 53));
            this.m_38897_((Slot)new SlotItemHandler(handler, 2, 115, 53));
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 2; ++j) {
                    this.m_38897_((Slot)new SlotItemHandler(handler, 3 + (i * 2 + j), 71 + j * 18, 17 + i * 18));
                }
            }
            this.m_38897_((Slot)new SlotItemHandler(handler, 9, 141, 21));
        });
        this.findAndAddExternalInventory();
        this.findAndAddBlueprintLibrary();
        this.m_38884_(this.pageData);
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        this.updateSlotPositions();
    }

    private void findAndAddExternalInventory() {
        BlockPos center = this.blockEntity.m_58899_();
        ArrayList<ComponentBoxBlockEntity> foundBoxes = new ArrayList<ComponentBoxBlockEntity>();
        for (int x = -3; x <= 3; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -3; z <= 3; ++z) {
                    BlockEntity targetBe;
                    if (x == 0 && y == 0 && z == 0 || !((targetBe = this.level.m_7702_(center.m_7918_(x, y, z))) instanceof ComponentBoxBlockEntity)) continue;
                    ComponentBoxBlockEntity box = (ComponentBoxBlockEntity)targetBe;
                    foundBoxes.add(box);
                }
            }
        }
        if (!foundBoxes.isEmpty()) {
            this.hasExtendedInventory = true;
            this.maxPages = foundBoxes.size();
            for (ComponentBoxBlockEntity box : foundBoxes) {
                ArrayList currentBoxSlots = new ArrayList();
                box.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> {
                    for (int row = 0; row < 6; ++row) {
                        for (int col = 0; col < 3; ++col) {
                            int index = col + row * 3;
                            if (index >= handler.getSlots()) continue;
                            SlotItemHandler slot = new SlotItemHandler(handler, index, -10000, -10000);
                            this.m_38897_((Slot)slot);
                            currentBoxSlots.add(slot);
                        }
                    }
                });
                this.pageSlots.add(currentBoxSlots);
            }
        }
    }

    private void findAndAddBlueprintLibrary() {
        BlockPos center = this.blockEntity.m_58899_();
        ArrayList<BlueprintChestBlockEntity> foundChests = new ArrayList<BlueprintChestBlockEntity>();
        for (int x = -3; x <= 3; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -3; z <= 3; ++z) {
                    BlockEntity targetBe;
                    if (x == 0 && y == 0 && z == 0 || !((targetBe = this.level.m_7702_(center.m_7918_(x, y, z))) instanceof BlueprintChestBlockEntity)) continue;
                    BlueprintChestBlockEntity chest = (BlueprintChestBlockEntity)targetBe;
                    foundChests.add(chest);
                }
            }
        }
        if (!foundChests.isEmpty()) {
            this.hasBlueprintLibrary = true;
            this.blueprintMaxPages = foundChests.size();
            for (BlueprintChestBlockEntity chest : foundChests) {
                ArrayList currentChestSlots = new ArrayList();
                chest.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> {
                    for (int row = 0; row < 6; ++row) {
                        for (int col = 0; col < 3; ++col) {
                            int index = col + row * 3;
                            if (index >= 18 || index >= handler.getSlots()) continue;
                            SlotItemHandler slot = new SlotItemHandler((IItemHandler)handler, index, -10000, -10000){

                                public boolean m_5857_(@NotNull ItemStack stack) {
                                    return stack.m_41720_() instanceof BlueprintItem;
                                }
                            };
                            this.m_38897_((Slot)slot);
                            currentChestSlots.add(slot);
                        }
                    }
                });
                this.blueprintPageSlots.add(currentChestSlots);
            }
        }
    }

    public void m_7511_(int id, int data) {
        super.m_7511_(id, data);
    }

    public void changePage(int direction) {
        int newPage = this.currentPage + direction;
        if (newPage >= 0 && newPage < this.maxPages) {
            this.currentPage = newPage;
            this.pageData.m_8050_(0, newPage);
        }
    }

    public void changeBlueprintPage(int direction) {
        int newPage = this.blueprintCurrentPage + direction;
        if (newPage >= 0 && newPage < this.blueprintMaxPages) {
            this.blueprintCurrentPage = newPage;
            this.pageData.m_8050_(4, newPage);
        }
    }

    public void setExtendedOpen(boolean open) {
        this.isExtendedOpen = open;
        this.pageData.m_8050_(2, open ? 1 : 0);
    }

    private void updateSlotPositions() {
        int startY = 18;
        int leftStartX = -51;
        for (int i = 0; i < this.pageSlots.size(); ++i) {
            List<Slot> slots = this.pageSlots.get(i);
            boolean isVisible = i == this.currentPage && this.isExtendedOpen;
            this.layoutSlots(slots, isVisible, leftStartX, startY);
        }
        int rightStartX = 181;
        for (int i = 0; i < this.blueprintPageSlots.size(); ++i) {
            List<Slot> slots = this.blueprintPageSlots.get(i);
            boolean isVisible = i == this.blueprintCurrentPage && this.isExtendedOpen && this.hasBlueprintLibrary;
            this.layoutSlots(slots, isVisible, rightStartX, 18);
        }
    }

    private void layoutSlots(List<Slot> slots, boolean isVisible, int startX, int startY) {
        for (int row = 0; row < 6; ++row) {
            for (int col = 0; col < 3; ++col) {
                int index = col + row * 3;
                if (index >= slots.size()) continue;
                Slot slot = slots.get(index);
                if (isVisible) {
                    slot.f_40220_ = startX + col * 18;
                    slot.f_40221_ = startY + row * 18;
                    continue;
                }
                slot.f_40220_ = -10000;
                slot.f_40221_ = -10000;
            }
        }
    }

    public int getCurrentPage() {
        return this.pageData.m_6413_(0);
    }

    public int getMaxPages() {
        return this.pageData.m_6413_(1);
    }

    public int getBlueprintCurrentPage() {
        return this.pageData.m_6413_(4);
    }

    public int getBlueprintMaxPages() {
        return this.pageData.m_6413_(5);
    }

    public ItemStack m_7648_(Player playerIn, int pIndex) {
        int LIB_END;
        int EXT_END;
        int WB_END;
        Slot sourceSlot = (Slot)this.f_38839_.get(pIndex);
        if (sourceSlot == null || !sourceSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack sourceStack = sourceSlot.m_7993_();
        ItemStack copyOfSourceStack = sourceStack.m_41777_();
        int totalSlots = this.f_38839_.size();
        int EXT_START = WB_END = 10;
        int leftCount = this.pageSlots.stream().mapToInt(List::size).sum();
        int LIB_START = EXT_END = EXT_START + leftCount;
        int rightCount = this.blueprintPageSlots.stream().mapToInt(List::size).sum();
        int PLAYER_START = LIB_END = LIB_START + rightCount;
        int PLAYER_END = totalSlots;
        if (pIndex < PLAYER_START) {
            if (!this.m_38903_(sourceStack, PLAYER_START, PLAYER_END, true)) {
                return ItemStack.f_41583_;
            }
        } else if (pIndex >= PLAYER_START && pIndex < PLAYER_END) {
            boolean moved = false;
            if (sourceStack.m_41720_() instanceof BlueprintItem) {
                if (this.m_38903_(sourceStack, 2, 3, false)) {
                    moved = true;
                } else if (this.hasBlueprintLibrary && rightCount > 0 && this.m_38903_(sourceStack, LIB_START, LIB_END, false)) {
                    moved = true;
                }
            } else if (sourceStack.m_41720_() instanceof ICyberware) {
                if (this.m_38903_(sourceStack, 0, 1, false)) {
                    moved = true;
                } else if (this.isExtendedOpen && leftCount > 0 && this.m_38903_(sourceStack, EXT_START, EXT_END, false)) {
                    moved = true;
                }
            } else if (sourceStack.m_150930_(Items.f_42516_)) {
                if (this.m_38903_(sourceStack, 1, 2, false)) {
                    moved = true;
                }
            } else if (this.isExtendedOpen && leftCount > 0 && this.m_38903_(sourceStack, EXT_START, EXT_END, false)) {
                moved = true;
            }
            if (!moved) {
                return ItemStack.f_41583_;
            }
        }
        if (sourceStack.m_41613_() == 0) {
            sourceSlot.m_5852_(ItemStack.f_41583_);
        } else {
            sourceSlot.m_6654_();
        }
        if (sourceStack.m_41613_() == copyOfSourceStack.m_41613_()) {
            return ItemStack.f_41583_;
        }
        sourceSlot.m_142406_(playerIn, sourceStack);
        return copyOfSourceStack;
    }

    public boolean m_6875_(Player pPlayer) {
        return CyberwareWorkbenchMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.level, (BlockPos)this.blockEntity.m_58899_()), (Player)pPlayer, (Block)((Block)ModBlocks.CYBERWARE_WORKBENCH.get()));
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.m_38897_(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 84 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }
}

