/*
 * Decompiled with CFR 0.152.
 */
package com.maxwell.cyber_ware_port.common.entity;

import com.maxwell.cyber_ware_port.config.CyberwareConfig;
import com.maxwell.cyber_ware_port.init.ModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.structure.BuiltinStructures;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="cyber_ware_port", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class MobSpawnerEvents {
    @SubscribeEvent
    public static void onEntityJoin(EntityJoinLevelEvent event) {
        if (event.getLevel().m_5776_() || event.loadedFromDisk()) {
            return;
        }
        if (!event.getLevel().m_46469_().m_46207_(GameRules.f_46134_)) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof Mob)) {
            return;
        }
        Mob vanillaMob = (Mob)entity;
        ServerLevel level = (ServerLevel)event.getLevel();
        EntityType type = entity.m_6095_();
        if (type == EntityType.f_20501_) {
            double chance = (Double)CyberwareConfig.ZOMBIE_CONVERSION_CHANCE.get();
            MobSpawnerEvents.tryReplaceMob(event, level, vanillaMob, (EntityType)ModEntities.CYBER_ZOMBIE.get(), chance);
        } else if (type == EntityType.f_20524_) {
            double chance = (Double)CyberwareConfig.SKELETON_CONVERSION_CHANCE.get();
            MobSpawnerEvents.tryReplaceMob(event, level, vanillaMob, (EntityType)ModEntities.CYBER_SKELETON.get(), chance);
        } else if (type == EntityType.f_20558_) {
            double chance = (Double)CyberwareConfig.CREEPER_CONVERSION_CHANCE.get();
            MobSpawnerEvents.tryReplaceMob(event, level, vanillaMob, (EntityType)ModEntities.CYBER_CREEPER.get(), chance);
        } else if (type == EntityType.f_20497_ && MobSpawnerEvents.isInsideFortress(level, vanillaMob.m_20183_())) {
            double chance = (Double)CyberwareConfig.WITHER_CONVERSION_CHANCE.get();
            MobSpawnerEvents.tryReplaceMob(event, level, vanillaMob, (EntityType)ModEntities.CYBER_WITHER_SKELETON.get(), chance);
        }
    }

    private static void tryReplaceMob(EntityJoinLevelEvent event, ServerLevel level, Mob original, EntityType<?> newType, double chance) {
        Mob customMob;
        if ((double)level.m_213780_().m_188501_() < chance && (customMob = (Mob)newType.m_20615_((Level)level)) != null) {
            customMob.m_7678_(original.m_20185_(), original.m_20186_(), original.m_20189_(), original.m_146908_(), original.m_146909_());
            customMob.f_20883_ = original.f_20883_;
            customMob.f_20885_ = original.f_20885_;
            customMob.m_6518_((ServerLevelAccessor)level, level.m_6436_(original.m_20183_()), MobSpawnType.CONVERSION, null, null);
            level.m_7967_((Entity)customMob);
            event.setCanceled(true);
        }
    }

    private static boolean isInsideFortress(ServerLevel level, BlockPos pos) {
        return level.m_215010_().m_220488_(pos, BuiltinStructures.f_209859_).m_73603_();
    }
}

