/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.sound;

import io.github.foundationgames.automobility.entity.AutomobileEntity;
import io.github.foundationgames.automobility.sound.AutomobilitySounds;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;

public abstract class AutomobileSoundInstance
extends AbstractTickableSoundInstance {
    private final Minecraft client;
    private final AutomobileEntity automobile;
    private double lastDistance;
    private int fade = 0;
    private boolean die = false;

    public AutomobileSoundInstance(SoundEvent sound, Minecraft client, AutomobileEntity automobile) {
        super(sound, SoundSource.AMBIENT, automobile.m_20193_().m_213780_());
        this.client = client;
        this.automobile = automobile;
        this.f_119578_ = true;
        this.f_119579_ = 0;
    }

    protected abstract boolean canPlay(AutomobileEntity var1);

    protected abstract float getPitch(AutomobileEntity var1);

    protected abstract float getVolume(AutomobileEntity var1);

    public void m_7788_() {
        LocalPlayer player = this.client.f_91074_;
        if (this.automobile.m_213877_() || player == null) {
            this.m_119609_();
            return;
        }
        if (!this.canPlay(this.automobile)) {
            this.die = true;
        }
        if (this.die) {
            if (this.fade > 0) {
                --this.fade;
            } else if (this.fade == 0) {
                this.m_119609_();
                return;
            }
        } else if (this.fade < 3) {
            ++this.fade;
        }
        this.f_119573_ = this.getVolume(this.automobile) * (float)this.fade / 3.0f;
        this.f_119575_ = this.automobile.m_20185_();
        this.f_119576_ = this.automobile.m_20186_();
        this.f_119577_ = this.automobile.m_20189_();
        this.f_119574_ = this.getPitch(this.automobile);
        if (player.m_20202_() != this.automobile) {
            double distance = this.automobile.m_20182_().m_82546_(player.m_20182_()).m_82553_();
            this.f_119574_ = (float)((double)this.f_119574_ + 0.36 * Math.atan(this.lastDistance - distance));
            this.lastDistance = distance;
        } else {
            this.lastDistance = 0.0;
        }
    }

    public static class SkiddingSound
    extends AutomobileSoundInstance {
        public SkiddingSound(Minecraft client, AutomobileEntity automobile) {
            super(AutomobilitySounds.SKID.require(), client, automobile);
        }

        @Override
        protected boolean canPlay(AutomobileEntity automobile) {
            return automobile.isDrifting() || automobile.burningOut();
        }

        @Override
        protected float getPitch(AutomobileEntity automobile) {
            return automobile.burningOut() ? 0.75f : 1.0f + 0.056f * ((float)Math.min(automobile.getTurboCharge(), 115) / 115.0f);
        }

        @Override
        protected float getVolume(AutomobileEntity automobile) {
            return automobile.automobileOnGround() ? 1.0f : 0.0f;
        }
    }

    public static class EngineSound
    extends AutomobileSoundInstance {
        public EngineSound(Minecraft client, AutomobileEntity automobile) {
            super(automobile.getEngine().sound().get(), client, automobile);
        }

        @Override
        protected boolean canPlay(AutomobileEntity automobile) {
            return automobile.engineRunning();
        }

        @Override
        protected float getPitch(AutomobileEntity automobile) {
            return (float)(Math.pow(4.0, automobile.getEffectiveSpeed() - 0.9) + 0.32);
        }

        @Override
        protected float getVolume(AutomobileEntity automobile) {
            return 1.0f;
        }
    }
}

