/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.cna.content.energising;

import com.simibubi.create.AllShapes;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.antarcticgardens.cna.CNABlockEntityTypes;
import org.antarcticgardens.cna.config.CNAConfig;
import org.antarcticgardens.cna.content.energising.EnergiserBlockEntity;
import org.antarcticgardens.cna.util.StringFormatUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnergiserBlock
extends HorizontalKineticBlock
implements IBE<EnergiserBlockEntity> {
    private final int tier;

    public EnergiserBlock(BlockBehaviour.Properties properties, int tier) {
        super(properties.m_60913_(2.5f, 1.0f));
        this.tier = tier;
    }

    public static int getStrength(int tier) {
        return (int)(Math.pow(4.0, tier) * (Double)CNAConfig.getCommon().energiserSpeedMultiplier.get());
    }

    public static long getCapacity(int tier) {
        return (long)(Math.pow(10.0, tier) * 1000.0);
    }

    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        if (context instanceof EntityCollisionContext && ((EntityCollisionContext)context).m_193113_() instanceof Player) {
            return AllShapes.CASING_14PX.get(Direction.DOWN);
        }
        return AllShapes.MECHANICAL_PROCESSOR_SHAPE;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction preferredSide = this.getPreferredHorizontalFacing(context);
        if (preferredSide != null) {
            return (BlockState)this.m_49966_().m_61124_(HORIZONTAL_FACING, (Comparable)preferredSide);
        }
        return super.m_5573_(context);
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.m_61143_(HORIZONTAL_FACING)).m_122434_();
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return face.m_122434_() == ((Direction)state.m_61143_(HORIZONTAL_FACING)).m_122434_();
    }

    public Class<EnergiserBlockEntity> getBlockEntityClass() {
        return EnergiserBlockEntity.class;
    }

    public BlockEntityType<? extends EnergiserBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CNABlockEntityTypes.ENERGISER.get();
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)CreateLang.translate((String)"tooltip.create_new_age.speed", (Object[])new Object[0]).style(ChatFormatting.GRAY).component());
        tooltip.add((Component)CreateLang.text((String)" ").translate("tooltip.create_new_age.energy_per_tick", new Object[]{StringFormatUtil.formatLong(EnergiserBlock.getStrength(this.tier))}).style(ChatFormatting.AQUA).add(CreateLang.text((String)" ").translate("tooltip.create_new_age.per_rpm", new Object[]{10}).style(ChatFormatting.GRAY)).component());
        tooltip.add((Component)CreateLang.translate((String)"tooltip.create_new_age.stores", (Object[])new Object[0]).style(ChatFormatting.GRAY).component());
        tooltip.add((Component)CreateLang.text((String)" ").translate("tooltip.create_new_age.energy", new Object[]{StringFormatUtil.formatLong(EnergiserBlock.getCapacity(this.tier))}).style(ChatFormatting.AQUA).component());
    }

    public static EnergiserBlock newBasic(BlockBehaviour.Properties properties) {
        return new EnergiserBlock(properties, 1);
    }

    public static EnergiserBlock newAdvanced(BlockBehaviour.Properties properties) {
        return new EnergiserBlock(properties, 2);
    }

    public static EnergiserBlock newReinforced(BlockBehaviour.Properties properties) {
        return new EnergiserBlock(properties, 3);
    }
}

