/*
 * Decompiled with CFR 0.152.
 */
package dev.kosmx.playerAnim.core.data.quarktool;

import dev.kosmx.playerAnim.core.data.AnimationFormat;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.core.data.quarktool.PartMap;
import dev.kosmx.playerAnim.core.data.quarktool.Playable;
import dev.kosmx.playerAnim.core.data.quarktool.QuarkParsingError;
import dev.kosmx.playerAnim.core.data.quarktool.Section;
import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;

public class QuarkReader {
    private final KeyframeAnimation.AnimationBuilder emote = new KeyframeAnimation.AnimationBuilder(AnimationFormat.QUARK);
    private boolean isSuccess = false;
    private String name;
    final PartMap head;
    final PartMap torso;
    final PartMap rightLeg;
    final PartMap leftLeg;
    final PartMap rightArm;
    final PartMap leftArm;
    private Playable animation;

    public QuarkReader() {
        this.head = new PartMap(this.emote.head);
        this.torso = new PartMap(this.emote.body);
        this.rightLeg = new PartMap(this.emote.rightLeg);
        this.leftLeg = new PartMap(this.emote.leftLeg);
        this.rightArm = new PartMap(this.emote.rightArm);
        this.leftArm = new PartMap(this.emote.leftArm);
    }

    public void deserialize(BufferedReader reader, String name) throws QuarkParsingError {
        this.name = name;
        ArrayList<List<String>> strings = new ArrayList<List<String>>();
        Stream<String> stream = reader.lines();
        stream.forEach(s -> strings.add(QuarkReader.read(s.replaceAll("\t", ""))));
        int i = 0;
        while (i < strings.size()) {
            if (((List)strings.get(i)).size() == 0 || ((String)((List)strings.get(i)).get(0)).charAt(0) == '#') {
                ++i;
                continue;
            }
            i = this.getMethod((List)strings.get(i), i, strings);
        }
        if (this.animation == null) {
            throw new QuarkParsingError();
        }
        int length = this.animation.playForward(0);
        this.isSuccess = true;
        this.emote.endTick = length;
    }

    public KeyframeAnimation getEmote() {
        if (this.isSuccess) {
            return this.emote.setName("{\"color\":\"white\",\"text\":\"" + this.name + "\"}").setDescription("{\"color\":\"gray\",\"text\":\"Imported from quark\"}").build();
        }
        return null;
    }

    public static List<String> read(String s) {
        int i;
        for (i = 0; i < s.length() && s.charAt(i) == ' '; ++i) {
        }
        s = new StringBuffer(s).replace(0, i, "").toString();
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(s.split(" ")));
        list.removeIf(s1 -> s1.equals(""));
        return list;
    }

    public int getMethod(List<String> str, int i, List<List<String>> strings) throws QuarkParsingError {
        if (str.get(0).equals("name")) {
            this.name = str.get(1);
        } else if (str.get(0).equals("animation")) {
            Section anim = new Section(this, i, strings);
            this.animation = anim.getMoveOperator() == null ? anim : anim.getMoveOperator();
            return anim.getLine();
        }
        return i + 1;
    }

    public PartMap getBPFromStr(String[] inf) throws QuarkParsingError {
        if (inf.length == 2) {
            if (inf[0].equals("body")) {
                return this.torso;
            }
            if (inf[0].equals("head")) {
                return this.head;
            }
            throw new QuarkParsingError();
        }
        if (inf.length == 3) {
            if (inf[0].equals("right")) {
                if (inf[1].equals("arm")) {
                    return this.rightArm;
                }
                if (inf[1].equals("leg")) {
                    return this.rightLeg;
                }
                throw new QuarkParsingError();
            }
            if (inf[0].equals("left")) {
                if (inf[1].equals("arm")) {
                    return this.leftArm;
                }
                if (inf[1].equals("leg")) {
                    return this.leftLeg;
                }
                throw new QuarkParsingError();
            }
            throw new QuarkParsingError();
        }
        throw new QuarkParsingError();
    }

    public PartMap.PartValue getPFromStr(String str) throws QuarkParsingError {
        String[] inf = str.split("_");
        return this.getPFromStrHelper(inf[inf.length - 1], this.getBPFromStr(inf));
    }

    private PartMap.PartValue getPFromStrHelper(String string, PartMap part) throws QuarkParsingError {
        if (string.equals("x")) {
            return part.x;
        }
        if (string.equals("y")) {
            return part.y;
        }
        if (string.equals("z")) {
            return part.z;
        }
        throw new QuarkParsingError();
    }
}

