/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.client.api.color;

import com.blackgear.vanillabackport.client.api.color.DryFoliageColor;
import com.blackgear.vanillabackport.client.resources.LeafColorReloadListener;
import com.blackgear.vanillabackport.common.registries.ModBiomes;
import com.blackgear.vanillabackport.core.mixin.access.BiomeAccessor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockTintCache;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LeafColors {
    private static final Map<Predicate<Holder<Biome>>, Integer> COLOR_MAP = new ConcurrentHashMap<Predicate<Holder<Biome>>, Integer>();
    public static final ColorResolver DRY_FOLIAGE_COLOR_RESOLVER = (biome, d, e) -> {
        Biome.ClimateSettings settings = ((BiomeAccessor)biome).getClimateSettings();
        double temperature = Mth.m_14036_((float)settings.f_47681_(), (float)0.0f, (float)1.0f);
        double humidity = Mth.m_14036_((float)settings.f_47683_(), (float)0.0f, (float)1.0f);
        return DryFoliageColor.get(temperature, humidity);
    };

    public static int getAverageDryFoliageColor(BlockPos pos) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null) {
            Holder biome = level.m_204166_(pos);
            return COLOR_MAP.entrySet().stream().filter(entry -> ((Predicate)entry.getKey()).test(biome)).findFirst().map(Map.Entry::getValue).orElseGet(() -> new BlockTintCache(value -> level.m_104762_(value, DRY_FOLIAGE_COLOR_RESOLVER)).m_193812_(pos));
        }
        return -10732494;
    }

    public static int getClientLeafTintColor(BlockPos pos) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return 0;
        }
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        if (LeafColorReloadListener.hasCustomColor(block)) {
            return LeafColorReloadListener.getCustomColor(block);
        }
        return Minecraft.m_91087_().m_91298_().m_92577_(state, (BlockAndTintGetter)level, pos, 0);
    }

    static {
        COLOR_MAP.put(holder -> holder.m_203565_(ModBiomes.PALE_GARDEN), 10528412);
        COLOR_MAP.put(holder -> holder.m_203565_(Biomes.f_48151_), 8082228);
        COLOR_MAP.put(holder -> holder.m_203565_(Biomes.f_48207_), 8082228);
        COLOR_MAP.put(holder -> holder.m_203565_(Biomes.f_220595_), 8082228);
    }
}

