/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.client.level.entities.model;

import com.blackgear.vanillabackport.client.level.entities.animation.ArmadilloAnimation;
import com.blackgear.vanillabackport.common.level.entities.armadillo.Armadillo;
import net.minecraft.client.model.AgeableHierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ArmadilloModel
extends AgeableHierarchicalModel<Armadillo> {
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart rightHindLeg;
    private final ModelPart leftHindLeg;
    private final ModelPart cube;
    private final ModelPart head;
    private final ModelPart tail;

    public ArmadilloModel(ModelPart root) {
        super(0.6f, 16.02f);
        this.root = root;
        this.body = root.m_171324_("body");
        this.rightHindLeg = root.m_171324_("right_hind_leg");
        this.leftHindLeg = root.m_171324_("left_hind_leg");
        this.head = this.body.m_171324_("head");
        this.tail = this.body.m_171324_("tail");
        this.cube = root.m_171324_("cube");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.m_171576_();
        PartDefinition body = root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 20).m_171488_(-4.0f, -7.0f, -10.0f, 8.0f, 8.0f, 12.0f, new CubeDeformation(0.3f)).m_171514_(0, 40).m_171488_(-4.0f, -7.0f, -10.0f, 8.0f, 8.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)21.0f, (float)4.0f));
        body.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(44, 53).m_171488_(-0.5f, -0.0865f, 0.0933f, 1.0f, 6.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-3.0f, (float)1.0f, (float)0.5061f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)-11.0f));
        head.m_171599_("head_cube", CubeListBuilder.m_171558_().m_171514_(43, 15).m_171488_(-1.5f, -1.0f, -1.0f, 3.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition rightEar = head.m_171599_("right_ear", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-1.0f, (float)-1.0f, (float)0.0f));
        rightEar.m_171599_("right_ear_cube", CubeListBuilder.m_171558_().m_171514_(43, 10).m_171488_(-2.0f, -3.0f, 0.0f, 2.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.5f, (float)0.0f, (float)-0.6f, (float)0.1886f, (float)-0.3864f, (float)-0.0718f));
        PartDefinition leftEar = head.m_171599_("left_ear", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)1.0f, (float)-2.0f, (float)0.0f));
        leftEar.m_171599_("left_ear_cube", CubeListBuilder.m_171558_().m_171514_(47, 10).m_171488_(0.0f, -3.0f, 0.0f, 2.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.5f, (float)1.0f, (float)-0.6f, (float)0.1886f, (float)0.3864f, (float)0.0718f));
        root.m_171599_("right_hind_leg", CubeListBuilder.m_171558_().m_171514_(51, 31).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)21.0f, (float)4.0f));
        root.m_171599_("left_hind_leg", CubeListBuilder.m_171558_().m_171514_(42, 31).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)21.0f, (float)4.0f));
        root.m_171599_("right_front_leg", CubeListBuilder.m_171558_().m_171514_(51, 43).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)21.0f, (float)-4.0f));
        root.m_171599_("left_front_leg", CubeListBuilder.m_171558_().m_171514_(42, 43).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)21.0f, (float)-4.0f));
        root.m_171599_("cube", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-5.0f, -10.0f, -6.0f, 10.0f, 10.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)64);
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public void setupAnim(Armadillo entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        if (entity.shouldHideInShell()) {
            this.body.f_233556_ = true;
            this.leftHindLeg.f_104207_ = false;
            this.rightHindLeg.f_104207_ = false;
            this.tail.f_104207_ = false;
            this.cube.f_104207_ = true;
        } else {
            this.body.f_233556_ = false;
            this.leftHindLeg.f_104207_ = true;
            this.rightHindLeg.f_104207_ = true;
            this.tail.f_104207_ = true;
            this.cube.f_104207_ = false;
            this.head.f_104203_ = Mth.m_14036_((float)headPitch, (float)-22.5f, (float)25.0f) * ((float)Math.PI / 180);
            this.head.f_104204_ = Mth.m_14036_((float)netHeadYaw, (float)-32.5f, (float)32.5f) * ((float)Math.PI / 180);
        }
        this.m_267799_(ArmadilloAnimation.ARMADILLO_WALK, limbSwing, limbSwingAmount, 16.5f, 2.5f);
        this.m_233385_(entity.rollOutAnimationState, ArmadilloAnimation.ARMADILLO_ROLL_OUT, ageInTicks, 1.0f);
        this.m_233385_(entity.rollUpAnimationState, ArmadilloAnimation.ARMADILLO_ROLL_UP, ageInTicks, 1.0f);
        this.m_233385_(entity.peekAnimationState, ArmadilloAnimation.ARMADILLO_PEEK, ageInTicks, 1.0f);
    }
}

