/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.client.resources;

import com.blackgear.vanillabackport.core.VanillaBackport;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class LeafColorReloadListener
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Map<Block, Properties> CUSTOM_COLORS = new ConcurrentHashMap<Block, Properties>();
    public static final LeafColorReloadListener INSTANCE = new LeafColorReloadListener();

    public LeafColorReloadListener() {
        super(GSON, "leaf_colors");
    }

    protected void apply(Map<ResourceLocation, JsonElement> resources, ResourceManager resourceManager, ProfilerFiller profiler) {
        HashMap<Block, Map> blockEntries = new HashMap<Block, Map>();
        int skippedCount = 0;
        for (Map.Entry<ResourceLocation, JsonElement> entry : resources.entrySet()) {
            JsonElement element = entry.getValue();
            if (!element.isJsonObject()) continue;
            JsonObject object = element.getAsJsonObject();
            if (!object.has("block") || !object.has("properties")) {
                ++skippedCount;
                continue;
            }
            String blockId = object.get("block").getAsString();
            ResourceLocation blockLocation = ResourceLocation.m_135820_((String)blockId);
            if (blockLocation == null || !BuiltInRegistries.f_256975_.m_7804_(blockLocation)) {
                ++skippedCount;
                continue;
            }
            JsonObject properties = object.getAsJsonObject("properties");
            if (!properties.has("color")) {
                ++skippedCount;
                continue;
            }
            Block block3 = (Block)BuiltInRegistries.f_256975_.m_7745_(blockLocation);
            int color = properties.get("color").getAsInt();
            int priority = properties.has("priority") ? properties.get("priority").getAsInt() : 0;
            blockEntries.computeIfAbsent(block3, k -> new HashMap()).put(entry.getKey(), new Properties(color, priority));
        }
        CUSTOM_COLORS.clear();
        for (Map.Entry<Object, Object> entry : blockEntries.entrySet()) {
            Block block2 = (Block)entry.getKey();
            Properties selectedEntry = LeafColorReloadListener.getColorProperties(entry);
            if (selectedEntry == null) continue;
            CUSTOM_COLORS.put(block2, selectedEntry);
        }
        for (Map.Entry<Object, Object> entry : CUSTOM_COLORS.entrySet()) {
            int maxPriority;
            Block block2 = (Block)entry.getKey();
            Properties finalProps = (Properties)entry.getValue();
            Map allEntries = (Map)blockEntries.get(block2);
            if (allEntries == null || allEntries.size() <= 1 || finalProps.priority == (maxPriority = allEntries.values().stream().mapToInt(p -> p.priority).max().orElse(0))) continue;
            Properties correctEntry = allEntries.values().stream().filter(p -> p.priority == maxPriority).findFirst().orElse(finalProps);
            CUSTOM_COLORS.put(block2, correctEntry);
        }
        if (skippedCount > 0) {
            VanillaBackport.LOGGER.info("Skipping {} leaf color(s).", (Object)skippedCount);
        }
        if (!CUSTOM_COLORS.isEmpty()) {
            VanillaBackport.LOGGER.info("Loaded {} custom leaf colors: {}", (Object)CUSTOM_COLORS.size(), CUSTOM_COLORS.keySet().stream().map(block -> BuiltInRegistries.f_256975_.m_7981_(block).toString()).sorted().toList());
        }
    }

    @Nullable
    private static Properties getColorProperties(Map.Entry<Block, Map<ResourceLocation, Properties>> blockEntry) {
        Map<ResourceLocation, Properties> entries = blockEntry.getValue();
        Properties selectedEntry = null;
        int highestPriority = Integer.MIN_VALUE;
        for (Map.Entry<ResourceLocation, Properties> entry : entries.entrySet()) {
            Properties props = entry.getValue();
            if (props.priority <= highestPriority) continue;
            highestPriority = props.priority;
            selectedEntry = props;
        }
        return selectedEntry;
    }

    public static int getCustomColor(Block block) {
        Properties entry = CUSTOM_COLORS.get(block);
        return entry != null ? entry.color : 0;
    }

    public static boolean hasCustomColor(Block block) {
        return CUSTOM_COLORS.containsKey(block);
    }

    private record Properties(int color, int priority) {
    }
}

