/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.common.level.entities.happyghast;

import com.blackgear.vanillabackport.client.registries.ModSoundEvents;
import com.blackgear.vanillabackport.common.api.leash.Leashable;
import com.blackgear.vanillabackport.common.level.entities.happyghast.HappyGhastAi;
import com.blackgear.vanillabackport.common.level.entities.happyghast.HappyGhastTemptGoal;
import com.blackgear.vanillabackport.common.registries.ModEntities;
import com.blackgear.vanillabackport.core.VanillaBackport;
import com.blackgear.vanillabackport.core.data.tags.ModBlockTags;
import com.blackgear.vanillabackport.core.data.tags.ModItemTags;
import com.blackgear.vanillabackport.core.mixin.access.LivingEntityAccessor;
import com.blackgear.vanillabackport.core.util.BlockPosUtils;
import com.blackgear.vanillabackport.core.util.CollisionUtils;
import com.mojang.serialization.Dynamic;
import java.util.EnumSet;
import java.util.function.BooleanSupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PlayerRideable;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class HappyGhast
extends Animal
implements PlayerRideable,
Leashable {
    public static final Ingredient IS_FOOD = Ingredient.m_204132_(ModItemTags.HAPPY_GHAST_FOOD);
    private int leashHolderTime = 0;
    private int serverStillTimeout;
    private static final EntityDataAccessor<Boolean> IS_LEASH_HOLDER = SynchedEntityData.m_135353_(HappyGhast.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> STAYS_STILL = SynchedEntityData.m_135353_(HappyGhast.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private boolean requiresPrecisePosition;
    private static final Vec3[] PASSENGER_ATTACHMENTS = new Vec3[]{new Vec3(0.0, 3.75, 1.8), new Vec3(-1.8, 3.75, 0.0), new Vec3(0.0, 3.75, -1.8), new Vec3(1.8, 3.75, 0.0)};

    public HappyGhast(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
        this.f_21342_ = new GhastMoveControl(this, true, this::isOnStillTimeout);
        this.f_21365_ = new HappyGhastLookControl();
    }

    private void setServerStillTimeout(int timeout) {
        this.serverStillTimeout = timeout;
        this.syncStayStillFlag();
    }

    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return 2.6f * this.m_6134_();
    }

    private PathNavigation createBabyNavigation(Level level) {
        return new BabyFlyingPathNavigation((Mob)this, level);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(3, (Goal)new GhastFloatGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new HappyGhastTemptGoal(this, 1.0, stack -> !this.isHarnessed() && !this.m_6162_() ? stack.m_204117_(ModItemTags.HAPPY_GHAST_TEMPT_ITEMS) : IS_FOOD.test(stack), false, 7.0));
        this.f_21345_.m_25352_(5, (Goal)new RandomFloatAroundGoal(this, 16));
    }

    private void adultGhastSetup() {
        this.f_21342_ = new GhastMoveControl(this, true, this::isOnStillTimeout);
        this.f_21365_ = new HappyGhastLookControl();
        this.f_21344_ = this.m_6037_(this.m_9236_());
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            this.m_262441_(goal -> true);
            this.m_8099_();
            this.m_6274_().m_21933_(server, (LivingEntity)this);
            this.f_20939_.m_276084_();
        }
    }

    private void babyGhastSetup() {
        this.f_21342_ = new FlyingMoveControl((Mob)this, 180, true);
        this.f_21365_ = new LookControl((Mob)this);
        this.f_21344_ = this.createBabyNavigation(this.m_9236_());
        this.setServerStillTimeout(0);
        this.m_262441_(goal -> true);
    }

    protected void m_30232_() {
        if (this.m_6162_()) {
            this.babyGhastSetup();
        } else {
            this.adultGhastSetup();
        }
        super.m_30232_();
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.m_21183_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22280_, 0.05).m_22268_(Attributes.f_22279_, 0.05).m_22268_(Attributes.f_22277_, 16.0);
    }

    public boolean getRequiresPrecisePosition() {
        return this.requiresPrecisePosition;
    }

    public void setRequiresPrecisePosition(boolean requiresPrecisePosition) {
        this.requiresPrecisePosition = requiresPrecisePosition;
    }

    public void stopInPlace() {
        this.m_21573_().m_26573_();
        this.m_21570_(0.0f);
        this.m_21567_(0.0f);
        this.m_7910_(0.0f);
        this.m_20334_(0.0, 0.0, 0.0);
        this.vb$setAngularMomentum(0.0);
    }

    protected void m_7840_(double y, boolean onGround, BlockState state, BlockPos pos) {
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.isOnStillTimeout()) {
            this.m_20256_(Vec3.f_82478_);
            return;
        }
        float speed = (float)this.m_21133_(Attributes.f_22280_) * 5.0f / 3.0f;
        if (this.m_6109_()) {
            if (this.m_20069_()) {
                this.m_19920_(speed, travelVector);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_((double)0.8f));
            } else if (this.m_20077_()) {
                this.m_19920_(speed, travelVector);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_(0.5));
            } else {
                this.m_19920_(speed, travelVector);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_((double)0.91f));
            }
        }
        this.m_267651_(false);
    }

    public boolean m_6147_() {
        return false;
    }

    public float m_5610_(BlockPos pos, LevelReader level) {
        if (!level.m_46859_(pos)) {
            return 0.0f;
        }
        return level.m_46859_(pos.m_7495_()) && !level.m_46859_(pos.m_6625_(2)) ? 10.0f : 5.0f;
    }

    public boolean m_6040_() {
        return this.m_6162_() || super.m_6040_();
    }

    protected boolean m_213814_() {
        return false;
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
    }

    public float m_6100_() {
        return 1.0f;
    }

    public int m_8100_() {
        int interval = super.m_8100_();
        return this.m_20160_() ? interval * 6 : interval;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return this.m_6162_() ? ModSoundEvents.GHASTLING_AMBIENT.get() : ModSoundEvents.HAPPY_GHAST_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource source) {
        return this.m_6162_() ? ModSoundEvents.GHASTLING_HURT.get() : ModSoundEvents.HAPPY_GHAST_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return this.m_6162_() ? ModSoundEvents.GHASTLING_DEATH.get() : ModSoundEvents.HAPPY_GHAST_DEATH.get();
    }

    public int m_5792_() {
        return 1;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob mate) {
        return (AgeableMob)ModEntities.HAPPY_GHAST.get().m_20615_((Level)level);
    }

    public boolean m_5957_() {
        return false;
    }

    public float m_6134_() {
        return this.m_6162_() ? 0.2375f : 1.0f;
    }

    public boolean m_6898_(ItemStack stack) {
        return IS_FOOD.test(stack);
    }

    public void equipHarness() {
        this.m_9236_().m_6269_(null, (Entity)this, ModSoundEvents.HARNESS_EQUIP.get(), SoundSource.NEUTRAL, 0.5f, 1.0f);
    }

    public boolean canBeHarnessed() {
        return this.m_6084_() && !this.m_6162_();
    }

    public boolean isHarnessed() {
        return this.m_6844_(EquipmentSlot.CHEST).m_204117_(ModItemTags.HARNESSES);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        InteractionResult result;
        if (this.m_6162_()) {
            return super.m_6071_(player, hand);
        }
        ItemStack stack = player.m_21120_(hand);
        if (!stack.m_41619_() && (result = stack.m_41647_(player, (LivingEntity)this, hand)).m_19077_()) {
            return result;
        }
        if (!stack.m_150930_(Items.f_42574_) || this.m_20160_() || !this.isHarnessed() && !player.m_7500_()) {
            if (this.isHarnessed()) {
                if (!this.m_9236_().m_5776_()) {
                    player.m_20329_((Entity)this);
                }
                return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
            }
            return super.m_6071_(player, hand);
        }
        stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
        this.m_216990_(ModSoundEvents.HARNESS_UNEQUIP.get());
        ItemStack harness = this.m_6844_(EquipmentSlot.CHEST);
        this.m_8061_(EquipmentSlot.CHEST, ItemStack.f_41583_);
        this.m_5552_(harness, this.m_20206_() + 0.5f);
        return InteractionResult.SUCCESS;
    }

    public AABB m_6921_() {
        AABB box = super.m_6921_();
        float height = this.m_20206_();
        return box.m_165887_(box.f_82289_ - (double)(height / 2.0f));
    }

    protected void m_19956_(Entity passenger, Entity.MoveFunction callback) {
        if (this.m_20363_(passenger)) {
            double baseY = this.m_20186_() + passenger.m_6049_();
            int idx = Math.min(this.m_20197_().indexOf(passenger), PASSENGER_ATTACHMENTS.length - 1);
            Vec3 offset = PASSENGER_ATTACHMENTS[idx].m_82524_(-this.m_146908_() * ((float)Math.PI / 180));
            callback.m_20372_(passenger, this.m_20185_() + offset.f_82479_, baseY + offset.f_82480_, this.m_20189_() + offset.f_82481_);
        }
    }

    protected void m_20348_(Entity passenger) {
        if (!this.m_20160_()) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), ModSoundEvents.HARNESS_GOGGLES_DOWN.get(), this.m_5720_(), 1.0f, 1.0f);
        }
        super.m_20348_(passenger);
        if (!this.m_9236_().f_46443_) {
            if (!this.scanPlayerAboveGhast()) {
                this.setServerStillTimeout(0);
            } else if (this.serverStillTimeout > 10) {
                this.setServerStillTimeout(10);
            }
        }
    }

    protected void m_20351_(Entity passenger) {
        super.m_20351_(passenger);
        if (!this.m_9236_().f_46443_) {
            this.setServerStillTimeout(10);
        }
        if (!this.m_20160_()) {
            this.m_147271_();
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), ModSoundEvents.HARNESS_GOGGLES_UP.get(), this.m_5720_(), 1.0f, 1.0f);
        }
    }

    protected boolean m_7310_(Entity passenger) {
        return this.m_20197_().size() < 4;
    }

    @Nullable
    public LivingEntity m_6688_() {
        LivingEntity livingEntity;
        Entity entity;
        if (this.isHarnessed() && !this.isOnStillTimeout() && (entity = this.m_146895_()) instanceof Player) {
            Player player = (Player)entity;
            livingEntity = player;
        } else {
            livingEntity = super.m_6688_();
        }
        return livingEntity;
    }

    protected Vec3 m_274312_(Player player, Vec3 travelVector) {
        float forward = player.f_20900_;
        float strafe = 0.0f;
        float upward = 0.0f;
        if (player.f_20902_ != 0.0f) {
            float xOffset = Mth.m_14089_((float)(player.m_146909_() * ((float)Math.PI / 180)));
            float zOffset = -Mth.m_14031_((float)(player.m_146909_() * ((float)Math.PI / 180)));
            if (player.f_20902_ < 0.0f) {
                xOffset *= -0.5f;
                zOffset *= -0.5f;
            }
            upward = zOffset;
            strafe = xOffset;
        }
        if (((LivingEntityAccessor)player).isJumping()) {
            upward += 0.5f;
        }
        return new Vec3((double)forward, (double)upward, (double)strafe).m_82490_((double)3.9f * this.m_21133_(Attributes.f_22280_) * (Double)VanillaBackport.COMMON_CONFIG.happyGhastSpeedModifier.get());
    }

    protected Vec2 getRiddenRotation(LivingEntity livingEntity) {
        return new Vec2(livingEntity.m_146909_() * 0.5f, livingEntity.m_146908_());
    }

    protected void m_274498_(Player player, Vec3 vec3) {
        super.m_274498_(player, vec3);
        Vec2 riddenRotation = this.getRiddenRotation((LivingEntity)player);
        float yRot = this.m_146908_();
        float degrees = Mth.m_14177_((float)(riddenRotation.f_82471_ - yRot));
        this.m_19915_(yRot += degrees * 0.08f, riddenRotation.f_82470_);
        this.f_20883_ = this.f_20885_ = yRot;
        this.f_19859_ = this.f_20885_;
    }

    protected Brain.Provider<HappyGhast> m_5490_() {
        return HappyGhastAi.brainProvider();
    }

    protected Brain<?> m_8075_(Dynamic<?> dynamic) {
        return HappyGhastAi.makeBrain((Brain<HappyGhast>)this.m_5490_().m_22073_(dynamic));
    }

    public Brain<HappyGhast> m_6274_() {
        return super.m_6274_();
    }

    protected void m_8024_() {
        if (this.m_6162_()) {
            ProfilerFiller profiler = this.m_9236_().m_46473_();
            profiler.m_6180_("happyGhastBrain");
            this.m_6274_().m_21865_((ServerLevel)this.m_9236_(), (LivingEntity)this);
            profiler.m_6182_("HappyGhastActivityUpdate");
            HappyGhastAi.updateActivity(this);
            profiler.m_7238_();
        }
        this.checkRestriction();
        super.m_8024_();
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_()) {
            if (this.leashHolderTime > 0) {
                --this.leashHolderTime;
            }
            this.setLeashHolder(this.leashHolderTime > 0);
            if (this.serverStillTimeout > 0) {
                if (this.f_19797_ > 60) {
                    --this.serverStillTimeout;
                }
                this.setServerStillTimeout(this.serverStillTimeout);
            }
            if (this.scanPlayerAboveGhast()) {
                this.setServerStillTimeout(10);
            }
        }
    }

    public void m_8107_() {
        if (!this.m_9236_().f_46443_) {
            this.setRequiresPrecisePosition(this.isOnStillTimeout());
        }
        super.m_8107_();
        this.continuousHeal();
    }

    private int getHappyGhastRestrictionRadius() {
        return !this.m_6162_() && !this.isHarnessed() ? 64 : 32;
    }

    private void checkRestriction() {
        if (!this.m_21523_() && !this.m_20160_()) {
            int i = this.getHappyGhastRestrictionRadius();
            if (!this.m_21536_() || !this.m_21534_().m_123314_((Vec3i)this.m_20183_(), (double)(i + 16)) || (float)i != this.m_21535_()) {
                this.m_21446_(this.m_20183_(), i);
            }
        }
    }

    private void continuousHeal() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            boolean canHeal;
            ServerLevel server = (ServerLevel)level;
            if (this.m_6084_() && this.f_20919_ == 0 && this.m_21233_() != this.m_21223_() && this.f_19797_ % ((canHeal = server.m_6042_().f_63858_() && (this.isInClouds() || this.precipitationAt(this.m_20183_()) != Biome.Precipitation.NONE)) ? 20 : 600) == 0) {
                this.m_5634_(1.0f);
            }
        }
    }

    private Biome.Precipitation precipitationAt(BlockPos pos) {
        if (!this.m_9236_().m_46471_()) {
            return Biome.Precipitation.NONE;
        }
        if (!this.m_9236_().m_45527_(pos)) {
            return Biome.Precipitation.NONE;
        }
        if (this.m_9236_().m_5452_(Heightmap.Types.MOTION_BLOCKING, pos).m_123342_() > pos.m_123342_()) {
            return Biome.Precipitation.NONE;
        }
        Biome biome = (Biome)this.m_9236_().m_204166_(pos).m_203334_();
        return biome.m_264600_(pos);
    }

    private boolean isInClouds() {
        if (this.m_9236_().m_6042_().f_63858_()) {
            int cloudHeight = 192;
            if (this.m_20186_() + (double)this.m_20206_() < (double)cloudHeight) {
                return false;
            }
            int cloudRange = cloudHeight + 4;
            return this.m_20186_() <= (double)cloudRange;
        }
        return false;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_LEASH_HOLDER, (Object)false);
        this.f_19804_.m_135372_(STAYS_STILL, (Object)false);
    }

    private void setLeashHolder(boolean holder) {
        this.f_19804_.m_135381_(IS_LEASH_HOLDER, (Object)holder);
    }

    public boolean isLeashHolder() {
        return (Boolean)this.f_19804_.m_135370_(IS_LEASH_HOLDER);
    }

    private void syncStayStillFlag() {
        this.f_19804_.m_135381_(STAYS_STILL, (Object)(this.serverStillTimeout > 0 ? 1 : 0));
    }

    public boolean staysStill() {
        return (Boolean)this.f_19804_.m_135370_(STAYS_STILL);
    }

    @Override
    public boolean vb$supportQuadLeashAsHolder() {
        return true;
    }

    @Override
    public Vec3[] vb$getQuadLeashHolderOffsets() {
        return Leashable.vb$createQuadLeashOffsets((Entity)this, -0.03125, 0.4375, 0.46875, 0.03125);
    }

    protected Vec3 m_7939_() {
        return Vec3.f_82478_;
    }

    @Override
    public double vb$leashElasticDistance() {
        return 10.0;
    }

    @Override
    public double vb$leashSnapDistance() {
        return 16.0;
    }

    @Override
    public void vb$onElasticLeashPull(Entity entity) {
        Leashable.super.vb$onElasticLeashPull(entity);
        this.m_21566_().f_24981_ = MoveControl.Operation.WAIT;
    }

    @Override
    public void vb$notifyLeashHolder(Leashable entity) {
        if (entity.vb$supportQuadLeash()) {
            this.leashHolderTime = 5;
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("still_timeout", this.serverStillTimeout);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setServerStillTimeout(compound.m_128451_("still_timeout"));
    }

    public boolean isOnStillTimeout() {
        return this.staysStill() || this.serverStillTimeout > 0;
    }

    private boolean scanPlayerAboveGhast() {
        AABB box = this.m_20191_();
        AABB topSurface = new AABB(box.f_82288_ - 1.0, box.f_82292_, box.f_82290_ - 1.0, box.f_82291_ + 1.0, box.f_82292_ + box.m_82376_() / 2.0, box.f_82293_ + 1.0);
        for (Player player : this.m_9236_().m_6907_()) {
            Entity entity;
            if (player.m_5833_() || (entity = player.m_20201_()) instanceof HappyGhast || !topSurface.m_82390_(player.m_20182_())) continue;
            return true;
        }
        return false;
    }

    protected BodyRotationControl m_7560_() {
        return new GhastBodyRotationControl(this);
    }

    public boolean m_5829_() {
        if (!this.m_6162_() && this.m_6084_()) {
            return this.m_20160_() || this.isOnStillTimeout();
        }
        return false;
    }

    static class GhastMoveControl
    extends MoveControl {
        private final HappyGhast ghast;
        private int floatDuration;
        private final boolean careful;
        private final BooleanSupplier shouldBeStopped;

        public GhastMoveControl(HappyGhast ghast, boolean careful, BooleanSupplier shouldBeStopped) {
            super((Mob)ghast);
            this.ghast = ghast;
            this.careful = careful;
            this.shouldBeStopped = shouldBeStopped;
        }

        public void m_8126_() {
            if (this.shouldBeStopped.getAsBoolean()) {
                this.f_24981_ = MoveControl.Operation.WAIT;
                this.ghast.stopInPlace();
            }
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && this.floatDuration-- <= 0) {
                this.floatDuration += this.ghast.m_217043_().m_188503_(5) + 2;
                Vec3 target = new Vec3(this.f_24975_ - this.ghast.m_20185_(), this.f_24976_ - this.ghast.m_20186_(), this.f_24977_ - this.ghast.m_20189_());
                if (this.canReach(target)) {
                    this.ghast.m_20256_(this.ghast.m_20184_().m_82549_(target.m_82541_().m_82490_(this.ghast.m_21133_(Attributes.f_22280_) * 5.0 / 3.0)));
                } else {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                }
            }
        }

        private boolean canReach(Vec3 target) {
            AABB entityBox = this.ghast.m_20191_();
            AABB targetBox = entityBox.m_82383_(target);
            if (this.careful) {
                for (BlockPos position : BlockPosUtils.betweenClosed(targetBox.m_82400_(1.0))) {
                    if (this.blockTraversalPossible((BlockGetter)this.ghast.m_9236_(), null, null, position, false, false)) continue;
                    return false;
                }
            }
            boolean inWater = this.ghast.m_20069_();
            boolean inLava = this.ghast.m_20077_();
            Vec3 currentPos = this.ghast.m_20182_();
            Vec3 targetPos = currentPos.m_82549_(target);
            return BlockPosUtils.forEachBlockIntersectedBetween(currentPos, targetPos, targetBox, (pos, step) -> CollisionUtils.intersects(entityBox, pos) || this.blockTraversalPossible((BlockGetter)this.ghast.m_9236_(), currentPos, targetPos, pos, inWater, inLava));
        }

        private boolean blockTraversalPossible(BlockGetter level, @Nullable Vec3 origin, @Nullable Vec3 target, BlockPos pos, boolean inWater, boolean inLava) {
            boolean noCollisionDetected;
            boolean hasValidPath;
            BlockState state = level.m_8055_(pos);
            if (state.m_60795_()) {
                return true;
            }
            boolean bl = hasValidPath = origin != null && target != null;
            boolean bl2 = hasValidPath ? !CollisionUtils.collidedWithShapeMovingFrom((LivingEntity)this.ghast, origin, target, state.m_60812_(level, pos).m_83216_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()).m_83299_()) : (noCollisionDetected = state.m_60812_(level, pos).m_83281_());
            if (!this.careful) {
                return noCollisionDetected;
            }
            if (state.m_204336_(ModBlockTags.HAPPY_GHAST_AVOIDS)) {
                return false;
            }
            FluidState fluidState = level.m_6425_(pos);
            if (!(fluidState.m_76178_() || hasValidPath && !CollisionUtils.collidedWithFluid((LivingEntity)this.ghast, fluidState, pos, origin, target))) {
                if (fluidState.m_205070_(FluidTags.f_13131_)) {
                    return inWater;
                }
                if (fluidState.m_205070_(FluidTags.f_13132_)) {
                    return inLava;
                }
            }
            return noCollisionDetected;
        }
    }

    class HappyGhastLookControl
    extends LookControl {
        HappyGhastLookControl() {
            super((Mob)HappyGhast.this);
        }

        public void m_8128_() {
            if (HappyGhast.this.isOnStillTimeout()) {
                float degrees = HappyGhastLookControl.wrapDegrees90(HappyGhast.this.m_146908_());
                HappyGhast.this.m_146922_(HappyGhast.this.m_146908_() - degrees);
                HappyGhast.this.m_5616_(HappyGhast.this.m_146908_());
            } else if (this.f_186068_ > 0) {
                --this.f_186068_;
                double x = this.f_24941_ - HappyGhast.this.m_20185_();
                double z = this.f_24943_ - HappyGhast.this.m_20189_();
                HappyGhast.this.m_146922_(-((float)Mth.m_14136_((double)x, (double)z)) * 57.295776f);
                HappyGhast.this.f_20885_ = HappyGhast.this.f_20883_ = HappyGhast.this.m_146908_();
            } else {
                if (HappyGhast.this.m_20160_() && HappyGhast.this.m_6688_() instanceof Player) {
                    return;
                }
                Vec3 motion = this.f_24937_.m_20184_();
                this.f_24937_.m_146922_(-((float)Mth.m_14136_((double)motion.f_82479_, (double)motion.f_82481_)) * 57.295776f);
                this.f_24937_.f_20883_ = this.f_24937_.m_146908_();
            }
        }

        public static float wrapDegrees90(float degrees) {
            float result = degrees % 90.0f;
            if (result >= 45.0f) {
                result -= 90.0f;
            }
            if (result < -45.0f) {
                result += 90.0f;
            }
            return result;
        }
    }

    static class BabyFlyingPathNavigation
    extends FlyingPathNavigation {
        public BabyFlyingPathNavigation(Mob mob, Level level) {
            super(mob, level);
            this.m_26440_(false);
            this.m_7008_(true);
        }

        protected boolean m_183431_(Vec3 posVec31, Vec3 posVec32) {
            return BabyFlyingPathNavigation.m_262402_((Mob)this.f_26494_, (Vec3)posVec31, (Vec3)posVec32, (boolean)false);
        }
    }

    static class GhastFloatGoal
    extends FloatGoal {
        private final HappyGhast ghast;

        public GhastFloatGoal(HappyGhast ghast) {
            super((Mob)ghast);
            this.ghast = ghast;
        }

        public boolean m_8036_() {
            return !this.ghast.isOnStillTimeout() && super.m_8036_();
        }
    }

    static class RandomFloatAroundGoal
    extends Goal {
        private final HappyGhast ghast;
        private final int distanceToBlocks;

        public RandomFloatAroundGoal(HappyGhast ghast, int distanceToBlocks) {
            this.ghast = ghast;
            this.distanceToBlocks = distanceToBlocks;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            double z;
            double y;
            MoveControl control = this.ghast.m_21566_();
            if (!control.m_24995_()) {
                return true;
            }
            double x = control.m_25000_() - this.ghast.m_20185_();
            double distance = x * x + (y = control.m_25001_() - this.ghast.m_20186_()) * y + (z = control.m_25002_() - this.ghast.m_20189_()) * z;
            return distance < 1.0 || distance > 3600.0;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8056_() {
            Vec3 target = RandomFloatAroundGoal.getSuitableFlyToPosition((Mob)this.ghast, this.distanceToBlocks);
            this.ghast.m_21566_().m_6849_(target.m_7096_(), target.m_7098_(), target.m_7094_(), 1.0);
        }

        public static Vec3 getSuitableFlyToPosition(Mob mob, int distanceToBlocks) {
            BlockPos pos;
            int floor;
            Level level = mob.m_9236_();
            RandomSource random = mob.m_217043_();
            Vec3 origin = mob.m_20182_();
            Vec3 target = null;
            for (int attempt = 0; attempt < 64; ++attempt) {
                target = RandomFloatAroundGoal.chooseRandomPositionWithRestriction(mob, origin, random);
                if (target == null || !RandomFloatAroundGoal.isGoodTarget(level, target, distanceToBlocks)) continue;
                return target;
            }
            if (target == null) {
                target = RandomFloatAroundGoal.chooseRandomPosition(origin, random);
            }
            if ((floor = level.m_6924_(Heightmap.Types.MOTION_BLOCKING, (pos = BlockPos.m_274446_(target)).m_123341_(), pos.m_123343_())) < pos.m_123342_() && floor > level.m_141937_()) {
                target = new Vec3(target.m_7096_(), mob.m_20186_() - Math.abs(mob.m_20186_() - target.m_7098_()), target.m_7094_());
            }
            return target;
        }

        private static boolean isGoodTarget(Level level, Vec3 target, int distanceToBlocks) {
            if (distanceToBlocks <= 0) {
                return true;
            }
            BlockPos pos = BlockPos.m_274446_((Position)target);
            if (level.m_8055_(pos).m_60795_()) {
                for (Direction direction : Direction.values()) {
                    for (int distance = 1; distance < distanceToBlocks; ++distance) {
                        BlockPos neighbor = pos.m_5484_(direction, distance);
                        if (level.m_8055_(neighbor).m_60795_()) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        private static Vec3 chooseRandomPosition(Vec3 origin, RandomSource random) {
            double x = origin.m_7096_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 16.0f);
            double y = origin.m_7098_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 16.0f);
            double z = origin.m_7094_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 16.0f);
            return new Vec3(x, y, z);
        }

        @Nullable
        private static Vec3 chooseRandomPositionWithRestriction(Mob mob, Vec3 origin, RandomSource random) {
            Vec3 target = RandomFloatAroundGoal.chooseRandomPosition(origin, random);
            return mob.m_21536_() && !mob.m_21444_(BlockPos.m_274446_((Position)target)) ? null : target;
        }
    }

    static class GhastBodyRotationControl
    extends BodyRotationControl {
        private final HappyGhast ghast;

        public GhastBodyRotationControl(HappyGhast ghast) {
            super((Mob)ghast);
            this.ghast = ghast;
        }

        public void m_8121_() {
            if (this.ghast.m_20160_()) {
                this.ghast.f_20883_ = this.ghast.f_20885_ = this.ghast.m_146908_();
            }
            super.m_8121_();
        }
    }
}

