/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.common.worldgen.treedecorators;

import com.blackgear.vanillabackport.common.registries.ModTreeDecorators;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import net.minecraft.world.level.levelgen.structure.BoundingBox;

public class PlaceOnGroundDecorator
extends TreeDecorator {
    public static final Codec<PlaceOnGroundDecorator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.f_144629_.fieldOf("tries").orElse((Object)128).forGetter(decorator -> decorator.tries), (App)ExtraCodecs.f_144628_.fieldOf("radius").orElse((Object)2).forGetter(decorator -> decorator.radius), (App)ExtraCodecs.f_144628_.fieldOf("height").orElse((Object)1).forGetter(decorator -> decorator.height), (App)BlockStateProvider.f_68747_.fieldOf("block_state_provider").forGetter(decorator -> decorator.blockStateProvider)).apply((Applicative)instance, PlaceOnGroundDecorator::new));
    private final int tries;
    private final int radius;
    private final int height;
    private final BlockStateProvider blockStateProvider;

    public PlaceOnGroundDecorator(int tries, int radius, int height, BlockStateProvider blockStateProvider) {
        this.tries = tries;
        this.radius = radius;
        this.height = height;
        this.blockStateProvider = blockStateProvider;
    }

    protected TreeDecoratorType<?> m_6663_() {
        return ModTreeDecorators.PLACE_ON_GROUND.get();
    }

    public void m_214187_(TreeDecorator.Context context) {
        ArrayList list = Lists.newArrayList();
        ObjectArrayList list2 = context.m_226070_();
        ObjectArrayList list3 = context.m_226068_();
        if (list2.isEmpty()) {
            list.addAll(list3);
        } else if (!list3.isEmpty() && ((BlockPos)list2.get(0)).m_123342_() == ((BlockPos)list3.get(0)).m_123342_()) {
            list.addAll(list3);
            list.addAll(list2);
        } else {
            list.addAll(list2);
        }
        if (!list.isEmpty()) {
            BlockPos blockPos = (BlockPos)list.get(0);
            int i = blockPos.m_123342_();
            int j = blockPos.m_123341_();
            int k = blockPos.m_123341_();
            int l = blockPos.m_123343_();
            int m = blockPos.m_123343_();
            for (BlockPos blockPos2 : list) {
                if (blockPos2.m_123342_() != i) continue;
                j = Math.min(j, blockPos2.m_123341_());
                k = Math.max(k, blockPos2.m_123341_());
                l = Math.min(l, blockPos2.m_123343_());
                m = Math.max(m, blockPos2.m_123343_());
            }
            RandomSource randomSource = context.m_226067_();
            BoundingBox base = new BoundingBox(j, i, l, k, i, m);
            BoundingBox boundingBox = new BoundingBox(base.m_162395_() - this.radius, base.m_162396_() - this.height, base.m_162398_() - this.radius, base.m_162399_() + this.radius, base.m_162400_() + this.height, base.m_162401_() + this.radius);
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
            for (int n = 0; n < this.tries; ++n) {
                mutableBlockPos.m_122178_(randomSource.m_216332_(boundingBox.m_162395_(), boundingBox.m_162399_()), randomSource.m_216332_(boundingBox.m_162396_(), boundingBox.m_162400_()), randomSource.m_216332_(boundingBox.m_162398_(), boundingBox.m_162401_()));
                this.attemptToPlaceBlockAbove(context, (BlockPos)mutableBlockPos);
            }
        }
    }

    private void attemptToPlaceBlockAbove(TreeDecorator.Context context, BlockPos pos) {
        BlockPos above = pos.m_7494_();
        if (context.m_226058_().m_7433_(above, state -> state.m_60795_() || state.m_60713_(Blocks.f_50191_)) && context.m_226058_().m_7433_(pos, state -> state.m_60804_((BlockGetter)context.m_226058_(), pos)) && context.m_226058_().m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, pos).m_123342_() <= above.m_123342_()) {
            context.m_226061_(above, this.blockStateProvider.m_213972_(context.m_226067_(), above));
        }
    }
}

