/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.resourcify.libs.commonmark.ext.gfm.strikethrough.internal;

import dev.dediamondpro.resourcify.libs.commonmark.ext.gfm.strikethrough.Strikethrough;
import dev.dediamondpro.resourcify.libs.commonmark.node.Node;
import dev.dediamondpro.resourcify.libs.commonmark.node.Nodes;
import dev.dediamondpro.resourcify.libs.commonmark.node.SourceSpans;
import dev.dediamondpro.resourcify.libs.commonmark.node.Text;
import dev.dediamondpro.resourcify.libs.commonmark.parser.delimiter.DelimiterProcessor;
import dev.dediamondpro.resourcify.libs.commonmark.parser.delimiter.DelimiterRun;

public class StrikethroughDelimiterProcessor
implements DelimiterProcessor {
    private final boolean requireTwoTildes;

    public StrikethroughDelimiterProcessor() {
        this(false);
    }

    public StrikethroughDelimiterProcessor(boolean requireTwoTildes) {
        this.requireTwoTildes = requireTwoTildes;
    }

    @Override
    public char getOpeningCharacter() {
        return '~';
    }

    @Override
    public char getClosingCharacter() {
        return '~';
    }

    @Override
    public int getMinLength() {
        return this.requireTwoTildes ? 2 : 1;
    }

    @Override
    public int process(DelimiterRun openingRun, DelimiterRun closingRun) {
        if (openingRun.length() == closingRun.length() && openingRun.length() <= 2) {
            Text opener = openingRun.getOpener();
            Strikethrough strikethrough = new Strikethrough();
            SourceSpans sourceSpans = new SourceSpans();
            sourceSpans.addAllFrom(openingRun.getOpeners(openingRun.length()));
            for (Node node2 : Nodes.between(opener, closingRun.getCloser())) {
                strikethrough.appendChild(node2);
                sourceSpans.addAll(node2.getSourceSpans());
            }
            sourceSpans.addAllFrom(closingRun.getClosers(closingRun.length()));
            strikethrough.setSourceSpans(sourceSpans.getSourceSpans());
            opener.insertAfter(strikethrough);
            return openingRun.length();
        }
        return 0;
    }
}

