/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.common.fluid;

import earth.terrarium.botarium.common.fluid.base.FluidContainer;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.base.FluidSnapshot;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class CreativeFluidContainer
implements FluidContainer {
    public static final Long CAPACITY = Integer.MAX_VALUE;
    private final BiPredicate<Integer, FluidHolder> fluidFilter;
    private FluidHolder fluid;

    public CreativeFluidContainer(BiPredicate<Integer, FluidHolder> fluidFilter) {
        this.fluidFilter = fluidFilter;
    }

    public long insertFluid(FluidHolder fluid, boolean simulate) {
        if (this.isEmpty() && this.fluidFilter.test(0, fluid)) {
            return fluid.getFluidAmount();
        }
        return 0L;
    }

    public FluidHolder extractFluid(FluidHolder fluid, boolean simulate) {
        if (this.isEmpty() || !this.fluidFilter.test(0, fluid) || !this.fluid.matches(fluid)) {
            return FluidHolder.empty();
        }
        return this.fluid.copyWithAmount(fluid.getFluidAmount());
    }

    public void setFluid(int slot, FluidHolder fluid) {
        if (slot == 0) {
            this.fluid = fluid.copyHolder();
        }
    }

    public List<FluidHolder> getFluids() {
        if (this.isEmpty()) {
            return List.of(FluidHolder.empty());
        }
        return List.of(this.fluid.copyWithAmount(CAPACITY.longValue()));
    }

    public int getSize() {
        return 1;
    }

    public boolean isEmpty() {
        return this.fluid.isEmpty();
    }

    public FluidContainer copy() {
        return new CreativeFluidContainer(this.fluidFilter);
    }

    public long getTankCapacity(int tankSlot) {
        return CAPACITY;
    }

    public void fromContainer(FluidContainer container) {
        this.fluid = container.getSize() > 0 ? ((FluidHolder)container.getFluids().get(0)).copyHolder() : FluidHolder.empty();
    }

    public long extractFromSlot(FluidHolder fluidHolder, FluidHolder toInsert, Runnable snapshot) {
        return 0L;
    }

    public boolean allowsInsertion() {
        return this.fluid.isEmpty();
    }

    public boolean allowsExtraction() {
        return !this.fluid.isEmpty();
    }

    public FluidSnapshot createSnapshot() {
        return new FluidSnapshot(){

            public void loadSnapshot(FluidContainer container) {
            }
        };
    }

    public void deserialize(CompoundTag root) {
        CompoundTag tag = root.m_128469_("BotariumData");
        ListTag fluids = tag.m_128437_("StoredFluids", 10);
        if (fluids.size() > 0) {
            CompoundTag fluid = fluids.m_128728_(0);
            this.fluid = FluidHolder.fromCompound((CompoundTag)fluid);
        } else {
            this.fluid = FluidHolder.empty();
        }
    }

    public CompoundTag serialize(CompoundTag root) {
        CompoundTag tag = root.m_128469_("BotariumData");
        root.m_128365_("BotariumData", (Tag)tag);
        ListTag fluids = new ListTag();
        fluids.add((Object)this.fluid.serialize());
        tag.m_128365_("StoredFluids", (Tag)fluids);
        return root;
    }

    public void m_6211_() {
        this.fluid = FluidHolder.empty();
    }
}

