/*
 * Decompiled with CFR 0.152.
 */
package dev.schmarrn.lighty.mode;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.schmarrn.lighty.api.LightyColors;
import dev.schmarrn.lighty.api.LightyHelper;
import dev.schmarrn.lighty.api.LightyMode;
import dev.schmarrn.lighty.api.ModeManager;
import dev.schmarrn.lighty.config.Config;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class CarpetMode
extends LightyMode {
    @Override
    public void beforeCompute(BufferBuilder builder) {
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85811_);
    }

    @Override
    public void compute(ClientLevel world, BlockPos pos, BufferBuilder builder) {
        BlockPos posUp = pos.m_7494_();
        BlockState up = world.m_8055_(posUp);
        BlockState block = world.m_8055_(pos);
        if (LightyHelper.isBlocked(block, up, world, pos, posUp)) {
            return;
        }
        int blockLightLevel = world.m_45517_(LightLayer.BLOCK, posUp);
        int skyLightLevel = world.m_45517_(LightLayer.SKY, posUp);
        if (LightyHelper.isSafe(blockLightLevel) && !Config.getShowSafe()) {
            return;
        }
        int color = LightyColors.getARGB(blockLightLevel, skyLightLevel);
        double offset = LightyHelper.getOffset(up, posUp, world);
        if (offset == -1.0) {
            return;
        }
        double x = pos.m_123341_();
        double y = (double)(pos.m_123342_() + 1) + offset;
        double z = pos.m_123343_();
        int overlayBrightness = Config.getOverlayBrightness();
        int lightmap = LightTexture.m_109885_((int)overlayBrightness, (int)overlayBrightness);
        builder.m_5483_(x, y + 0.0625, z).m_193479_(color).m_7421_(0.0f, 0.0f).m_85969_(lightmap).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_5483_(x, y + 0.0625, z + 1.0).m_193479_(color).m_7421_(0.0f, 1.0f).m_85969_(lightmap).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_5483_(x + 1.0, y + 0.0625, z + 1.0).m_193479_(color).m_7421_(1.0f, 1.0f).m_85969_(lightmap).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_5483_(x + 1.0, y + 0.0625, z).m_193479_(color).m_7421_(1.0f, 0.0f).m_85969_(lightmap).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        if (offset > (double)0.001f) {
            pos = pos.m_7494_();
        }
        if (Block.m_152444_((BlockState)Blocks.f_50069_.m_49966_(), (BlockGetter)world, (BlockPos)pos, (Direction)Direction.SOUTH, (BlockPos)pos.m_121945_(Direction.SOUTH))) {
            builder.m_5483_(x, y + 0.0625, z + 1.0).m_193479_(color).m_7421_(0.0f, 0.0625f).m_85969_(lightmap).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
            builder.m_5483_(x, y, z + 1.0).m_193479_(color).m_7421_(0.0f, 0.0f).m_85969_(lightmap).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
            builder.m_5483_(x + 1.0, y, z + 1.0).m_193479_(color).m_7421_(1.0f, 0.0f).m_85969_(lightmap).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
            builder.m_5483_(x + 1.0, y + 0.0625, z + 1.0).m_193479_(color).m_7421_(1.0f, 0.0625f).m_85969_(lightmap).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        }
        if (Block.m_152444_((BlockState)Blocks.f_50069_.m_49966_(), (BlockGetter)world, (BlockPos)pos, (Direction)Direction.WEST, (BlockPos)pos.m_121945_(Direction.WEST))) {
            builder.m_5483_(x, y + 0.0625, z).m_193479_(color).m_7421_(0.0f, 0.0625f).m_85969_(lightmap).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
            builder.m_5483_(x, y, z).m_193479_(color).m_7421_(0.0f, 0.0f).m_85969_(lightmap).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
            builder.m_5483_(x, y, z + 1.0).m_193479_(color).m_7421_(1.0f, 0.0f).m_85969_(lightmap).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
            builder.m_5483_(x, y + 0.0625, z + 1.0).m_193479_(color).m_7421_(1.0f, 0.0625f).m_85969_(lightmap).m_5601_(-1.0f, 0.0f, 0.0f).m_5752_();
        }
        if (Block.m_152444_((BlockState)Blocks.f_50069_.m_49966_(), (BlockGetter)world, (BlockPos)pos, (Direction)Direction.NORTH, (BlockPos)pos.m_121945_(Direction.NORTH))) {
            builder.m_5483_(x + 1.0, y + 0.0625, z).m_193479_(color).m_7421_(0.0f, 0.0625f).m_85969_(lightmap).m_5601_(0.0f, 0.0f, 1.0f).m_5752_();
            builder.m_5483_(x + 1.0, y, z).m_193479_(color).m_7421_(0.0f, 0.0f).m_85969_(lightmap).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
            builder.m_5483_(x, y, z).m_193479_(color).m_7421_(1.0f, 0.0f).m_85969_(lightmap).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
            builder.m_5483_(x, y + 0.0625, z).m_193479_(color).m_7421_(1.0f, 0.0625f).m_85969_(lightmap).m_5601_(0.0f, 0.0f, -1.0f).m_5752_();
        }
        if (Block.m_152444_((BlockState)Blocks.f_50069_.m_49966_(), (BlockGetter)world, (BlockPos)pos, (Direction)Direction.EAST, (BlockPos)pos.m_121945_(Direction.EAST))) {
            builder.m_5483_(x + 1.0, y + 0.0625, z + 1.0).m_193479_(color).m_7421_(0.0f, 0.0625f).m_85969_(lightmap).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
            builder.m_5483_(x + 1.0, y, z + 1.0).m_193479_(color).m_7421_(0.0f, 0.0f).m_85969_(lightmap).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
            builder.m_5483_(x + 1.0, y, z).m_193479_(color).m_7421_(1.0f, 0.0f).m_85969_(lightmap).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
            builder.m_5483_(x + 1.0, y + 0.0625, z).m_193479_(color).m_7421_(1.0f, 0.0625f).m_85969_(lightmap).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        }
    }

    @Override
    public void beforeRendering() {
        RenderType.m_110466_().m_110185_();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("lighty", "textures/block/transparent.png"));
        RenderSystem.enableDepthTest();
    }

    @Override
    public void afterRendering() {
        RenderType.m_110466_().m_110188_();
        RenderSystem.disableDepthTest();
    }

    public static void init() {
        ModeManager.registerMode(new ResourceLocation("lighty", "carpet_mode"), new CarpetMode());
    }
}

