/*
 * Decompiled with CFR 0.152.
 */
package dev.schmarrn.lighty.mode;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.schmarrn.lighty.api.LightyColors;
import dev.schmarrn.lighty.api.LightyHelper;
import dev.schmarrn.lighty.api.LightyMode;
import dev.schmarrn.lighty.api.ModeManager;
import dev.schmarrn.lighty.config.Config;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;

public class NumberMode
extends LightyMode {
    private static final float PXL = 0.0625f;
    private static final float dx = 0.25f;
    private static final float dz = 0.25f;

    @Override
    public void beforeCompute(BufferBuilder builder) {
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85811_);
    }

    private static void renderDigit(BufferBuilder builder, int digit, float x, float y, float z, int color, int lightmap) {
        float startU = (float)(3 & digit) / 4.0f;
        float startV = (float)(digit >> 2 & 3) / 4.0f;
        builder.m_5483_((double)x, (double)y, (double)z).m_193479_(color).m_7421_(startU, startV).m_85969_(lightmap).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_5483_((double)x, (double)y, (double)(z + 0.25f)).m_193479_(color).m_7421_(startU, startV + 0.25f).m_85969_(lightmap).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_5483_((double)(x + 0.25f), (double)y, (double)(z + 0.25f)).m_193479_(color).m_7421_(startU + 0.25f, startV + 0.25f).m_85969_(lightmap).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_5483_((double)(x + 0.25f), (double)y, (double)z).m_193479_(color).m_7421_(startU + 0.25f, startV).m_85969_(lightmap).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
    }

    private static void renderNumber(BufferBuilder builder, int number, float x, float y, float z, int color, int lightmap) {
        int oneDigit = number % 10;
        int tenDigit = number / 10;
        if (tenDigit > 0) {
            NumberMode.renderDigit(builder, tenDigit, x, y, z, color, lightmap);
            NumberMode.renderDigit(builder, oneDigit, x + 0.25f - 0.0625f, y, z, color, lightmap);
        } else {
            NumberMode.renderDigit(builder, oneDigit, x + 0.09375f, y, z, color, lightmap);
        }
    }

    @Override
    public void compute(ClientLevel world, BlockPos pos, BufferBuilder builder) {
        BlockPos posUp = pos.m_7494_();
        BlockState up = world.m_8055_(posUp);
        BlockState block = world.m_8055_(pos);
        if (LightyHelper.isBlocked(block, up, world, pos, posUp)) {
            return;
        }
        int blockLightLevel = world.m_45517_(LightLayer.BLOCK, posUp);
        int skyLightLevel = world.m_45517_(LightLayer.SKY, posUp);
        if (LightyHelper.isSafe(blockLightLevel) && !Config.getShowSafe()) {
            return;
        }
        int color = LightyColors.getARGB(blockLightLevel, skyLightLevel);
        float offset = LightyHelper.getOffset(up, posUp, world);
        if (offset == -1.0f) {
            return;
        }
        float x1 = (float)pos.m_123341_() + 0.328125f;
        float y = (float)pos.m_123342_() + 1.0f + 0.005f + offset;
        float z1 = (float)pos.m_123343_() + 0.25f;
        int overlayBrightness = Config.getOverlayBrightness();
        int lightmap = LightTexture.m_109885_((int)overlayBrightness, (int)overlayBrightness);
        NumberMode.renderNumber(builder, blockLightLevel, x1, y, z1, color, lightmap);
        NumberMode.renderNumber(builder, skyLightLevel, x1, y, z1 + 0.3f, color, lightmap);
    }

    @Override
    public void beforeRendering() {
        RenderType.m_110463_().m_110185_();
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("lighty", "textures/block/numbers.png"));
    }

    public static void init() {
        ModeManager.registerMode(new ResourceLocation("lighty", "number_mode"), new NumberMode());
    }
}

