/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.entity.throwable;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import ttv.migami.jeg.Config;
import ttv.migami.jeg.common.network.ServerPlayHandler;
import ttv.migami.jeg.entity.throwable.GrenadeEntity;
import ttv.migami.jeg.entity.throwable.ThrowableItemEntity;
import ttv.migami.jeg.init.ModEntities;
import ttv.migami.jeg.init.ModItems;
import ttv.migami.jeg.init.ModParticleTypes;

public class ThrowableGrenadeEntity
extends ThrowableItemEntity {
    public float rotation;
    public float prevRotation;
    public boolean terrorPhantomThrown = false;
    public boolean playerOwnedTerrorPhantom = false;

    public ThrowableGrenadeEntity(EntityType<? extends ThrowableItemEntity> entityType, Level worldIn) {
        super(entityType, worldIn);
    }

    public ThrowableGrenadeEntity(EntityType<? extends ThrowableItemEntity> entityType, Level world, LivingEntity entity) {
        super(entityType, world, entity);
        this.setShouldBounce(true);
        this.setGravityVelocity(0.05f);
        this.setItem(new ItemStack((ItemLike)ModItems.GRENADE.get()));
        this.setMaxLife(60);
        this.m_5602_((Entity)entity);
    }

    public ThrowableGrenadeEntity(Level world, LivingEntity entity, int timeLeft) {
        super((EntityType<? extends ThrowableItemEntity>)((EntityType)ModEntities.THROWABLE_GRENADE.get()), world, entity);
        this.setShouldBounce(true);
        this.setGravityVelocity(0.05f);
        this.setItem(new ItemStack((ItemLike)ModItems.GRENADE.get()));
        this.setMaxLife(timeLeft);
        this.m_5602_((Entity)entity);
    }

    protected void m_8097_() {
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.prevRotation = this.rotation;
        double speed = this.m_20184_().m_82553_();
        this.particleTick();
        Entity entity = this.m_19749_();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            ServerPlayHandler.doPanicVillagersAndHostiles(livingEntity, this.m_20182_(), 3);
        }
    }

    public void particleTick() {
        Level level;
        if (this.m_9236_().f_46443_) {
            this.m_9236_().m_6493_((ParticleOptions)ParticleTypes.f_123762_, true, this.m_20185_(), this.m_20186_() + 0.25, this.m_20189_(), 0.0, 0.0, 0.0);
        }
        if ((level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.f_19797_ > 1 && this.terrorPhantomThrown && this.m_9236_().f_46441_.m_188503_(2) == 0) {
                ServerPlayHandler.sendParticlesToAll(serverLevel, (SimpleParticleType)ModParticleTypes.FIRE.get(), true, this.m_20185_() - this.m_20184_().m_7096_(), this.m_20186_() - this.m_20184_().m_7098_(), this.m_20189_() - this.m_20184_().m_7094_(), 1, 0.0, 0.0, 0.0, 0.0);
                ServerPlayHandler.sendParticlesToAll(serverLevel, ParticleTypes.f_123756_, true, this.m_20185_() - this.m_20184_().m_7096_(), this.m_20186_() - this.m_20184_().m_7098_(), this.m_20189_() - this.m_20184_().m_7094_(), 1, 0.0, 0.0, 0.0, 0.0);
                ServerPlayHandler.sendParticlesToAll(serverLevel, ParticleTypes.f_123744_, true, this.m_20185_() - this.m_20184_().m_7096_(), this.m_20186_() - this.m_20184_().m_7098_(), this.m_20189_() - this.m_20184_().m_7094_(), 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public void onDeath() {
        if (this.playerOwnedTerrorPhantom) {
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                double radius = 10.0;
                double maxDamage = 80.0;
                AABB area = new AABB(this.m_20183_()).m_82400_(radius);
                serverLevel.m_245803_((Entity)this, this.m_20183_(), SoundEvents.f_11913_, SoundSource.HOSTILE, 5.0f, 1.0f);
                for (LivingEntity entity : this.m_9236_().m_45976_(LivingEntity.class, area)) {
                    double distance;
                    if (!(entity instanceof Enemy) && !(entity instanceof Player) || !((distance = this.m_20182_().m_82554_(entity.m_20182_())) <= radius)) continue;
                    double damage = maxDamage * (1.0 - distance / radius);
                    entity.m_6469_(entity.m_269291_().m_269036_(this.m_19749_(), this.m_19749_()), (float)damage);
                }
                ServerPlayHandler.sendParticlesToAll(serverLevel, (SimpleParticleType)ModParticleTypes.BIG_EXPLOSION.get(), true, this.m_20185_() - this.m_20184_().m_7096_(), this.m_20186_() - this.m_20184_().m_7098_(), this.m_20189_() - this.m_20184_().m_7094_(), 1, 0.0, 0.0, 0.0, 0.0);
            }
        } else if (this.terrorPhantomThrown && ((Boolean)Config.COMMON.gunnerMobs.terrorPhantomDestroyBlocks.get()).booleanValue()) {
            GrenadeEntity.createExplosion((Entity)this, ((Double)Config.COMMON.grenades.explosionRadius.get()).floatValue(), false);
        } else {
            GrenadeEntity.createExplosion((Entity)this, ((Double)Config.COMMON.grenades.explosionRadius.get()).floatValue(), true);
        }
    }
}

