/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.modules.capacity;

import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.library.json.LevelingInt;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierManager;
import slimeknights.tconstruct.library.modifiers.hook.special.CapacityBarHook;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.INumericToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class CapacityBarModule
extends CapacityBarHook.PersistentDataCapacityBar
implements ModifierModule {
    public static final RecordLoadable<CapacityBarModule> LOADER = RecordLoadable.create((RecordField)ContextKey.ID.requiredField(), (RecordField)LevelingInt.LOADABLE.directField(m -> m.capacity), (RecordField)ToolStats.NUMERIC_LOADER.nullableField("multiplier", m -> m.multiplier), CapacityBarModule::new);
    private final LevelingInt capacity;
    @Nullable
    private final INumericToolStat<?> multiplier;

    public CapacityBarModule(ResourceLocation key, LevelingInt capacity, @Nullable INumericToolStat<?> multiplier) {
        super(key);
        this.capacity = capacity;
        this.multiplier = multiplier;
    }

    public CapacityBarModule(LevelingInt capacity, @Nullable INumericToolStat<?> multiplier) {
        this(ModifierManager.EMPTY, capacity, multiplier);
    }

    public RecordLoadable<CapacityBarModule> getLoader() {
        return LOADER;
    }

    @Override
    public int getCapacity(IToolStackView tool, ModifierEntry entry) {
        int capacity = this.capacity.compute(entry.getEffectiveLevel());
        if (this.multiplier != null) {
            capacity = (int)((float)capacity * tool.getMultiplier(this.multiplier));
        }
        return capacity;
    }
}

