/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.context;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import slimeknights.mantle.util.CombatHelper;
import slimeknights.mantle.util.OffhandCooldownTracker;
import slimeknights.tconstruct.common.TinkerDamageTypes;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.tools.helper.ToolAttackUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.library.utils.Util;

public class ToolAttackContext {
    @Nonnull
    private final LivingEntity attacker;
    @Nullable
    private final Player playerAttacker;
    @Nonnull
    private final InteractionHand hand;
    @Nonnull
    private final EquipmentSlot slotType;
    @Nullable
    private final Projectile projectile;
    @Nonnull
    private final Entity target;
    @Nullable
    private final LivingEntity livingTarget;
    private final float baseDamage;
    private final float baseKnockback;
    private final float cooldown;
    private final float criticalModifier;
    private final boolean isExtraAttack;
    private final SoundEvent sound;

    @Deprecated(forRemoval=true)
    public ToolAttackContext(LivingEntity attacker, @Nullable Player playerAttacker, InteractionHand hand, EquipmentSlot slotType, Entity target, @Nullable LivingEntity livingTarget, boolean isCritical, float cooldown, boolean isExtraAttack) {
        this(attacker, playerAttacker, hand, slotType, null, target, livingTarget, (float)attacker.m_21133_(Attributes.f_22281_), (float)attacker.m_21133_(Attributes.f_22282_) + (livingTarget != null ? 0.4f : 0.0f) + (cooldown > 0.9f && attacker.m_20142_() ? 0.5f : 0.0f), cooldown, isCritical ? 1.5f : 1.0f, isExtraAttack, cooldown > 0.9f ? (attacker.m_20142_() ? SoundEvents.f_12314_ : SoundEvents.f_12316_) : SoundEvents.f_12318_);
    }

    @Deprecated(forRemoval=true)
    public ToolAttackContext(LivingEntity attacker, @Nullable Player playerAttacker, InteractionHand hand, Entity target, @Nullable LivingEntity livingTarget, boolean isCritical, float cooldown, boolean isExtraAttack) {
        this(attacker, playerAttacker, hand, Util.getSlotType(hand), target, livingTarget, isCritical, cooldown, isExtraAttack);
    }

    public boolean isFullyCharged() {
        return this.cooldown > 0.9f;
    }

    public boolean isCritical() {
        return this.criticalModifier > 1.0f;
    }

    public boolean isProjectile() {
        return this.projectile != null;
    }

    public Level getLevel() {
        return this.attacker.m_9236_();
    }

    public DamageSource makeDamageSource() {
        if (this.projectile != null) {
            return CombatHelper.damageSource(TinkerDamageTypes.THROWN_TOOL, (Entity)this.projectile, (Entity)this.attacker);
        }
        if (this.playerAttacker != null) {
            return this.attacker.m_269291_().m_269075_(this.playerAttacker);
        }
        return this.attacker.m_269291_().m_269333_(this.attacker);
    }

    public ToolAttackContext withAOETarget(Entity target, @Nullable LivingEntity livingTarget) {
        return new ToolAttackContext(this.attacker, this.playerAttacker, this.hand, this.slotType, this.projectile, target, livingTarget, this.baseDamage, this.baseKnockback, this.cooldown, 1.0f, true, this.sound);
    }

    public ToolAttackContext withAOETarget(Entity target) {
        return this.withAOETarget(target, ToolAttackUtil.getLivingEntity(target));
    }

    public ToolAttackContext withAOETarget(LivingEntity target) {
        return this.withAOETarget((Entity)target, target);
    }

    public static Builder attacker(LivingEntity attacker, @Nullable Player playerAttacker) {
        return new Builder(attacker, playerAttacker);
    }

    public static Builder attacker(LivingEntity attacker) {
        return ToolAttackContext.attacker(attacker, ModifierUtil.asPlayer((Entity)attacker));
    }

    public static Builder attacker(Player attacker) {
        return ToolAttackContext.attacker((LivingEntity)attacker, attacker);
    }

    @Nonnull
    public LivingEntity getAttacker() {
        return this.attacker;
    }

    @Nullable
    public Player getPlayerAttacker() {
        return this.playerAttacker;
    }

    @Nonnull
    public InteractionHand getHand() {
        return this.hand;
    }

    @Nonnull
    public EquipmentSlot getSlotType() {
        return this.slotType;
    }

    @Nullable
    public Projectile getProjectile() {
        return this.projectile;
    }

    @Nonnull
    public Entity getTarget() {
        return this.target;
    }

    @Nullable
    public LivingEntity getLivingTarget() {
        return this.livingTarget;
    }

    public float getBaseDamage() {
        return this.baseDamage;
    }

    public float getBaseKnockback() {
        return this.baseKnockback;
    }

    public float getCooldown() {
        return this.cooldown;
    }

    public float getCriticalModifier() {
        return this.criticalModifier;
    }

    public boolean isExtraAttack() {
        return this.isExtraAttack;
    }

    public SoundEvent getSound() {
        return this.sound;
    }

    private ToolAttackContext(@Nonnull LivingEntity attacker, @Nullable Player playerAttacker, @Nonnull InteractionHand hand, @Nonnull EquipmentSlot slotType, @Nullable Projectile projectile, @Nonnull Entity target, @Nullable LivingEntity livingTarget, float baseDamage, float baseKnockback, float cooldown, float criticalModifier, boolean isExtraAttack, SoundEvent sound) {
        if (attacker == null) {
            throw new NullPointerException("attacker is marked non-null but is null");
        }
        if (hand == null) {
            throw new NullPointerException("hand is marked non-null but is null");
        }
        if (slotType == null) {
            throw new NullPointerException("slotType is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        this.attacker = attacker;
        this.playerAttacker = playerAttacker;
        this.hand = hand;
        this.slotType = slotType;
        this.projectile = projectile;
        this.target = target;
        this.livingTarget = livingTarget;
        this.baseDamage = baseDamage;
        this.baseKnockback = baseKnockback;
        this.cooldown = cooldown;
        this.criticalModifier = criticalModifier;
        this.isExtraAttack = isExtraAttack;
        this.sound = sound;
    }

    @CanIgnoreReturnValue
    public static class Builder {
        private final LivingEntity attacker;
        @Nullable
        private final Player playerAttacker;
        private InteractionHand hand = InteractionHand.MAIN_HAND;
        private EquipmentSlot slot = EquipmentSlot.MAINHAND;
        @Nullable
        private Projectile projectile;
        private Entity target;
        @Nullable
        private LivingEntity targetLiving;
        private float baseDamage = 0.0f;
        private float baseKnockback = 0.0f;
        private float cooldown = 1.0f;
        private boolean extraAttack = false;
        @Nullable
        private SoundEvent sound = null;

        public Builder target(Entity entity, @Nullable LivingEntity living) {
            this.target = entity;
            this.targetLiving = living;
            return this;
        }

        public Builder target(Entity entity) {
            return this.target(entity, ToolAttackUtil.getLivingEntity(entity));
        }

        public Builder target(LivingEntity living) {
            return this.target((Entity)living, living);
        }

        public Builder slot(EquipmentSlot slotType, InteractionHand hand) {
            this.slot = slotType;
            this.hand = hand;
            return this;
        }

        public Builder hand(InteractionHand hand) {
            return this.slot(Util.getSlotType(hand), hand);
        }

        public Builder applyStats(IToolStackView tool) {
            this.baseDamage = tool.getStats().get(ToolStats.ATTACK_DAMAGE).floatValue();
            return this;
        }

        public Builder applyAttributes() {
            this.baseDamage = (float)this.attacker.m_21133_(Attributes.f_22281_);
            this.baseKnockback = (float)this.attacker.m_21133_(Attributes.f_22282_) / 2.0f;
            return this;
        }

        public Builder toolAttributes(IToolStackView tool) {
            this.baseDamage = ToolAttackUtil.getToolAttribute(tool, this.attacker, Attributes.f_22281_, tool.getStats().get(ToolStats.ATTACK_DAMAGE).floatValue());
            this.baseKnockback = ToolAttackUtil.getToolAttribute(tool, this.attacker, Attributes.f_22282_, this.baseKnockback) / 2.0f;
            return this;
        }

        public Builder cooldown(float cooldown) {
            if (cooldown > 1.0f || cooldown < 0.0f) {
                throw new IllegalArgumentException("Cooldown must be between 0 and 1");
            }
            this.cooldown = cooldown;
            return this;
        }

        public Builder defaultCooldown() {
            if (this.playerAttacker != null) {
                this.cooldown = this.playerAttacker.m_36403_(0.5f);
            }
            return this;
        }

        public Builder offhandCooldown() {
            if (this.playerAttacker != null) {
                this.cooldown = OffhandCooldownTracker.getCooldown((Player)this.playerAttacker);
            }
            return this;
        }

        public Builder extraAttack() {
            this.extraAttack = true;
            return this;
        }

        @CheckReturnValue
        public ToolAttackContext build() {
            SoundEvent sound;
            Entity target = Objects.requireNonNull(this.target, "Must set target to build a tool attack context");
            boolean fullyCharged = this.cooldown > 0.9f;
            float criticalModifier = 1.0f;
            if (!this.extraAttack && this.projectile == null) {
                criticalModifier = ToolAttackUtil.getCriticalModifier(this.attacker, this.playerAttacker, target, this.targetLiving, fullyCharged);
            }
            float baseKnockback = this.baseKnockback;
            if (this.targetLiving != null) {
                baseKnockback += 0.4f;
            }
            if (fullyCharged && this.attacker.m_20142_()) {
                baseKnockback += 0.5f;
            }
            if ((sound = this.sound) == null) {
                sound = criticalModifier > 1.0f ? SoundEvents.f_12313_ : (fullyCharged ? (this.attacker.m_20142_() ? SoundEvents.f_12314_ : SoundEvents.f_12316_) : SoundEvents.f_12318_);
            }
            return new ToolAttackContext(this.attacker, this.playerAttacker, this.hand, this.slot, this.projectile, target, this.targetLiving, this.baseDamage, baseKnockback, this.cooldown, criticalModifier, this.extraAttack, sound);
        }

        private Builder(LivingEntity attacker, @Nullable Player playerAttacker) {
            this.attacker = attacker;
            this.playerAttacker = playerAttacker;
        }

        public Builder projectile(@Nullable Projectile projectile) {
            this.projectile = projectile;
            return this;
        }

        public Builder baseDamage(float baseDamage) {
            this.baseDamage = baseDamage;
            return this;
        }

        public Builder baseKnockback(float baseKnockback) {
            this.baseKnockback = baseKnockback;
            return this;
        }

        public Builder sound(@Nullable SoundEvent sound) {
            this.sound = sound;
            return this;
        }
    }
}

