/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.smeltery.item;

import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class ScaledFluidTank
extends FluidTank {
    private final int scale;

    private ScaledFluidTank(int capacity, int scale) {
        super(capacity * scale);
        this.scale = scale;
    }

    public static FluidTank create(int capacity, int scale) {
        if (scale == 1) {
            return new FluidTank(capacity);
        }
        return new ScaledFluidTank(capacity, scale);
    }

    private int enforceScale(int amount) {
        int remainder = amount % this.scale;
        if (remainder != 0) {
            amount -= remainder;
        }
        return amount;
    }

    private FluidStack enforceScale(FluidStack stack, boolean copy) {
        int remainder = stack.getAmount() % this.scale;
        if (remainder != 0) {
            if (copy) {
                stack = stack.copy();
            }
            stack.shrink(remainder);
        }
        return stack;
    }

    public FluidTank setCapacity(int capacity) {
        return super.setCapacity(this.enforceScale(capacity));
    }

    public void setFluid(FluidStack stack) {
        super.setFluid(this.enforceScale(stack, false));
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return super.fill(this.enforceScale(resource, true), action);
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return super.drain(this.enforceScale(maxDrain), action);
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        return super.drain(this.enforceScale(resource, true), action);
    }

    public FluidTank readFromNBT(CompoundTag nbt) {
        FluidStack fluid = FluidStack.loadFluidStackFromNBT((CompoundTag)nbt);
        fluid.setAmount(fluid.getAmount() * this.scale);
        this.setFluid(fluid);
        return this;
    }

    public CompoundTag writeToNBT(CompoundTag nbt) {
        FluidStack fluid = this.fluid.copy();
        fluid.setAmount(fluid.getAmount() / this.scale);
        fluid.writeToNBT(nbt);
        return nbt;
    }
}

