/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tables.block.entity.chest;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.ItemStackHandler;
import slimeknights.mantle.block.entity.MantleBlockEntity;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.tables.TinkerTables;
import slimeknights.tconstruct.tables.block.entity.chest.AbstractChestBlockEntity;
import slimeknights.tconstruct.tables.block.entity.inventory.IChestItemHandler;

public class TinkersChestBlockEntity
extends AbstractChestBlockEntity {
    public static final String TAG_CHEST_COLOR = "color";
    public static final int DEFAULT_COLOR = 4224646;
    public static final Component NAME = TConstruct.makeTranslation("gui", "tinkers_chest");
    private int color = 4224646;
    private boolean hasColor = false;

    public TinkersChestBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TinkerTables.tinkersChestTile.get(), pos, state, NAME, new TinkersChestItemHandler());
    }

    public void setColor(int color) {
        this.color = color;
        this.hasColor = true;
    }

    @Override
    public boolean canInsert(Player player, ItemStack heldItem) {
        return false;
    }

    public void saveSynced(CompoundTag tags) {
        super.saveSynced(tags);
        if (this.hasColor) {
            tags.m_128405_(TAG_CHEST_COLOR, this.color);
        }
    }

    @Override
    public void m_142466_(CompoundTag tags) {
        super.m_142466_(tags);
        if (tags.m_128425_(TAG_CHEST_COLOR, 99)) {
            this.setColor(tags.m_128451_(TAG_CHEST_COLOR));
        }
    }

    public int getColor() {
        return this.color;
    }

    public boolean hasColor() {
        return this.hasColor;
    }

    public static class TinkersChestItemHandler
    extends ItemStackHandler
    implements IChestItemHandler {
        @Nullable
        private MantleBlockEntity parent;

        public TinkersChestItemHandler() {
            super(64);
        }

        public int getSlotLimit(int slot) {
            return 16;
        }

        @Override
        public int getVisualSize() {
            return this.getSlots();
        }

        protected void onContentsChanged(int slot) {
            if (this.parent != null) {
                this.parent.setChangedFast();
            }
        }

        @Override
        public void setParent(@Nullable MantleBlockEntity parent) {
            this.parent = parent;
        }
    }
}

